/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2010  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 *********************************************************************/

#ifndef CLASS_RATING_MAX_HEADER
#define CLASS_RATING_MAX_HEADER

#include "rating.h"

/**
 ** maximum rater
 ** returns the maximal value of the given values
 **/
class Rating::Max : public Rating
{
  public:
    // constructor
    Max() : Rating(MAX), max_value(INT_MIN) { }
    // destructor
    ~Max() { }

    // adds a value
    void add(int const value)
    {
      if (value > this->max_value)
	this->max_value = value;
    }
    // returns the rated value
    int value() const
    { return this->max_value; }

  private:
    // the maximal value
    int max_value;
}; // class Rating::Max : public Rating

#endif // #ifndef CLASS_RATING_MAX_HEADER
