#!/bin/sh

# compile FreeDoko and run the test party:
# *  mutating rules
# *  no end of the party
# *  four different ai players (standard, profi, offensive, profi unfair)

# non-release-version
nice -n 20 make \
CXXFLAGS="-Wall -Werror -Wno-parentheses -pipe -Os" \
FREEDOKO_WORKING_DIRECTORY="/home/local/tmp/${LOGNAME}/FreeDoko.autotest" \
&& nice -n 20 ./FreeDoko testparty -F 123 "$@" \
; exit


# create program in release version
nice -n 20 make --always-make release_bin && cd ../data
#rm ./FreeDoko; make "CXXFLAGS=-Wall -Werror -Wno-parentheses -pipe -O0 -ggdb" "USE_UI_GTKMM=false" "FREEDOKO_WORKING_DIRECTORY=/tmp/${LOGNAME}/FreeDoko.autotest/src"

# start from ../data, so that all data files are found
nice -20 ../src/./FreeDoko ../src/testparty -F 123 "$@"
# --auto-bug-reports 
