/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2007  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 *********************************************************************/

#include "constants.h"

#ifdef USE_UI_TEXT

#include "ui.h"

#include "general.h"
#include "help.h"
#include "bug_report.h"
#include "settings.h"

#include "../../misc/language.h"

namespace UI_TEXT_NS {

  /**
   **
   ** the party is opened
   **
   ** @param	-
   **
   ** @return	-
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   ** @todo	all
   **
   **/
  void
    UI_Text::party_open()
    {
      DEBUG_CALLING(INFO_UI_TEXT,
		    "UI_Text::party_open()");

#ifndef POSTPHONED
      this->ostr() << "The party is opened." << endl;
#endif
      
      DEBUG_RETURNING(VOID,
		      INFO_UI_TEXT,
		      "UI_Text::party_open()");
    } // void UI_Text::party_open()

  /**
   **
   ** gets and sets the settings of the party:
   **   names, types and configuration of the players,
   **   rules,
   **   starting seed
   **   startplayer
   **
   ** @param	-
   **
   ** @return	-
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   ** @todo	all
   **
   **/
  void
    UI_Text::party_get_settings()
    {
      DEBUG_CALLING(INFO_UI_TEXT,
		    "UI_Text::party_get_settings()");

      this->ostr() << ::language("Set settings for the party.\n");
      while (::game_status == GAMESTATUS::PARTY_INIT) {
	this->getline();
	if (::game_status == GAMESTATUS::QUIT)
	  break;

	// test new party
	// test rules (writable)
	// input seed
	// input startplayer
	
	// test general, help, settings
	if (this->general->interpret_line()) {
	} else if (this->help->interpret_line()) {
	} else if (this->bug_report->interpret_line()) {
	} else if (this->settings->interpret_line()) {
	} else if (this->iskeyword("start game")
	    || this->iskeyword("start")) {
	  break;
	} else { // if !(line interpreted)
	  this->ostr() << ::language("Unknown command '%scommand%'.\n",
				      this->line.c_str());
	} // if !(line interpreted)

      } // while (::game_status != GAMESTATUS::PARTY_INIT)

      DEBUG_RETURNING(VOID,
		      INFO_UI_TEXT,
		      "UI_Text::party_get_settings()");
    } // void UI_Text::party_get_Settings()

  /**
   **
   ** the party is started:
   ** the gametype and announcements of the other players are shown
   **
   ** @param	-
   **
   ** @return	-
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   ** @todo	all
   **
   **/
  void
    UI_Text::party_start()
    { 
      DEBUG_CALLING(INFO_UI_TEXT,
		    "UI_Text::party_start()");

#ifndef POSTPHONED
      this->ostr() << "The party is started." << endl;
#endif

      DEBUG_RETURNING(VOID,
		      INFO_UI_TEXT,
		      "UI_Text::party_start()");
    } // void UI_Text::party_start()

  /**
   **
   ** the party is finished
   **
   ** @param	-
   **
   ** @return	-
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   ** @todo	all
   **
   **/
  void
    UI_Text::party_finish()
    {
      DEBUG_CALLING(INFO_UI_TEXT,
		    "UI_Text::party_finish()");

#ifndef POSTPHONED
      this->ostr() << "The party is finished." << endl;
#endif

      DEBUG_RETURNING(VOID,
		      INFO_UI_TEXT,
		      "UI_Text::party_finish()");
    } // void UI_Text::party_end()

  /**
   **
   ** the party is closed
   **
   ** @param	-
   **
   ** @return	-
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   ** @todo	all
   **
   **/
  void
    UI_Text::party_close()
    {
      DEBUG_CALLING(INFO_UI_TEXT,
		    "UI_Text::party_close()");

#ifndef POSTPHONED
      this->ostr() << "The party is closed." << endl;
#endif

      DEBUG_RETURNING(VOID,
		      INFO_UI_TEXT,
		      "UI_Text::party_close()");
    } // void UI_Text::party_close()

} // namespace UI_TEXT_NS

#endif // #ifdef USE_UI_TEXT
