/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2007  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 **********************************************************************/

#ifdef USE_UI_GTKMM

#ifndef GTKMM_RESERVATION_HEADER
#define GTKMM_RESERVATION_HEADER

#include "htin.h"
#include "translations.h"

#include "../../game/reservation.h"

#include "widgets/sticky_dialog.h"
namespace Gtk {
  class StockButton;
  class CheckButton;
  class RadioButton;
  class Notebook;
  class Label;
} // namespace Gtk
#include <gtkmm/notebook.h> // needed for 'GtkNotebookPage'

namespace UI_GTKMM_NS {
  class Table;

  /**
   **
   ** @brief	the reservation
   **
   ** @author	Diether Knof
   **
   ** @todo	ordering of the swines
   **
   **/
  class Reservation : public HTIN, public Gtk::StickyDialog {
    public:
      Reservation(Table* const table, Player const* const player);
      ~Reservation();

      ::Reservation get();
     
      void draw(bool const update = true);

      void set_default();
      void gametype_changed(int const gametype);
      void swines_changed();

      void sensitivity_update();

    private:
      void init();

      void check_poverty();

      void switch_page_event(GtkNotebookPage*, guint pageno);

    private:
      Gtk::StockButton* announce_button;

      Gtk::Notebook* notebook;
      Gtk::CheckButton* swines_button;
      Gtk::CheckButton* hyperswines_button;
      vector<Gtk::RadioButton*> gametype_buttons;
      vector<Gtk::RadioButton*> marriage_selector_buttons;

      bool in_update;

    private: // unused
      Reservation();
      Reservation(Reservation const& main_window);
      Reservation& operator=(Reservation const& main_window);
  }; // class Reservation : public Base, public Gtk::StickyDialog

} // namespace UI_GTKMM_NS

#endif // #ifdef GTKMM_RESERVATION_HEADER

#endif // #ifdef USE_UI_GTKMM
