/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2007  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 *********************************************************************/

#ifndef CLASS_EXCEPTION_HEADER
#define CLASS_EXCEPTION_HEADER

#include <string>
#include <exception>

class StdException : public std::exception {
  public:
    StdException() throw() :
      message_()
      { }
    StdException(std::string const& message) throw() :
      message_(message)
      { }

    StdException(StdException const& std_exception) throw() :
      message_(std_exception.message_)
      { }

    virtual ~StdException() throw() { }

    virtual const char* what() const throw()
    { return message_.c_str(); }

  private:
    string const message_;
  private: // unused
    StdException& operator=(StdException const&);
}; // class StdException : public std::exception

#ifdef POSTPHONED
// Ausgabe der History einer ungefangenen Exception auf fs::error
namespace exceptionTerminate{
static     ExceptionImpl* terminatingPimpl_ = NULL;
static     terminate_handler prevTerminate_ = NULL;
}
class ExceptionTerminate
{
    friend class Exception;
  protected:

    static void
    // neue terminate Funktion die history und what ausgibt   
    // fuer eine nicht gefange Exception   
    terminate()
    {
      fs::error << "Terminating with uncaught fs::Exception" << std::endl;

      if( exceptionTerminate::terminatingPimpl_ )
      {
 fs::error << "  " << exceptionTerminate::terminatingPimpl_->what()
    << std::endl;
 fs::error << "ExceptionStack:" << std::endl;
 fs::error << exceptionTerminate::terminatingPimpl_->getHistory( "  " )
    << std::endl;
      }

      abort();
    }

    // einbinden obiger terminate Funktion
    static void set( ExceptionImpl* impl )
    {
      exceptionTerminate::terminatingPimpl_ = impl;
      exceptionTerminate::prevTerminate_ = set_terminate( &terminate );
    }

    // ausklinken obiger terminate Funktion
    static void unset()
    {
      exceptionTerminate::terminatingPimpl_ = NULL;
      set_terminate( exceptionTerminate::prevTerminate_ );
    }

};

#endif // #ifdef POSTPHONED

#endif // #ifndef CLASS_EXCEPTION_HEADER
