/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.remote.services;

import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;

import java.util.List;

/**
 * @author Volodya Sabadosh (vsabadosh@jaspersoft.com)
 * @version $Id: PermissionsService.java 23213 2012-04-17 14:04:33Z vsabadosh $
 */
public interface PermissionsService {

    public List<ObjectPermission> getPermissionsForObject(String targetURI) throws RemoteException;

    public List<ObjectPermission> getPermissions(String resourceURI) throws RemoteException;

    public ObjectPermission putPermission(ObjectPermission objectPermission) throws RemoteException;

    public void deletePermission(ObjectPermission objectPermission) throws RemoteException;

    public ObjectPermission newObjectPermission();

    public int getAppliedPermissionMaskForObjectAndCurrentUser(String targetURI) throws RemoteException;
}
