/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.api.metadata.user.domain.client;

import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author swood
 *
 */
@XmlRootElement(name = "role")
public class RoleImpl implements Role, Serializable {
	private String roleName;
	private Set userSet = new HashSet();
	private boolean externallyDefined = false;
	private List attributes = null;
	private String tenantId;

    public RoleImpl(){}

	public String getRoleName() {
		return roleName;
	}

	public void setRoleName(String newRoleName) {
//		if (newRoleName == null || newRoleName.trim().length() == 0) {
//			throw new RuntimeException("No role name");
//		}
		roleName = newRoleName;
	}

	/* (non-Javadoc)
	 * @see com.jaspersoft.jasperserver.api.metadata.user.domain.Role#getUsers()
	 */
	public Set getUsers() {
		return userSet;
	}

	/* (non-Javadoc)
	 * @see com.jaspersoft.jasperserver.api.metadata.user.domain.Role#setUsers(java.util.Set)
	 */
	public void setUsers(Set userSet) {
		this.userSet = userSet;
	}

	/* (non-Javadoc)
	 * @see com.jaspersoft.jasperserver.api.metadata.user.domain.Role#isExternallyDefined()
	 */
	public boolean isExternallyDefined() {
		return externallyDefined;
	}

	/**
	 * @param externallyDefined The externallyDefined to set.
	 */
	public void setExternallyDefined(boolean externallyDefined) {
		this.externallyDefined = externallyDefined;
	}

	/* (non-Javadoc)
	 * @see com.jaspersoft.jasperserver.api.common.domain.AttributedObject#getAttributes()
	 */
	public List getAttributes() {
	    return attributes;
	}

        public void setAttributes(List attrs) {
	    attributes = attrs;
        }


	public String toString() {
		ToStringBuilder builder = new ToStringBuilder(this);
		builder.append("roleName", getRoleName());
		if (getTenantId() != null) {
			// only include tenant if not null
			builder.append("tenantId", getTenantId());
		}
		return builder.toString();
	}

	public boolean equals(Object other) {
		if ( !(other instanceof RoleImpl) ) return false;
		RoleImpl castOther = (RoleImpl) other;
		return new EqualsBuilder()
			.append(this.getRoleName(), castOther.getRoleName())
			.append(this.getTenantId(), castOther.getTenantId())
			.isEquals();
	}

	public int hashCode() {
		return new HashCodeBuilder()
			.append(getRoleName())
			.append(getTenantId())
			.toHashCode();
	}

	public void addUser(User aUser)
	{
		userSet.add(aUser);
	}

	public void removeUser(User aUser)
	{
		userSet.remove(aUser);
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}
}
