/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.war.control;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.MessageUtil;
import net.sf.jasperreports.web.util.WebUtil;
import net.sf.jasperreports.web.util.VelocityUtil;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.view.AbstractView;

/**
 * Controller for JasperServer report resources.
 * 
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 * @version $Id: ReportImageController.java 20676 2011-07-25 12:59:03Z tdanciu $
 */
public class ReportResourceController  implements Controller
{
	private JasperReportsContext jasperReportsContext;

	protected static class ResourceView extends AbstractView {

		private final String mimeType;
		private final byte[] data;

		public ResourceView(final String mimeType, final byte[] data) {
			this.mimeType = mimeType;
			this.data = data;
		}

		protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
			if (data != null && data.length > 0) {
				if (mimeType != null) {
					response.setHeader("Content-Type", mimeType);
				}
				response.setContentLength(data.length);
				ServletOutputStream ouputStream = response.getOutputStream();
				ouputStream.write(data, 0, data.length);
				ouputStream.flush();
				ouputStream.close();
			} else {
				response.getOutputStream().close();
			}
		}
		
	}
	
	public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws JRException
	{
		byte[] data = null;
		String mimeType = null;

		WebUtil webUtil = WebUtil.getInstance(getJasperReportsContext());
		String resourceName = webUtil.getResourceUri(request);
		boolean isDynamicResource = webUtil.isDynamicResource(request);
		String resourceBundleName = webUtil.getResourceBundleForResource(request);
		Locale locale = webUtil.getResourceLocale(request);

		//FIXMEJIVE make this configurable
		if(
			resourceName != null 
			&& resourceName.contains("net/sf/jasperreports") 
			&& resourceName.indexOf(".vm.") != -1 
			&& (isDynamicResource || resourceBundleName != null || locale != null)
			) 
		{
			Map<String, Object> contextMap = new HashMap<String, Object>();
			contextMap.put("path", request.getContextPath() + webUtil.getResourcesBasePath());
			//contextMap.put("path", request.getContextPath() + request.getParameter(getPathParameter()));
			locale = locale == null ? Locale.getDefault() : locale;
			contextMap.put("msgProvider", MessageUtil.getInstance(getJasperReportsContext()).getLocalizedMessageProvider(resourceBundleName, locale)); 

			String resourceString = VelocityUtil.processTemplate(resourceName, contextMap);
			if (resourceString != null) {
				try {
					data = resourceString.getBytes("UTF-8");
				} catch (UnsupportedEncodingException e) {
					throw new RuntimeException(e);
				}
			}
		} else if (resourceName != null && resourceName.contains("net/sf/jasperreports"))
		{
			data = JRLoader.loadBytesFromResource(resourceName);
		}
		
		//FIXMEJIVE make this configurable
		if (resourceName.endsWith(".js")) {
			response.setContentType("text/javascript; charset=UTF-8");
		} else if (resourceName.endsWith(".css")) {
			response.setContentType("text/css");
		}
		
//			// Set to expire far in the past.
//			response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
//			// Set standard HTTP/1.1 no-cache headers.
//			response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
//			// Set IE extended HTTP/1.1 no-cache headers (use addHeader).
//			response.addHeader("Cache-Control", "post-check=0, pre-check=0");
//			// Set standard HTTP/1.0 no-cache header.
//			response.setHeader("Pragma", "no-cache");

		View view = new ResourceView(mimeType, data);
		return new ModelAndView(view);
	}

	public JasperReportsContext getJasperReportsContext() {
		return jasperReportsContext;
	}

	public void setJasperReportsContext(JasperReportsContext jasperReportsContext) {
		this.jasperReportsContext = jasperReportsContext;
	}
}
