/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.fluent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.Container;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.impl.SignatureParser;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Logger;

public abstract class FluentConfigurator
implements Configurator {
    private String typeName = null;
    private String scriptName = null;
    private String filterClassName = null;
    private String converter = null;
    private String match = null;
    private Map params = null;
    private List filters = null;
    private StringBuffer signature = null;
    private int state = -1;
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private AjaxFilterManager ajaxFilterManager = null;
    private ConverterManager converterManager = null;
    private AccessControl accessControl = null;
    private CreatorManager creatorManager = null;
    private static final int STATE_INIT_CREATE = 0;
    private static final int STATE_INIT_CONVERT = 1;
    private static final int STATE_ALLOW_CREATE = 2;
    private static final int STATE_ALLOW_FILTER = 3;
    private static final int STATE_ALLOW_CONVERT = 4;
    private static final int STATE_SIGNATURE = 5;
    private static final int STATE_COMPLETE = 6;
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$fluent$FluentConfigurator == null ? (class$org$directwebremoting$fluent$FluentConfigurator = FluentConfigurator.class$("org.directwebremoting.fluent.FluentConfigurator")) : class$org$directwebremoting$fluent$FluentConfigurator);
    static /* synthetic */ Class class$org$directwebremoting$AjaxFilter;
    static /* synthetic */ Class class$org$directwebremoting$extend$ConverterManager;
    static /* synthetic */ Class class$org$directwebremoting$extend$AjaxFilterManager;
    static /* synthetic */ Class class$org$directwebremoting$extend$AccessControl;
    static /* synthetic */ Class class$org$directwebremoting$extend$CreatorManager;
    static /* synthetic */ Class class$org$directwebremoting$fluent$FluentConfigurator;

    public abstract void configure();

    public FluentConfigurator withConverterType(String id, String converterClassName) {
        this.setState(1);
        this.converterManager.addConverterType(id, converterClassName);
        return this;
    }

    public FluentConfigurator withConverter(String newConverter, String newMatch) {
        this.setState(4);
        this.converter = newConverter;
        this.match = newMatch;
        return this;
    }

    public FluentConfigurator withCreatorType(String id, String creatorClassName) {
        this.setState(0);
        this.creatorManager.addCreatorType(id, creatorClassName);
        return this;
    }

    public FluentConfigurator withCreator(String newTypeName, String newScriptName) {
        this.setState(2);
        this.typeName = newTypeName;
        this.scriptName = newScriptName;
        return this;
    }

    public FluentConfigurator withFilter(String newFilterClassName) {
        this.setState(3);
        this.filterClassName = newFilterClassName;
        return this;
    }

    public FluentConfigurator addParam(String name, String value) {
        if (this.params == null) {
            this.params = new HashMap();
        }
        this.params.put(name, value);
        return this;
    }

    public FluentConfigurator addFilter(String newFilterClassName) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        this.filters.add(newFilterClassName);
        return this;
    }

    public FluentConfigurator include(String methodName) {
        this.accessControl.addIncludeRule(this.scriptName, methodName);
        return this;
    }

    public FluentConfigurator exclude(String methodName) {
        this.accessControl.addExcludeRule(this.scriptName, methodName);
        return this;
    }

    public FluentConfigurator withAuth(String methodName, String role) {
        this.accessControl.addRoleRestriction(this.scriptName, methodName, role);
        return this;
    }

    public FluentConfigurator withSignature() {
        this.setState(5);
        return this;
    }

    public FluentConfigurator addLine(String line) {
        if (null == line) {
            return this;
        }
        if (null == this.signature) {
            this.signature = new StringBuffer();
        }
        this.signature.append(line);
        this.signature.append(System.getProperty("line.separator"));
        return this;
    }

    private void setState(int state) {
        this.flush();
        this.state = state;
    }

    private void flush() {
        switch (this.state) {
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            case 4: {
                try {
                    if (this.params == null) {
                        this.converterManager.addConverter(this.match, this.converter, EMPTY_MAP);
                    } else {
                        this.converterManager.addConverter(this.match, this.converter, this.params);
                    }
                }
                catch (Exception e) {
                    log.warn("Failed to add converter of type='" + this.converter + "', match=" + this.match + ": ", e);
                }
                this.params = null;
                this.match = null;
                this.converter = null;
                break;
            }
            case 2: {
                try {
                    if (this.params == null) {
                        this.creatorManager.addCreator(this.scriptName, this.typeName, EMPTY_MAP);
                    } else {
                        this.creatorManager.addCreator(this.scriptName, this.typeName, this.params);
                    }
                    if (this.filters != null) {
                        Iterator it = this.filters.iterator();
                        while (it.hasNext()) {
                            String className = (String)it.next();
                            AjaxFilter filter = (AjaxFilter)LocalUtil.classNewInstance(this.scriptName, className, class$org$directwebremoting$AjaxFilter == null ? FluentConfigurator.class$("org.directwebremoting.AjaxFilter") : class$org$directwebremoting$AjaxFilter);
                            if (filter == null) continue;
                            LocalUtil.setParams(filter, Collections.EMPTY_MAP, Collections.EMPTY_LIST);
                            this.ajaxFilterManager.addAjaxFilter(filter, this.scriptName);
                        }
                    }
                }
                catch (Exception e) {
                    log.warn("Failed to add creator of type='" + this.typeName + "', scriptName=" + this.scriptName + ": ", e);
                }
                this.params = null;
                this.scriptName = null;
                this.typeName = null;
                this.filters = null;
                break;
            }
            case 3: {
                try {
                    Class impl = LocalUtil.classForName(this.filterClassName);
                    AjaxFilter object = (AjaxFilter)impl.newInstance();
                    if (this.params != null) {
                        LocalUtil.setParams(object, this.params, Collections.EMPTY_LIST);
                    }
                    this.ajaxFilterManager.addAjaxFilter(object);
                }
                catch (ClassCastException ex) {
                    log.error(this.filterClassName + " does not implement " + (class$org$directwebremoting$AjaxFilter == null ? (class$org$directwebremoting$AjaxFilter = FluentConfigurator.class$("org.directwebremoting.AjaxFilter")) : class$org$directwebremoting$AjaxFilter).getName(), ex);
                }
                catch (NoClassDefFoundError ex) {
                    log.info("Missing class for filter (class='" + this.filterClassName + "'). Cause: " + ex.getMessage());
                }
                catch (Exception ex) {
                    log.error("Failed to add filter: class=" + this.filterClassName, ex);
                }
                this.params = null;
                this.filterClassName = null;
                break;
            }
            case 5: {
                if (this.signature == null || this.signature.length() <= 0) break;
                SignatureParser sigp = new SignatureParser(this.converterManager, this.creatorManager);
                sigp.parse(this.signature.toString());
                break;
            }
        }
    }

    public void configure(Container container) {
        this.converterManager = (ConverterManager)container.getBean((class$org$directwebremoting$extend$ConverterManager == null ? (class$org$directwebremoting$extend$ConverterManager = FluentConfigurator.class$("org.directwebremoting.extend.ConverterManager")) : class$org$directwebremoting$extend$ConverterManager).getName());
        this.ajaxFilterManager = (AjaxFilterManager)container.getBean((class$org$directwebremoting$extend$AjaxFilterManager == null ? (class$org$directwebremoting$extend$AjaxFilterManager = FluentConfigurator.class$("org.directwebremoting.extend.AjaxFilterManager")) : class$org$directwebremoting$extend$AjaxFilterManager).getName());
        this.accessControl = (AccessControl)container.getBean((class$org$directwebremoting$extend$AccessControl == null ? (class$org$directwebremoting$extend$AccessControl = FluentConfigurator.class$("org.directwebremoting.extend.AccessControl")) : class$org$directwebremoting$extend$AccessControl).getName());
        this.creatorManager = (CreatorManager)container.getBean((class$org$directwebremoting$extend$CreatorManager == null ? (class$org$directwebremoting$extend$CreatorManager = FluentConfigurator.class$("org.directwebremoting.extend.CreatorManager")) : class$org$directwebremoting$extend$CreatorManager).getName());
        this.configure();
        this.setState(6);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

