/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.xls;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.xls.XlsDataAdapter;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRXlsDataSource;

public class XlsDataAdapterService
extends AbstractDataAdapterService {
    public XlsDataAdapterService(JasperReportsContext jasperReportsContext, XlsDataAdapter xlsDataAdapter) {
        super(jasperReportsContext, xlsDataAdapter);
    }

    public XlsDataAdapterService(XlsDataAdapter xlsDataAdapter) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), xlsDataAdapter);
    }

    public XlsDataAdapter getXlsDataAdapter() {
        return (XlsDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        XlsDataAdapter xlsDataAdapter = this.getXlsDataAdapter();
        if (xlsDataAdapter != null) {
            try {
                String datePattern = xlsDataAdapter.getDatePattern();
                String numberPattern = xlsDataAdapter.getNumberPattern();
                if (xlsDataAdapter.isQueryExecuterMode()) {
                    parameters.put("XLS_WORKBOOK", Workbook.getWorkbook((InputStream)new FileInputStream(new File(xlsDataAdapter.getFileName()))));
                    if (datePattern != null && datePattern.length() > 0) {
                        parameters.put("XLS_DATE_FORMAT", new SimpleDateFormat(datePattern));
                    }
                    if (numberPattern != null && numberPattern.length() > 0) {
                        parameters.put("XLS_NUMBER_FORMAT", new DecimalFormat(numberPattern));
                    }
                    parameters.put("XLS_USE_FIRST_ROW_AS_HEADER", new Boolean(xlsDataAdapter.isUseFirstRowAsHeader()));
                    if (!xlsDataAdapter.isUseFirstRowAsHeader()) {
                        String[] names = new String[xlsDataAdapter.getColumnNames().size()];
                        int[] indexes = new int[xlsDataAdapter.getColumnNames().size()];
                        this.setupColumns(xlsDataAdapter, names, indexes);
                        parameters.put("XLS_COLUMN_NAMES_ARRAY", names);
                        parameters.put("XLS_COLUMN_INDEXES_ARRAY", indexes);
                    }
                } else {
                    JRXlsDataSource ds = new JRXlsDataSource(new File(xlsDataAdapter.getFileName()));
                    if (datePattern != null && datePattern.length() > 0) {
                        ds.setDateFormat(new SimpleDateFormat(datePattern));
                    }
                    if (numberPattern != null && numberPattern.length() > 0) {
                        ds.setNumberFormat(new DecimalFormat(numberPattern));
                    }
                    ds.setUseFirstRowAsHeader(xlsDataAdapter.isUseFirstRowAsHeader());
                    if (!xlsDataAdapter.isUseFirstRowAsHeader()) {
                        String[] names = new String[xlsDataAdapter.getColumnNames().size()];
                        int[] indexes = new int[xlsDataAdapter.getColumnNames().size()];
                        this.setupColumns(xlsDataAdapter, names, indexes);
                        ds.setColumnNames(names, indexes);
                    }
                    parameters.put("REPORT_DATA_SOURCE", ds);
                }
            }
            catch (FileNotFoundException e) {
                throw new JRException(e);
            }
            catch (IOException e) {
                throw new JRException(e);
            }
            catch (BiffException e) {
                throw new JRException(e);
            }
        }
    }

    private void setupColumns(XlsDataAdapter xlsDataAdapter, String[] names, int[] indexes) {
        for (int i = 0; i < names.length; ++i) {
            names[i] = "" + xlsDataAdapter.getColumnNames().get(i);
            indexes[i] = xlsDataAdapter.getColumnIndexes().size() > i ? xlsDataAdapter.getColumnIndexes().get(i) : i;
        }
    }
}

