/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.actions;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.sf.jasperreports.components.headertoolbar.actions.BaseColumnData;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRIdentifiable;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.DefaultFormatFactory;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.repo.JasperDesignReportResource;
import net.sf.jasperreports.web.actions.AbstractAction;
import net.sf.jasperreports.web.actions.ActionException;
import net.sf.jasperreports.web.commands.CommandTarget;

public abstract class AbstractVerifiableTableAction
extends AbstractAction {
    protected BaseColumnData columnData;
    protected StandardTable table;
    protected String targetUri;
    protected static FormatFactory formatFactory = new DefaultFormatFactory();

    @Override
    public String getMessagesBundle() {
        return "net.sf.jasperreports.components.headertoolbar.actions.messages";
    }

    public StandardTable getTable(String uuid) {
        CommandTarget target = this.getCommandTarget(UUID.fromString(uuid));
        if (target != null) {
            JRIdentifiable identifiable = target.getIdentifiable();
            JRDesignComponentElement componentElement = identifiable instanceof JRDesignComponentElement ? (JRDesignComponentElement)identifiable : null;
            return componentElement == null ? null : (StandardTable)componentElement.getComponent();
        }
        return null;
    }

    @Override
    public CommandTarget getCommandTarget(UUID uuid) {
        JasperDesignCache cache = JasperDesignCache.getInstance(this.getJasperReportsContext(), this.getReportContext());
        Map<String, JasperDesignReportResource> cachedResources = cache.getCachedResources();
        Set<String> uris = cachedResources.keySet();
        for (String uri : uris) {
            CommandTarget target = new CommandTarget();
            target.setUri(uri);
            JasperDesign jasperDesign = cache.getJasperDesign(uri);
            for (JRBand band : jasperDesign.getAllBands()) {
                if (band == null) continue;
                for (JRElement element : band.getElements()) {
                    if (!(element instanceof JRDesignComponentElement) || !uuid.equals(element.getUUID())) continue;
                    target.setIdentifiable(element);
                    return target;
                }
            }
        }
        return null;
    }

    public void prepare() throws ActionException {
        CommandTarget target;
        if (this.columnData == null) {
            this.errors.addAndThrow("net.sf.jasperreports.components.headertoolbar.actions.validate.no.data");
        }
        if (this.columnData.getTableUuid() == null || this.columnData.getTableUuid().trim().length() == 0) {
            this.errors.addAndThrow("net.sf.jasperreports.components.headertoolbar.actions.validate.no.table");
        }
        if ((target = this.getCommandTarget(UUID.fromString(this.columnData.getTableUuid()))) != null) {
            JRDesignComponentElement componentElement;
            JRIdentifiable identifiable = target.getIdentifiable();
            JRDesignComponentElement jRDesignComponentElement = componentElement = identifiable instanceof JRDesignComponentElement ? (JRDesignComponentElement)identifiable : null;
            if (componentElement == null) {
                this.errors.addAndThrow("net.sf.jasperreports.components.headertoolbar.actions.validate.no.table.match", new Object[]{this.columnData.getTableUuid()});
            }
            this.table = (StandardTable)componentElement.getComponent();
            this.targetUri = target.getUri();
        }
    }

    @Override
    public void run() throws ActionException {
        this.prepare();
        this.verify();
        this.errors.throwAll();
        this.performAction();
    }

    public abstract void verify() throws ActionException;
}

