/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.repository;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.UniversalValidationErrorFilter;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;
import com.jaspersoft.jasperserver.ws.axis2.ResourceActionResolver;
import com.jaspersoft.jasperserver.ws.axis2.ResourceHandler;
import com.jaspersoft.jasperserver.ws.axis2.ResourceResolverAdapter;
import com.jaspersoft.jasperserver.ws.axis2.ResultAttachments;
import com.jaspersoft.jasperserver.ws.axis2.ServiceRequest;
import com.jaspersoft.jasperserver.ws.axis2.WSException;
import com.jaspersoft.jasperserver.ws.axis2.WSValidationException;
import com.jaspersoft.jasperserver.ws.axis2.util.ResourceUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FolderHandler
implements ResourceHandler,
ResourceResolverAdapter {
    private static final Log log = LogFactory.getLog(FolderHandler.class);
    protected static final String OBJECT_NAME = "actualFolder";
    private ResourceActionResolver resourceActionResolver;

    @Override
    public void setResourceActionHandler(ResourceActionResolver resourceActionResolver) {
        this.resourceActionResolver = resourceActionResolver;
    }

    @Override
    public Class getResourceType() {
        return Folder.class;
    }

    @Override
    public ResourceDescriptor describe(Resource resource, Map arguments, RepositoryServiceContext serviceContext) {
        Folder folder = (Folder)resource;
        ResourceDescriptor descriptor = new ResourceDescriptor();
        descriptor.setWsType("folder");
        descriptor.setHasData(false);
        descriptor.setUriString(folder.getURIString());
        descriptor.setDescription(folder.getDescription());
        descriptor.setLabel(folder.getLabel());
        descriptor.setName(folder.getName());
        descriptor.setResourceType(folder.getResourceType());
        descriptor.setParentFolder(folder.getParentFolder());
        descriptor.setVersion(folder.getVersion());
        descriptor.setCreationDate(folder.getCreationDate());
        return descriptor;
    }

    @Override
    public void put(ServiceRequest request) throws WSException {
        ResourceDescriptor descriptor = request.getRequestDescriptor();
        RepositoryService repository = request.getContext().getRepository();
        RepositoryServiceContext context = request.getContext();
        if (descriptor.getIsNew()) {
            FolderImpl folder = new FolderImpl();
            folder.setName(descriptor.getName());
            folder.setLabel(descriptor.getLabel());
            folder.setDescription(descriptor.getDescription());
            folder.setParentFolder(descriptor.getParentFolder());
            folder.setVersion(-1);
            this.saveValidated(repository, (Folder)folder, context);
            request.getResult().getResourceDescriptors().add(request.getContext().createResourceDescriptor(folder.getURIString()));
        } else {
            Folder res = repository.getFolder(null, descriptor.getUriString());
            if (res != null) {
                if (res.getLabel() == null || !res.getLabel().equals(descriptor.getLabel())) {
                    res.setLabel(descriptor.getLabel());
                }
                if (res.getDescription() == null || !res.getDescription().equals(descriptor.getDescription())) {
                    res.setDescription(descriptor.getDescription());
                }
                this.saveValidated(repository, res, context);
                request.getResult().addResourceDescriptor(request.getContext().createResourceDescriptor((Resource)res));
            } else {
                request.getResult().setReturnCode(2);
                request.getResult().setMessage(request.getContext().getMessage("webservices.error.folderNotFound", null));
            }
        }
    }

    protected void saveValidated(RepositoryService repository, Folder folder, RepositoryServiceContext serviceContext) throws WSException {
        Object filter = folder.isNew() ? UniversalValidationErrorFilter.getInstance() : null;
        ValidationErrors errors = repository.validateFolder(null, folder, (ValidationErrorFilter)filter);
        if (errors.isError()) {
            throw new WSValidationException(OBJECT_NAME, errors);
        }
        if (!this.resourceActionResolver.canCreateResource(folder.getParentFolder())) {
            throw new WSException(1, serviceContext.getMessage("webservices.error.cannotCreateResource", new String[]{folder.getParentFolder()}));
        }
        repository.saveFolder(null, folder);
    }

    @Override
    public void getAttachments(Resource resource, Map arguments, ResourceDescriptor descriptor, ResultAttachments attachments, RepositoryServiceContext serviceContext) {
    }

    @Override
    public void delete(ResourceDescriptor descriptor, RepositoryServiceContext serviceContext) throws WSException {
        if (!this.resourceActionResolver.isResourceDeletable(descriptor.getUriString())) {
            throw new WSException(1, serviceContext.getMessage("webservices.error.notDeletableResource", null));
        }
        serviceContext.getRepository().deleteFolder(null, descriptor.getUriString());
    }

    @Override
    public void move(Request request, RepositoryServiceContext serviceContext) throws WSException {
        String sourceURI = request.getResourceDescriptor().getUriString();
        String destinationURI = this.getDestinationURI(request, serviceContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Moving folder " + sourceURI + " to folder " + destinationURI));
        }
        if (!this.resourceActionResolver.canCreateResource(destinationURI)) {
            throw new WSException(1, serviceContext.getMessage("webservices.error.cannotCreateResource", new String[]{destinationURI}));
        }
        serviceContext.getRepository().moveFolder(null, sourceURI, destinationURI);
    }

    @Override
    public ResourceDescriptor copy(Request request, RepositoryServiceContext serviceContext) throws WSException {
        String sourceURI = request.getResourceDescriptor().getUriString();
        String destinationURI = this.getDestinationURI(request, serviceContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Copying folder " + sourceURI + " to URI " + destinationURI));
        }
        if (!this.resourceActionResolver.canCreateResource(ResourceUtils.getParentFolder(destinationURI))) {
            throw new WSException(1, serviceContext.getMessage("webservices.error.cannotCreateResource", new String[]{ResourceUtils.getParentFolder(destinationURI)}));
        }
        Folder copy = serviceContext.getRepository().copyFolder(null, sourceURI, destinationURI);
        return this.describe((Resource)copy, null, serviceContext);
    }

    protected String getDestinationURI(Request request, RepositoryServiceContext serviceContext) throws WSException {
        String destinationURI = request.getArgumentValue("DESTINATION_URI");
        if (destinationURI == null) {
            throw new WSException(6, serviceContext.getMessage("webservices.error.request.no.destination.URI", null));
        }
        return destinationURI;
    }

    @Override
    public List listResources(Request request, RepositoryServiceContext serviceContext) throws WSException {
        throw new JSException("Listing folders with the LIST_RESOURCES argument is not supporteed");
    }
}

