/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.domain.Request;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequest;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataCacheProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataSnapshotService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.ReportLoadingService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.HtmlExportUtil;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.axis2.ManagementServiceConfiguration;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryHelper;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;
import com.jaspersoft.jasperserver.ws.axis2.ResourceHandler;
import com.jaspersoft.jasperserver.ws.axis2.ResourceHandlerRegistry;
import com.jaspersoft.jasperserver.ws.axis2.ResultAttachments;
import com.jaspersoft.jasperserver.ws.axis2.ServiceRequest;
import com.jaspersoft.jasperserver.ws.axis2.WSException;
import com.jaspersoft.jasperserver.ws.axis2.WSExporter;
import com.jaspersoft.jasperserver.ws.axis2.WSValidationException;
import com.jaspersoft.jasperserver.ws.axis2.repository.SubResourceHandler;
import com.jaspersoft.jasperserver.ws.xml.ByteArrayDataSource;
import com.jaspersoft.jasperserver.ws.xml.Marshaller;
import com.jaspersoft.jasperserver.ws.xml.Unmarshaller;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.AttachmentPart;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.SimpleReportContext;
import net.sf.jasperreports.engine.export.GenericElementReportTransformer;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.Attachments;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.validation.MessageCodesResolver;

public class ManagementServiceImpl
implements RepositoryServiceContext,
BeanFactoryAware {
    protected static final Log log = LogFactory.getLog(ManagementServiceImpl.class);
    protected static final String START_TOKEN = "img src=\"images/";
    protected static final String END_TOKEN = "\"";
    protected static final String REPORT_UNIT = "ReportUnit";
    protected static final String WS_VERSION = "2.0.1";
    protected static final String BEAN_NAME_REPOSITORY_SERVICE = "repositoryService";
    protected static final String BEAN_NAME_ENGINE_SERVICE = "engineService";
    protected static final String BEAN_NAME_RUN_REPORT_ENGINE_SERVICE = "runReportEngineService";
    protected static final String BEAN_NAME_HANDLER_REGISTRY = "resourceHandlerRegistry";
    protected static final String BEAN_NAME_MESSAGE_CODES_RESOLVER = "wsMessageCodesResolver";
    protected static final String BEAN_NAME_SERVICE_CONFIGURATION = "managementServiceConfiguration";
    protected static final String BEAN_NAME_AUDIT_CONTEXT = "auditContext";
    public static final String SPRING_PROPERTIES_BEAN_NAME = "springConfiguration";
    protected static final String BEAN_NAME_REPOSITORY_SERVICE_PROPERTY_NAME = "bean.repositoryService";
    protected static final String BEAN_NAME_AUDIT_CONTEXT_PROPERTY_NAME = "bean.auditContext";
    private static final String ADHOC_TOPICS = "/adhoc/topics";
    private Locale locale = null;
    private RepositoryService repository;
    private EngineService engine;
    private EngineService runReportEngine;
    private RepositoryHelper repositoryHelper;
    private ResourceHandlerRegistry handlerRegistry;
    private ManagementServiceConfiguration serviceConfiguration;
    private AuditContext auditContext;
    private JasperReportsContext jasperReportsContext;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    @Qualifier(value="reportLoadingService")
    private ReportLoadingService reportLoadingService;
    @Autowired
    @Qualifier(value="dataSnapshotService")
    private DataSnapshotService dataSnapshotService;
    @Autowired
    @Qualifier(value="engineServiceDataCacheProvider")
    private DataCacheProvider dataCacheProvider;
    private BeanFactory beanFactory;

    protected void createAuditEvent(final String auditEventType) {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                ManagementServiceImpl.this.auditContext.createAuditEvent(auditEventType);
            }
        });
    }

    protected void addPropertyToAuditEvent(String auditEventType, final String propertyName, final Object property) {
        this.auditContext.doInAuditContext(auditEventType, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                ManagementServiceImpl.this.auditContext.addPropertyToAuditEvent(propertyName, property, auditEvent);
            }
        });
    }

    protected void addExceptionToAllAuditEvents(final Throwable exception) {
        this.auditContext.doInAuditContext(new String[]{"saveResource", "updateResource", "deleteResource", "copyResource", "moveResource", "createFolder", "updateFolder", "deleteFolder", "copyFolder", "moveFolder", "runReport"}, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                ManagementServiceImpl.this.auditContext.addPropertyToAuditEvent("exception", (Object)exception, auditEvent);
            }
        });
    }

    private static String marshalResponse(OperationResult or) {
        return ManagementServiceImpl.marshalResponse(or, new HashMap(), false);
    }

    protected static String marshalResponse(OperationResult or, ResultAttachments attachments) {
        return ManagementServiceImpl.marshalResponse(or, attachments.getAttachmentsData(), attachments.isEncapsulationDime());
    }

    private static String marshalResponse(OperationResult or, Map datasources, boolean isEncapsulationDime) {
        String result = "";
        if (datasources != null) {
            MessageContext msgContext = MessageContext.getCurrentContext();
            Message responseMessage = msgContext.getResponseMessage();
            log.debug((Object)("Encapsulation DIME? : " + isEncapsulationDime));
            if (isEncapsulationDime) {
                responseMessage.getAttachmentsImpl().setSendType(3);
            }
            Iterator it = datasources.entrySet().iterator();
            while (it.hasNext()) {
                try {
                    Map.Entry entry = it.next();
                    String name = (String)entry.getKey();
                    DataSource datasource = (DataSource)entry.getValue();
                    log.debug((Object)("Adding attachment: " + name + ", type: " + datasource.getContentType()));
                    DataHandler expectedDH = new DataHandler(datasource);
                    AttachmentPart attachPart = null;
                    attachPart = responseMessage.createAttachmentPart(expectedDH);
                    attachPart.setContentId(name);
                    responseMessage.addAttachmentPart(attachPart);
                }
                catch (Exception ex) {
                    log.error((Object)("caught exception marshalling an OperationResult: " + ex.getMessage()), (Throwable)ex);
                    or.setReturnCode(1);
                    or.setMessage("Error attaching a resource to the SOAP message: " + ex.getMessage());
                }
            }
        }
        try {
            StringWriter xmlStringWriter = new StringWriter();
            Marshaller.marshal((Object)or, (StringWriter)xmlStringWriter);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Has descriptors: " + (or.getResourceDescriptors() == null || or.getResourceDescriptors().size() == 0 ? 0 : or.getResourceDescriptors().size())));
                log.debug((Object)"marshalled response");
                log.debug((Object)xmlStringWriter.toString());
            }
            result = xmlStringWriter.toString();
        }
        catch (Exception ex) {
            log.error((Object)("caught exception marshalling an OperationResult: " + ex.getMessage()), (Throwable)ex);
        }
        return result;
    }

    @Override
    public String list(String requestXmlString) {
        OperationResult or = new OperationResult();
        or.setVersion(WS_VERSION);
        or.setReturnCode(0);
        try {
            StringReader xmlStringReader = new StringReader(requestXmlString);
            com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request request = (com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request)Unmarshaller.unmarshal(com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request.class, (StringReader)xmlStringReader);
            this.setLocale(request.getLocale());
            List<ResourceDescriptor> list = null;
            if (request.getResourceDescriptor() == null) {
                list = new ArrayList();
                log.debug((Object)"Null resourceDescriptor");
                if (this.getArgumentValue("LIST_DATASOURCES", request.getArguments()) != null && this.getArgumentValue("LIST_DATASOURCES", request.getArguments()).equals("true")) {
                    FilterCriteria criteria = FilterCriteria.createFilter(ReportDataSource.class);
                    log.debug((Object)"Listing datasources...");
                    List lookups = this.repository.loadClientResources(criteria);
                    if (lookups != null && !lookups.isEmpty()) {
                        Iterator it = lookups.iterator();
                        while (it.hasNext()) {
                            list.add(this.createResourceDescriptor((Resource)it.next()));
                        }
                    }
                } else if (request.hasArgument("LIST_RESOURCES") && this.getArgumentValue("RESOURCE_TYPE", request.getArguments()).equals("REPORT_TYPE")) {
                    log.debug((Object)"Listing all reports...");
                    String parentFolder = this.getArgumentValue("START_FROM_DIRECTORY", request.getArguments());
                    if (parentFolder == null || !parentFolder.startsWith("/")) {
                        parentFolder = "/";
                    }
                    List allSubFolders = this.repository.getAllFolders(null);
                    for (int i = 0; i < allSubFolders.size(); ++i) {
                        String currentFolder = ((Folder)allSubFolders.get(i)).getURIString();
                        FilterCriteria filterCriteria = new FilterCriteria();
                        filterCriteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)currentFolder));
                        List units = this.repository.loadClientResources(filterCriteria);
                        for (int j = 0; j < units.size(); ++j) {
                            Resource currentRs = (Resource)units.get(j);
                            if (currentRs.getResourceType() == null || !currentRs.getResourceType().contains("ReportOptions") && !currentRs.getResourceType().contains(REPORT_UNIT) && !currentRs.getResourceType().contains("AdhocReportUnit")) continue;
                            String temp = this.serviceConfiguration.getTempFolder();
                            if ("/".equals(parentFolder)) {
                                if (ADHOC_TOPICS.equals(currentRs.getParentFolder()) || temp.equals(currentRs.getParentFolder())) continue;
                                list.add(this.createResourceDescriptor(currentRs));
                                continue;
                            }
                            if (!(currentRs.getURIString() + "/").startsWith(parentFolder + "/") || ADHOC_TOPICS.equals(currentRs.getParentFolder()) || temp.equals(currentRs.getParentFolder())) continue;
                            list.add(this.createResourceDescriptor(currentRs));
                        }
                    }
                } else if (request.hasArgument("LIST_RESOURCES")) {
                    String resourceType = request.getArgumentValue("RESOURCE_TYPE");
                    if (resourceType == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"No RESOURCE_TYPE argument, nothing to list");
                        }
                    } else {
                        ResourceHandler handler = this.handlerRegistry.getHandler(resourceType);
                        if (handler == null) {
                            throw new JSException("No resource hander found for type " + resourceType);
                        }
                        List resources = handler.listResources(request, this);
                        if (resources != null) {
                            list.addAll(resources);
                        }
                    }
                }
            } else if (request.getResourceDescriptor().getWsType().equals("folder")) {
                log.debug((Object)"List folders");
                list = this.listResources(request.getResourceDescriptor().getUriString());
            } else if (request.getResourceDescriptor().getWsType().equals("reportUnit")) {
                log.debug((Object)"List report units");
                list = this.createResourceDescriptor(request.getResourceDescriptor().getUriString()).getChildren();
            } else {
                log.debug((Object)"Listed nothing");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + list.size() + " things"));
                for (ResourceDescriptor rd : list) {
                    log.debug((Object)(rd != null ? rd.getName() : "rd was null"));
                }
            }
            or.setResourceDescriptors(list);
            log.debug((Object)"Marshalling response");
        }
        catch (Exception e) {
            log.error((Object)("caught exception: " + e.getMessage()), (Throwable)e);
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
        }
        catch (Throwable e) {
            log.error((Object)("caught exception: " + e.getMessage()), e);
        }
        return ManagementServiceImpl.marshalResponse(or);
    }

    private Set<String> getCurrentUserRoles() {
        HashSet<String> roleNames = new HashSet<String>();
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        if (authenticationToken == null) {
            return roleNames;
        }
        if (authenticationToken.getPrincipal() instanceof UserDetails) {
            UserDetails contextUserDetails = (UserDetails)authenticationToken.getPrincipal();
            for (GrantedAuthority authority : contextUserDetails.getAuthorities()) {
                roleNames.add(authority.getAuthority());
            }
        }
        return roleNames;
    }

    private void filterFolderList(List folderList) {
        if (folderList == null || folderList.size() == 0) {
            return;
        }
        Set<String> roles = this.getCurrentUserRoles();
        Iterator i = folderList.iterator();
        while (i.hasNext()) {
            Folder folder = (Folder)i.next();
            if (!this.serviceConfiguration.getTempFolder().equals(folder.getURIString())) continue;
            boolean accessDenied = true;
            if (roles != null && roles.size() > 0) {
                for (String role : roles) {
                    if (!this.serviceConfiguration.getRoleToAccessTempFolder().equals(role)) continue;
                    accessDenied = false;
                    break;
                }
            }
            if (!accessDenied) continue;
            i.remove();
        }
    }

    @Override
    public List listResources(String uri) throws WSException {
        log.debug((Object)("list for uri: " + uri));
        ArrayList<ResourceDescriptor> returnedMaps = new ArrayList<ResourceDescriptor>();
        List folders = this.getRepository().getSubFolders(null, uri);
        this.filterFolderList(folders);
        if (folders == null) {
            return returnedMaps;
        }
        for (int i = 0; i < folders.size(); ++i) {
            Resource folderRes = (Resource)folders.get(i);
            returnedMaps.add(this.createResourceDescriptor(folderRes));
        }
        FilterCriteria filterCriteria = new FilterCriteria();
        filterCriteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)uri));
        List units = this.getRepository().loadClientResources(filterCriteria);
        if (units == null) {
            return returnedMaps;
        }
        Iterator it = units.iterator();
        while (units != null && it.hasNext()) {
            Resource fileRes = (Resource)it.next();
            try {
                returnedMaps.add(this.createResourceDescriptor(fileRes));
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
        }
        return returnedMaps;
    }

    @Override
    public String get(String requestXmlString) {
        OperationResult or = new OperationResult();
        or.setVersion(WS_VERSION);
        or.setReturnCode(0);
        try {
            String resourceURI;
            Resource resource;
            StringReader xmlStringReader = new StringReader(requestXmlString);
            com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request request = (com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request)Unmarshaller.unmarshal(com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request.class, (StringReader)xmlStringReader);
            this.createAuditEvent(request.getOperationName(), request.getResourceDescriptor().getWsType(), request.getResourceDescriptor().getIsNew());
            this.setLocale(request.getLocale());
            List args = request.getArguments();
            List params = Collections.EMPTY_LIST;
            if (request.getResourceDescriptor() != null && request.getResourceDescriptor().getParameters() != null) {
                params = request.getResourceDescriptor().getParameters();
            }
            HashMap<String, Object> specialOptions = new HashMap<String, Object>();
            if (args != null) {
                for (int i = 0; i < args.size(); ++i) {
                    Argument arg = null;
                    if (args.get(i) instanceof Argument) {
                        arg = (Argument)args.get(i);
                    }
                    if (arg == null) continue;
                    specialOptions.put(arg.getName(), arg.getValue());
                }
            }
            if (params.size() > 0 && specialOptions.containsKey("RU_REF_URI")) {
                ResourceDescriptor reportDescriptior = this.createResourceDescriptor((String)specialOptions.get("RU_REF_URI"));
                specialOptions.put("PARAMS_ARG", this.buildParameterMap(params, reportDescriptior));
            }
            if ((resource = this.locateResource(resourceURI = request.getResourceDescriptor().getUriString())) != null) {
                ResourceDescriptor rd = this.createResourceDescriptor(resource, this.processDescriptorOptions(specialOptions));
                log.debug((Object)("Get: " + resourceURI + ", wsType: " + rd.getWsType() + ", resourceType: " + rd.getResourceType()));
                or.getResourceDescriptors().add(rd);
                ResultAttachments attachments = new ResultAttachments();
                attachments.setEncapsulationDime(this.getArgumentValue("USE_DIME_ATTACHMENTS", request.getArguments()) != null);
                ResourceHandler handler = this.getHandlerRegistry().getHandler(rd.getWsType());
                handler.getAttachments(resource, specialOptions, rd, attachments, this);
                if (or.getReturnCode() != 0) {
                    this.addExceptionToAllAuditEvents(new Exception(or.getMessage()));
                }
                return ManagementServiceImpl.marshalResponse(or, attachments);
            }
            log.warn((Object)("Get: null resourceDescriptor for " + resourceURI));
            or.setReturnCode(2);
            or.setMessage(this.messageSource.getMessage("webservices.error.resourceNotFound", null, this.getLocale()));
        }
        catch (Exception e) {
            log.error((Object)("caught exception: " + e.getMessage()), (Throwable)e);
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
            this.addExceptionToAllAuditEvents(e);
        }
        log.debug((Object)"Marshalling response");
        return ManagementServiceImpl.marshalResponse(or);
    }

    @Override
    public ResourceDescriptor createResourceDescriptor(String uri) throws WSException {
        return this.createResourceDescriptor(uri, null);
    }

    protected ResourceDescriptor createResourceDescriptor(String uri, Map specialOptions) throws WSException {
        Resource res = this.locateResource(uri);
        if (res == null) {
            throw new WSException(2, this.messageSource.getMessage("webservices.error.resourceNotFoundOrInvalid", new Object[]{uri}, this.getLocale()));
        }
        specialOptions = this.processDescriptorOptions(specialOptions);
        return this.createResourceDescriptor(res, specialOptions);
    }

    protected Map processDescriptorOptions(Map specialOptions) {
        if (specialOptions == null) {
            specialOptions = new HashMap<String, Boolean>();
        }
        if (!specialOptions.containsKey("ReportUnitContents")) {
            specialOptions.put("ReportUnitContents", Boolean.TRUE);
        }
        return specialOptions;
    }

    protected Resource locateResource(String uri) throws WSException {
        Folder res = null;
        int sep = uri.lastIndexOf("/");
        if (sep < 0) {
            throw new WSException(6, this.messageSource.getMessage("jsexception.invalid.uri", new Object[]{uri}, this.getLocale()));
        }
        String name = uri.substring(sep + Folder.SEPARATOR_LENGTH);
        String folderName = uri.substring(0, sep);
        if (folderName.endsWith("_files")) {
            String parentUri = folderName.substring(0, folderName.length() - "_files".length());
            log.warn((Object)("Loading uri: " + parentUri));
            Resource parentRes = this.getRepository().getResource(null, parentUri);
            if (parentRes != null) {
                ResourceDescriptor ruRd = this.createResourceDescriptor(folderName);
                log.warn((Object)("Loaded RU " + res));
                if (ruRd == null) {
                    return null;
                }
                res = this.getRepository().getResource(null, uri);
                log.warn((Object)("Loaded resource " + uri + " " + res));
            }
        }
        if (res == null) {
            if (folderName.length() == 0) {
                folderName = "/";
            }
            FilterCriteria filterCriteria = new FilterCriteria();
            filterCriteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderName));
            filterCriteria.addFilterElement((FilterElement)FilterCriteria.createPropertyEqualsFilter((String)"name", (Object)name));
            List resources = this.getRepository().loadClientResources(filterCriteria);
            if (resources != null && !resources.isEmpty()) {
                res = (Resource)resources.get(0);
            }
        }
        if (res == null) {
            Folder folder = this.getRepository().getFolder(null, uri);
            if (folder != null) {
                res = folder;
            } else {
                return null;
            }
        }
        return res;
    }

    @Override
    public ResourceDescriptor createResourceDescriptor(Resource resource) throws WSException {
        return this.createResourceDescriptor(resource, null);
    }

    @Override
    public ResourceDescriptor createResourceDescriptor(Resource resource, Map specialOptions) throws WSException {
        if (resource instanceof ResourceLookup) {
            throw new JSException("jsexception.resourcelookup.not.a.resource", new Object[]{resource.getClass().getName()});
        }
        ResourceHandler resourceHandler = this.getHandlerRegistry().getHandler(resource);
        if (resourceHandler == null) {
            throw new JRRuntimeException("No resource handler found for class " + resource.getClass().getName());
        }
        return resourceHandler.describe(resource, specialOptions, this);
    }

    @Override
    public String put(String requestXmlString) {
        OperationResult or = new OperationResult();
        or.setVersion(WS_VERSION);
        or.setReturnCode(0);
        try {
            StringReader xmlStringReader = new StringReader(requestXmlString);
            com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request request = (com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request)Unmarshaller.unmarshal(com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request.class, (StringReader)xmlStringReader);
            this.createAuditEvent(request.getOperationName(), request.getResourceDescriptor().getWsType(), request.getResourceDescriptor().getIsNew());
            this.setLocale(request.getLocale());
            ResourceDescriptor newDescriptor = request.getResourceDescriptor();
            log.debug((Object)("Put: for " + newDescriptor.getUriString()));
            if (newDescriptor.getUriString() == null || newDescriptor.getUriString().length() == 0) {
                throw new WSException(6, this.messageSource.getMessage("webservices.error.noUriGiven", null, this.getLocale()));
            }
            if (newDescriptor.getWsType() == null || newDescriptor.getWsType().length() == 0) {
                throw new WSException(6, this.messageSource.getMessage("webservices.error.noTypeGiven", null, this.getLocale()));
            }
            String wsType = newDescriptor.getWsType();
            ResourceHandler handler = this.getHandlerRegistry().getHandler(wsType);
            handler.put(this.makeServiceRequest(request, or));
            if (or.getReturnCode() != 0) {
                this.addExceptionToAllAuditEvents(new Exception(or.getMessage()));
            }
        }
        catch (WSValidationException e) {
            log.error((Object)("caught validation exception: " + e.getMessage()), (Throwable)e);
            or.setReturnCode(e.getErrorCode());
            or.setMessage(this.getValidationErrorMessage(e.getObjectName(), e.getErrors()));
            this.addExceptionToAllAuditEvents(e);
        }
        catch (WSException e) {
            or.setReturnCode(e.getErrorCode());
            or.setMessage(e.getMessage());
            this.addExceptionToAllAuditEvents(e);
        }
        catch (Exception e) {
            log.error((Object)("caught exception: " + e.getMessage()), (Throwable)e);
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
            this.addExceptionToAllAuditEvents(e);
        }
        log.debug((Object)"Marshalling response");
        return ManagementServiceImpl.marshalResponse(or);
    }

    protected String getValidationErrorMessage(String objectName, ValidationErrors errors) {
        StringBuffer message = new StringBuffer();
        List errorList = errors.getErrors();
        message.append(this.getMessage("webservices.error.validation.errors.prefix", new Object[]{new Integer(errorList.size())}));
        message.append("\n");
        for (ValidationError error : errorList) {
            message.append(this.getValidationErrorMessage(objectName, error));
            message.append("\n");
        }
        return message.toString();
    }

    protected Object getValidationErrorMessage(String objectName, ValidationError error) {
        MessageCodesResolver codesResolver = this.getMessageCodesResolver();
        String[] codes = error.getField() == null ? codesResolver.resolveMessageCodes(error.getErrorCode(), objectName) : codesResolver.resolveMessageCodes(error.getErrorCode(), objectName, error.getField(), null);
        DefaultMessageSourceResolvable messageResolvable = new DefaultMessageSourceResolvable(codes, error.getErrorArguments(), error.getDefaultMessage());
        String message = this.messageSource.getMessage((MessageSourceResolvable)messageResolvable, this.getLocale());
        return message;
    }

    protected MessageCodesResolver getMessageCodesResolver() {
        return (MessageCodesResolver)this.beanFactory.getBean(BEAN_NAME_MESSAGE_CODES_RESOLVER);
    }

    protected ServiceRequest makeServiceRequest(final com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request request, final OperationResult operationResult) {
        return new ServiceRequest(){

            @Override
            public RepositoryServiceContext getContext() {
                return ManagementServiceImpl.this;
            }

            @Override
            public ResourceDescriptor getRequestDescriptor() {
                return request.getResourceDescriptor();
            }

            @Override
            public String getRequestArgument(String name) {
                return ManagementServiceImpl.this.getArgumentValue(name, request.getArguments());
            }

            @Override
            public OperationResult getResult() {
                return operationResult;
            }
        };
    }

    protected String getArgumentValue(String argumentName, List arguments) {
        for (int i = 0; i < arguments.size(); ++i) {
            Argument a = (Argument)arguments.get(i);
            if (!(a.getName() == null ? a.getName() == argumentName : a.getName().equals(argumentName))) continue;
            return a.getValue();
        }
        return null;
    }

    @Override
    public String delete(String requestXmlString) {
        OperationResult or = new OperationResult();
        or.setVersion(WS_VERSION);
        or.setReturnCode(0);
        try {
            StringReader xmlStringReader = new StringReader(requestXmlString);
            com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request request = (com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request)Unmarshaller.unmarshal(com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request.class, (StringReader)xmlStringReader);
            this.createAuditEvent(request.getOperationName(), request.getResourceDescriptor().getWsType(), request.getResourceDescriptor().getIsNew());
            this.setLocale(request.getLocale());
            String reportUnitUrl = this.getArgumentValue("MODIFY_REPORTUNIT_URI", request.getArguments());
            if (reportUnitUrl != null && reportUnitUrl.length() > 0) {
                log.debug((Object)("Delete: resource in reportUnit: " + reportUnitUrl));
                ReportUnit reportUnit = (ReportUnit)this.repository.getResource(null, reportUnitUrl);
                if (reportUnit == null) {
                    throw new WSException(3, this.messageSource.getMessage("webservices.error.reportUnitNotFound", null, this.getLocale()));
                }
                SubResourceHandler handler = (SubResourceHandler)this.getHandlerRegistry().getHandler((Resource)reportUnit);
                handler.deleteSubResource((Resource)reportUnit, request.getResourceDescriptor(), this);
            } else {
                ResourceDescriptor rd = this.createResourceDescriptor(request.getResourceDescriptor().getUriString());
                if (rd == null) {
                    log.error((Object)("Delete: no resource : " + request.getResourceDescriptor().getUriString()));
                } else {
                    String wsType = rd.getWsType();
                    log.debug((Object)("Delete: resource : " + wsType));
                    ResourceHandler handler = this.getHandlerRegistry().getHandler(wsType);
                    handler.delete(rd, this);
                }
            }
            if (or.getReturnCode() != 0) {
                this.addExceptionToAllAuditEvents(new Exception(or.getMessage()));
            }
        }
        catch (WSException e) {
            or.setReturnCode(e.getErrorCode());
            or.setMessage(e.getMessage());
            this.addExceptionToAllAuditEvents(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("caught exception: " + e.getMessage()), (Throwable)e);
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
            this.addExceptionToAllAuditEvents(e);
        }
        log.debug((Object)"Marshalling response");
        return ManagementServiceImpl.marshalResponse(or);
    }

    @Override
    public String runReport(String requestXmlString) {
        long currentTime = System.currentTimeMillis();
        this.createAuditEvent("runReport");
        OperationResult or = new OperationResult();
        or.setVersion(WS_VERSION);
        or.setReturnCode(0);
        HashMap<String, ByteArrayDataSource> attachments = new HashMap<String, ByteArrayDataSource>();
        boolean isEncapsulationDime = false;
        try {
            StringReader xmlStringReader = new StringReader(requestXmlString);
            com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request request = (com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request)Unmarshaller.unmarshal(com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request.class, (StringReader)xmlStringReader);
            this.setLocale(request.getLocale());
            isEncapsulationDime = this.getArgumentValue("USE_DIME_ATTACHMENTS", request.getArguments()) != null;
            ResourceDescriptor reportUnit = request.getResourceDescriptor();
            log.debug((Object)("Run report: resource : " + reportUnit.getUriString()));
            String format = this.getArgumentValue("RUN_OUTPUT_FORMAT", request.getArguments());
            if (format == null) {
                format = "PDF";
            }
            format = format.toUpperCase();
            Resource reportResource = this.repository.getResource(null, reportUnit.getUriString());
            if (reportResource == null || !(reportResource instanceof ReportUnit)) {
                throw new WSException(2, this.messageSource.getMessage("webservices.error.notValidReportUnit", new Object[]{reportUnit.getUriString()}, this.getLocale()));
            }
            ReportUnit reportUnitResource = (ReportUnit)reportResource;
            Map parameters = this.buildParameterMap(reportUnit.getParameters(), reportUnit);
            boolean freshData = Boolean.parseBoolean(this.getArgumentValue("FRESH_DATA", request.getArguments()));
            boolean saveDataSnapshot = Boolean.parseBoolean(this.getArgumentValue("SAVE_DATA_SNAPSHOT", request.getArguments()));
            SimpleReportContext reportContext = new SimpleReportContext();
            parameters.put("REPORT_CONTEXT", reportContext);
            ReportUnitRequest reportRequest = new ReportUnitRequest(reportUnit.getUriString(), parameters);
            reportRequest.setReportContext((ReportContext)reportContext);
            reportRequest.setRecordDataSnapshot(this.dataSnapshotService.isSnapshotPersistenceEnabled());
            reportRequest.setUseDataSnapshot(!freshData && !saveDataSnapshot);
            ExecutionContext executionContext = this.createExecutionContext();
            ReportUnitResult result = (ReportUnitResult)this.runReportEngine.execute(executionContext, (Request)reportRequest);
            if (result == null) {
                throw new WSException(5, this.messageSource.getMessage("webservices.error.errorExecutingReportUnit", new Object[]{reportUnit.getUriString()}, this.getLocale()));
            }
            this.persistDataSnapshot(executionContext, saveDataSnapshot, reportUnitResource, (ReportContext)reportContext);
            JasperPrint jasperPrint = result.getJasperPrint();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ByteArrayDataSource bads = null;
            if (format.equals("JRPRINT")) {
                log.debug((Object)"Returning JasperPrint");
                String transformerKey = request.getArgumentValue("TRANSFORMER_KEY");
                if (transformerKey != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Transforming JasperPrint generic element for key " + transformerKey));
                    }
                    GenericElementReportTransformer.transformGenericElements((JasperPrint)jasperPrint, (String)transformerKey);
                }
                JRSaver.saveObject((Object)jasperPrint, (OutputStream)bos);
                bads = new ByteArrayDataSource(bos.toByteArray());
                attachments.put("jasperPrint", bads);
            } else {
                Map exporterParams;
                HashMap<String, String> exportParameters = new HashMap<String, String>();
                String value = this.getArgumentValue("PAGE", request.getArguments());
                if (value != null) {
                    exportParameters.put("PAGE", value);
                }
                if ((value = this.getArgumentValue("IMAGES_URI", request.getArguments())) != null) {
                    exportParameters.put("IMAGES_URI", value);
                }
                try {
                    exporterParams = this.exportReport(reportUnit.getUriString(), jasperPrint, format, bos, exportParameters);
                }
                catch (Exception e) {
                    log.error((Object)"Error exporting report", (Throwable)e);
                    throw new WSException(4, this.messageSource.getMessage("webservices.error.errorExportingReportUnit", new Object[]{e.getMessage()}, this.getLocale()));
                }
                finally {
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException ex) {}
                    }
                }
                bads = new ByteArrayDataSource(bos.toByteArray(), this.getContentType(format));
                attachments.put("report", bads);
                this.addAdditionalAttachmentsForReport(jasperPrint, attachments, format, exporterParams);
            }
            if (or.getReturnCode() != 0) {
                this.addExceptionToAllAuditEvents(new Exception(or.getMessage()));
            }
        }
        catch (WSException e) {
            or.setReturnCode(e.getErrorCode());
            or.setMessage(e.getMessage());
            this.addExceptionToAllAuditEvents(e);
        }
        catch (Throwable e) {
            log.error((Object)("caught Throwable exception: " + e.getMessage()), e);
            e.printStackTrace(System.out);
            System.out.flush();
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
            this.addExceptionToAllAuditEvents(e);
        }
        this.addPropertyToAuditEvent("runReport", "reportExecutionStartTime", new Date(currentTime));
        this.addPropertyToAuditEvent("runReport", "reportExecutionTime", System.currentTimeMillis() - currentTime);
        return ManagementServiceImpl.marshalResponse(or, attachments, isEncapsulationDime);
    }

    protected void persistDataSnapshot(ExecutionContext executionContext, boolean updateSnapshot, ReportUnit reportUnit, ReportContext reportContext) {
        DataCacheProvider.SnapshotSaveStatus snapshotSaveStatus = this.dataCacheProvider.getSnapshotSaveStatus(reportContext);
        switch (snapshotSaveStatus) {
            case NEW: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("saving initial data snapshot for " + reportUnit.getURIString()));
                }
                this.saveAutoDataSnapshot(executionContext, reportUnit, reportContext);
                break;
            }
            case UPDATED: {
                if (!updateSnapshot) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("saving updated data snapshot for " + reportUnit.getURIString()));
                }
                this.saveDataSnapshot(executionContext, reportUnit, reportContext);
                break;
            }
        }
    }

    protected void saveAutoDataSnapshot(ExecutionContext executionContext, ReportUnit reportUnit, ReportContext reportContext) {
        try {
            this.dataSnapshotService.saveAutoReportDataSnapshot(executionContext, reportContext, reportUnit);
        }
        catch (Exception e) {
            log.error((Object)("Error while saving data snapshot for " + reportUnit.getURIString()), (Throwable)e);
        }
    }

    protected void saveDataSnapshot(ExecutionContext executionContext, ReportUnit reportUnit, ReportContext reportContext) {
        try {
            this.dataSnapshotService.saveReportDataSnapshot(executionContext, reportContext, reportUnit);
        }
        catch (Exception e) {
            log.error((Object)("Error while saving data snapshot for " + reportUnit.getURIString()), (Throwable)e);
        }
    }

    private Map buildParameterMap(List paramList, ResourceDescriptor reportUnit) {
        Map<String, Object> parameters = new HashMap<String, Object>();
        for (int i = 0; i < paramList.size(); ++i) {
            ListItem param = (ListItem)paramList.get(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parameter: " + param.getLabel() + ", value: " + param.getValue()));
            }
            if (param.isIsListItem()) {
                Collection<Object> col = new ArrayList<Object>();
                Object currentValue = parameters.get(param.getLabel());
                if (currentValue != null && currentValue instanceof Collection) {
                    col = (Collection)currentValue;
                }
                col.add(param.getValue());
                parameters.put(param.getLabel(), col);
                continue;
            }
            parameters.put(param.getLabel(), param.getValue());
        }
        parameters = this.repositoryHelper.convertParameterValues(this.getReportJRParameters(reportUnit), parameters);
        return parameters;
    }

    private Map<String, JRParameter> getReportJRParameters(ResourceDescriptor reportReference) {
        JasperReport report = this.engine.getMainJasperReport(null, reportReference.getUriString());
        Map<String, JRParameter> parametersMap = this.getReportJRParameters((JRReport)report);
        parametersMap.putAll(this.getJRParametersFromDatasource(reportReference));
        return parametersMap;
    }

    private Map<String, JRParameter> getJRParametersFromDatasource(ResourceDescriptor reportReference) {
        HashMap<String, JRParameter> parametersMap = new HashMap<String, JRParameter>();
        ReportUnit reportUnit = (ReportUnit)this.repository.getResource(null, reportReference.getUriString(), ReportUnit.class);
        if (reportUnit.getDataSource() == null || reportUnit.getDataSource().getReferenceURI() == null) {
            return parametersMap;
        }
        String jrxmlURI = StringUtils.stripEnd((String)reportUnit.getDataSource().getReferenceURI(), (String)"/") + "_files/topicJRXML";
        FileResource jrxmlResource = (FileResource)this.reportLoadingService.getRepositoryService().getResource(ExecutionContextImpl.getRuntimeExecutionContext(), jrxmlURI, FileResource.class);
        if (jrxmlResource == null) {
            return parametersMap;
        }
        JasperReport report = this.reportLoadingService.getJasperReport(null, jrxmlResource, false);
        Map<String, JRParameter> dsParametersMap = this.getReportJRParameters((JRReport)report);
        parametersMap.putAll(dsParametersMap);
        return parametersMap;
    }

    private Map<String, JRParameter> getReportJRParameters(JRReport report) {
        HashMap<String, JRParameter> parametersMap = new HashMap<String, JRParameter>();
        JRParameter[] jrParameters = report.getParameters();
        if (jrParameters == null) {
            return parametersMap;
        }
        for (JRParameter parameter : jrParameters) {
            parametersMap.put(parameter.getName(), parameter);
        }
        return parametersMap;
    }

    protected Map exportReport(String reportUnitURI, JasperPrint jasperPrint, String format, OutputStream output, HashMap exportParameters) throws Exception {
        WSExporter we = this.getServiceConfiguration().getExporter(format.toLowerCase());
        return this.getServiceConfiguration().getExporter(format.toLowerCase()).exportReport(jasperPrint, output, this.getEngine(), exportParameters, this.createExecutionContext(), reportUnitURI);
    }

    protected ExecutionContext createExecutionContext() {
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setLocale(this.getLocale());
        context.setTimeZone(TimeZone.getDefault());
        return context;
    }

    @Override
    public JRExporter getExporter(String type, Map exportParameters) {
        JRExporter exporter = null;
        if (type.equals("HTML")) {
            exporter = HtmlExportUtil.getHtmlExporter((JasperReportsContext)this.getJasperReportsContext());
            if (exportParameters.get("IMAGES_URI") != null) {
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)("" + exportParameters.get("IMAGES_URI")));
            } else {
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"images/");
            }
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.TRUE);
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, new LinkedHashMap());
        } else if (type.equals("XLS")) {
            exporter = new JExcelApiExporter();
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
        } else if (type.equals("CSV")) {
            exporter = new JRCsvExporter();
        } else if (type.equals("XML")) {
            exporter = new JRXmlExporter();
        } else if (type.equals("ODT")) {
            exporter = new JRRtfExporter();
        }
        if (exporter != null && exportParameters.get("PAGE") != null) {
            exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)new Integer("" + exportParameters.get("PAGE")));
        }
        return exporter;
    }

    @Override
    public String getContentType(String type) {
        String contentType = null;
        if (type.equals("PDF")) {
            contentType = "application/pdf";
        } else if (type.equals("HTML")) {
            contentType = "text/html";
        } else if (type.equals("XLS")) {
            contentType = "application/xls";
        } else if (type.equals("CSV")) {
            contentType = "application/vnd.ms-excel";
        } else if (type.equals("XML")) {
            contentType = "text/xml";
        } else if (type.equals("ODT")) {
            contentType = "application/rtf";
        }
        return contentType;
    }

    private void addAdditionalAttachmentsForReport(JasperPrint jasperPrint, Map attachments, String format, Map exportParameters) throws WSException {
        if (!format.equals("HTML")) {
            return;
        }
        try {
            Map imagesMap = (Map)exportParameters.get(JRHtmlExporterParameter.IMAGES_MAP);
            for (Map.Entry entry : imagesMap.entrySet()) {
                String name = (String)entry.getKey();
                byte[] data = (byte[])entry.getValue();
                byte imageType = JRTypeSniffer.getImageType((byte[])data);
                String mimeType = JRTypeSniffer.getImageMimeType((byte)imageType);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding image for HTML: " + name + ", type: " + mimeType));
                }
                ByteArrayDataSource bads = new ByteArrayDataSource(data, mimeType);
                attachments.put(name, bads);
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw new WSException(4, this.messageSource.getMessage("webservices.error.errorAddingImage", new Object[]{e.getMessage()}, this.getLocale()));
        }
    }

    @Override
    public org.apache.axis.attachments.AttachmentPart[] getMessageAttachments() {
        MessageContext msgContext = MessageContext.getCurrentContext();
        Message reqMsg = msgContext.getRequestMessage();
        Attachments messageAttachments = reqMsg.getAttachmentsImpl();
        if (null == messageAttachments) {
            log.error((Object)"no attachment support");
            return new org.apache.axis.attachments.AttachmentPart[0];
        }
        int attachmentCount = messageAttachments.getAttachmentCount();
        org.apache.axis.attachments.AttachmentPart[] attachments = new org.apache.axis.attachments.AttachmentPart[attachmentCount];
        try {
            Iterator it = messageAttachments.getAttachments().iterator();
            int count = 0;
            while (it.hasNext()) {
                org.apache.axis.attachments.AttachmentPart part = (org.apache.axis.attachments.AttachmentPart)it.next();
                attachments[count++] = part;
            }
            return attachments;
        }
        catch (AxisFault e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    private void setLocale(String requestedLocale) {
        try {
            if (requestedLocale != null) {
                String language = requestedLocale;
                String country = "";
                if (requestedLocale.indexOf("_") > 0) {
                    language = requestedLocale.substring(0, requestedLocale.indexOf("_"));
                    country = requestedLocale.substring(requestedLocale.indexOf("_") + 1);
                    this.setLocale(new Locale(language, country));
                } else {
                    this.setLocale(new Locale(language));
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)("Unable to get requested locale (" + requestedLocale + ")"));
            this.setLocale(Locale.getDefault());
        }
    }

    @Override
    public String move(String requestXmlString) {
        OperationResult or = new OperationResult();
        or.setVersion(WS_VERSION);
        or.setReturnCode(0);
        try {
            com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request request = (com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request)Unmarshaller.unmarshalXml((String)requestXmlString);
            this.createAuditEvent(request.getOperationName(), request.getResourceDescriptor().getWsType(), request.getResourceDescriptor().getIsNew());
            this.setLocale(request.getLocale());
            ResourceDescriptor resource = this.createRequestResourceDescriptor(request);
            String wsType = resource.getWsType();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Move WS type: " + wsType));
            }
            ResourceHandler handler = this.getHandlerRegistry().getHandler(wsType);
            handler.move(request, this);
            if (or.getReturnCode() != 0) {
                this.addExceptionToAllAuditEvents(new Exception(or.getMessage()));
            }
        }
        catch (WSException e) {
            or.setReturnCode(e.getErrorCode());
            or.setMessage(e.getMessage());
            this.addExceptionToAllAuditEvents(e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
            this.addExceptionToAllAuditEvents(e);
        }
        return ManagementServiceImpl.marshalResponse(or);
    }

    private void createAuditEvent(String operation, String wsType, boolean isNew) {
        if ("copy".equals(operation)) {
            if ("folder".equals(wsType)) {
                this.createAuditEvent("copyFolder");
            } else {
                this.createAuditEvent("copyResource");
            }
        } else if ("move".equals(operation)) {
            if ("folder".equals(wsType)) {
                this.createAuditEvent("moveFolder");
            } else {
                this.createAuditEvent("moveResource");
            }
        } else if ("delete".equals(operation)) {
            if ("folder".equals(wsType)) {
                this.createAuditEvent("deleteFolder");
            } else {
                this.createAuditEvent("deleteResource");
            }
        } else if ("put".equals(operation)) {
            if ("folder".equals(wsType)) {
                if (isNew) {
                    this.createAuditEvent("createFolder");
                } else {
                    this.createAuditEvent("updateFolder");
                }
            } else if (isNew) {
                this.createAuditEvent("saveResource");
            } else {
                this.createAuditEvent("updateResource");
            }
        } else if ("get".equals(operation) && !"folder".equals(wsType)) {
            this.createAuditEvent("accessResource");
        }
    }

    @Override
    public String copy(String requestXmlString) {
        OperationResult or = new OperationResult();
        or.setVersion(WS_VERSION);
        or.setReturnCode(0);
        try {
            com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request request = (com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request)Unmarshaller.unmarshalXml((String)requestXmlString);
            this.createAuditEvent(request.getOperationName(), request.getResourceDescriptor().getWsType(), request.getResourceDescriptor().getIsNew());
            this.setLocale(request.getLocale());
            ResourceDescriptor resource = this.createRequestResourceDescriptor(request);
            String wsType = resource.getWsType();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Copy WS type: " + wsType));
            }
            ResourceHandler handler = this.getHandlerRegistry().getHandler(wsType);
            ResourceDescriptor copyDescriptor = handler.copy(request, this);
            or.addResourceDescriptor(copyDescriptor);
            if (or.getReturnCode() != 0) {
                this.addExceptionToAllAuditEvents(new Exception(or.getMessage()));
            }
        }
        catch (WSException e) {
            or.setReturnCode(e.getErrorCode());
            or.setMessage(e.getMessage());
            this.addExceptionToAllAuditEvents(e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
            this.addExceptionToAllAuditEvents(e);
        }
        return ManagementServiceImpl.marshalResponse(or);
    }

    protected ResourceDescriptor createRequestResourceDescriptor(com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request request) throws WSException {
        ResourceDescriptor requestResource = this.getRequestResource(request);
        String sourceURI = this.getResourceURI(requestResource);
        ResourceDescriptor resource = this.createResourceDescriptor(sourceURI);
        if (resource == null) {
            throw new WSException(6, this.getMessage("webservices.error.request.URI.not.found", new Object[]{sourceURI}));
        }
        return resource;
    }

    protected String getResourceURI(ResourceDescriptor descriptor) throws WSException {
        String sourceURI = descriptor.getUriString();
        if (sourceURI == null || sourceURI.length() == 0) {
            throw new WSException(6, this.getMessage("webservices.error.request.no.resource.URI", null));
        }
        return sourceURI;
    }

    protected ResourceDescriptor getRequestResource(com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Request request) throws WSException {
        ResourceDescriptor descriptor = request.getResourceDescriptor();
        if (descriptor == null) {
            throw new WSException(6, this.getMessage("webservices.error.request.no.resource.descriptor", null));
        }
        return descriptor;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public String getMessage(String messageCode, Object[] args) {
        return this.messageSource.getMessage(messageCode, args, this.getLocale());
    }

    @Override
    public RepositoryService getRepository() {
        return this.repository;
    }

    @Override
    public EngineService getEngine() {
        return this.engine;
    }

    @Override
    public ResourceHandlerRegistry getHandlerRegistry() {
        return this.handlerRegistry;
    }

    @Override
    public RepositoryHelper getRepositoryHelper() {
        if (this.repositoryHelper == null) {
            this.repositoryHelper = new RepositoryHelper(this.engine);
        }
        return this.repositoryHelper;
    }

    @Override
    public ManagementServiceConfiguration getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    public void setJasperReportsContext(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public void setEngine(EngineService engine) {
        this.engine = engine;
    }

    public void setHandlerRegistry(ResourceHandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public void setRunReportEngine(EngineService runReportEngine) {
        this.runReportEngine = runReportEngine;
    }

    public void setServiceConfiguration(ManagementServiceConfiguration serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

