/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.util.spring;

import com.jaspersoft.jasperserver.api.common.util.spring.ReattemptAttributes;
import com.jaspersoft.jasperserver.api.common.util.spring.ReattemptMethodAttributes;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReattemptMethodInterceptor
implements MethodInterceptor {
    private static final Log log = LogFactory.getLog(ReattemptMethodInterceptor.class);
    private ReattemptAttributes reattemptAttributes;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        ReattemptMethodAttributes attributes = this.getReattemptAttributes().getMethodAttributes(invocation.getMethod());
        Object result = null;
        if (attributes == null) {
            result = invocation.proceed();
        } else {
            boolean failed;
            int attempt = 0;
            do {
                try {
                    ++attempt;
                    result = invocation.proceed();
                    failed = false;
                }
                catch (Exception e) {
                    failed = true;
                    if (attributes.toReattempt(e, attempt)) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Caught exception on method invocation " + invocation + ", reattempting"), (Throwable)e);
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Caught exception on method invocation " + invocation + ", aborting"), (Throwable)e);
                    }
                    throw e;
                }
            } while (failed);
        }
        return result;
    }

    public ReattemptAttributes getReattemptAttributes() {
        return this.reattemptAttributes;
    }

    public void setReattemptAttributes(ReattemptAttributes reattemptAttributes) {
        this.reattemptAttributes = reattemptAttributes;
    }
}

