/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.domain.impl;

import com.jaspersoft.jasperserver.api.common.domain.LogEvent;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import org.hibernate.Hibernate;

public class RepoLogEvent
implements LogEvent {
    private long id;
    private Date occurrenceDate;
    private byte type;
    private String component;
    private String messageCode;
    private String resourceURI;
    private String text;
    private byte[] data;
    private byte state;
    private transient Blob dataBlob;
    private User user;

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
        this.dataBlob = data == null ? null : Hibernate.createBlob((byte[])data);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    public void setMessageCode(String messageCode) {
        this.messageCode = messageCode;
    }

    public Date getOccurrenceDate() {
        return this.occurrenceDate;
    }

    public void setOccurrenceDate(Date occurrenceDate) {
        this.occurrenceDate = occurrenceDate;
    }

    public String getResourceURI() {
        return this.resourceURI;
    }

    public void setResourceURI(String resourceURI) {
        this.resourceURI = resourceURI;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public byte getState() {
        return this.state;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public Blob getDataBlob() {
        return this.dataBlob;
    }

    public void setDataBlob(Blob dataBlob) {
        this.dataBlob = dataBlob;
        this.data = (byte[])(dataBlob == null ? null : this.toByteArray(dataBlob));
    }

    private byte[] toByteArray(Blob fromBlob) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] byArray = this.toByteArrayImpl(fromBlob, baos);
            return byArray;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toByteArrayImpl(Blob fromBlob, ByteArrayOutputStream baos) throws SQLException, IOException {
        byte[] buf = new byte[4000];
        InputStream is = fromBlob.getBinaryStream();
        try {
            int dataSize;
            while ((dataSize = is.read(buf)) != -1) {
                baos.write(buf, 0, dataSize);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
        return baos.toByteArray();
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public LogEvent toClient(ResourceFactory clientMappingFactory) {
        LogEvent logEvent = (LogEvent)clientMappingFactory.newObject(LogEvent.class);
        logEvent.setId(this.getId());
        logEvent.setComponent(this.getComponent());
        logEvent.setData(this.getData());
        logEvent.setMessageCode(this.getMessageCode());
        logEvent.setOccurrenceDate(this.getOccurrenceDate());
        logEvent.setResourceURI(this.getResourceURI());
        logEvent.setState(this.getState());
        logEvent.setText(this.getText());
        logEvent.setType(this.getType());
        return logEvent;
    }

    public void copyFromClient(LogEvent client) {
        this.setId(client.getId());
        this.setComponent(client.getComponent());
        this.setData(client.getData());
        this.setMessageCode(client.getMessageCode());
        this.setOccurrenceDate(client.getOccurrenceDate());
        this.setResourceURI(client.getResourceURI());
        this.setState(client.getState());
        this.setText(client.getText());
        this.setType(client.getType());
    }
}

