/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.test;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFolder;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.util.test.BaseServiceSetupTestNG;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.security.acl.basic.SimpleAclEntry;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CoreDataDeleteTestNG
extends BaseServiceSetupTestNG {
    protected final Log m_logger = LogFactory.getLog(CoreDataDeleteTestNG.class);
    SessionFactory m_sessionFactory;
    HibernateTemplate m_template;
    HibernateDaoSupport m_jasperServerDao;

    public HibernateDaoSupport getJasperServerDao() {
        return this.m_jasperServerDao;
    }

    @Resource(name="jasperServerDao")
    public void setJasperServerDao(HibernateDaoSupport jasperServerDao) {
        this.m_logger.info((Object)"setJasperServerDao() called");
        this.m_jasperServerDao = jasperServerDao;
    }

    public SessionFactory getSessionFactory() {
        return this.m_sessionFactory;
    }

    @Resource(name="sessionFactory")
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.m_logger.info((Object)"setSessionFactory() called");
        this.m_sessionFactory = sessionFactory;
    }

    @BeforeClass
    protected void onSetUp() throws Exception {
        this.m_logger.info((Object)"onSetUp() called");
        Session s = this.m_sessionFactory.openSession();
        TransactionSynchronizationManager.bindResource((Object)this.m_sessionFactory, (Object)new SessionHolder((org.hibernate.Session)s));
        this.m_template = this.m_jasperServerDao.getHibernateTemplate();
    }

    @AfterClass
    public void onTearDown() {
        this.m_logger.info((Object)"onTearDown() called");
        SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.m_sessionFactory);
        org.hibernate.Session s = holder.getSession();
        s.flush();
        TransactionSynchronizationManager.unbindResource((Object)this.m_sessionFactory);
        SessionFactoryUtils.releaseSession((org.hibernate.Session)s, (SessionFactory)this.m_sessionFactory);
    }

    @Test
    public void deleteCoreDataResources() throws Exception {
        this.m_logger.info((Object)"deleteCoreDataResources() called");
        this.deleteDefaultTheme();
        this.deleteUsersAndRoles();
        this.deleteTenantForRoot();
        this.deleteRootFolder();
    }

    private void deleteDefaultTheme() throws Exception {
        this.m_logger.info((Object)"deleteDefaultTheme() called");
        Role adminRole = this.getRole("ROLE_ADMINISTRATOR");
        ObjectPermission objPerm = this.createObjectPermission("/themes/default", adminRole, SimpleAclEntry.READ_WRITE_CREATE_DELETE);
        ExecutionContext executionContext = JasperServerUtil.getExecutionContext();
        executionContext.getAttributes().add("PRIVILEGED_OPERATION");
        this.getObjectPermissionService().putObjectPermission(executionContext, objPerm);
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("theme_files_list.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String filePath = null;
        while ((filePath = reader.readLine()) != null) {
            this.deleteThemeFile("/" + filePath);
        }
        reader.close();
        this.deleteFolder("/themes/pods_summer/images");
        this.deleteFolder("/themes/pods_summer");
        this.deleteFolder("/themes/default/images");
        this.deleteFolder("/themes/default");
        this.deleteFolder("/themes");
    }

    private void deleteThemeFile(String filePath) {
        this.m_logger.info((Object)("deleteThemeFile() => deleting file : " + filePath));
        this.getRepositoryService().deleteResource(null, filePath);
    }

    private void deleteUsersAndRoles() {
        this.m_logger.info((Object)"deleteUsersAndRoles() called");
        this.setAuthenticatedUser("jasperadmin");
        User anonUser = this.getUser("anonymousUser");
        this.removeRole(anonUser, "ROLE_ANONYMOUS");
        this.deleteRole("ROLE_ANONYMOUS");
        this.deleteUser("anonymousUser");
        User jasperadmin = this.getUser("jasperadmin");
        this.removeRole(jasperadmin, "ROLE_USER");
        this.removeRole(jasperadmin, "ROLE_ADMINISTRATOR");
        this.deleteRole("ROLE_USER");
        this.deleteRole("ROLE_ADMINISTRATOR");
        this.deleteUser("jasperadmin");
    }

    private void deleteTenantForRoot() {
        this.m_logger.info((Object)"deleteTenantForRoot() called");
        this.deleteTenant("", "organizations");
    }

    private void deleteTenant(String parentTenantId, String tenantId) {
        if (!"organizations".equals(tenantId) && !"organizations".equals(parentTenantId)) {
            tenantId = parentTenantId + "_" + tenantId;
        }
        this.getTenantService().deleteTenant(null, tenantId);
    }

    private void deleteRootFolder() {
        this.m_logger.info((Object)"deleteRootFolder() called");
        List result = this.m_template.find("from RepoFolder where uri = ?", (Object)"/");
        RepoFolder root = (RepoFolder)result.get(0);
        if (root != null) {
            this.m_template.delete((Object)root);
        } else {
            this.m_logger.error((Object)"deleteRootFolder() => FAILED to delete the root folder - RATS!");
        }
    }
}

