/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.common;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.ReportLoadingService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControlsContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.export.modules.common.ReportParameterValueBean;
import com.jaspersoft.jasperserver.export.modules.common.ReportParametersTranslator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultReportParametersTranslator
implements ReportParametersTranslator {
    private static final Log log = LogFactory.getLog(DefaultReportParametersTranslator.class);
    public static final String NULL_SUBSTITUTE = "~NULL~";
    private RepositoryService repository;
    private ReportLoadingService reportLoadingService;

    public void setReportLoadingService(ReportLoadingService reportLoadingService) {
        this.reportLoadingService = reportLoadingService;
    }

    @Override
    public ReportParameterValueBean[] getBeanParameterValues(String reportUnitURI, Map values) {
        ReportParameterValueBean[] beanValues;
        if (values == null || values.isEmpty()) {
            beanValues = null;
        } else {
            beanValues = new ReportParameterValueBean[values.size()];
            int idx = 0;
            for (Map.Entry entry : values.entrySet()) {
                ReportParameterValueBean param;
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                Object[] beanValue = this.toBeanParameterValues(value);
                for (int j = 0; j < beanValue.length; ++j) {
                    if (beanValue[j] != null) continue;
                    beanValue[j] = NULL_SUBSTITUTE;
                }
                beanValues[idx] = param = new ReportParameterValueBean(name, beanValue);
                ++idx;
            }
        }
        return beanValues;
    }

    protected Object[] toBeanParameterValues(Object value) {
        Object[] values;
        if (value == null) {
            values = new Object[]{null};
        } else if (value.getClass().isArray()) {
            int count = Array.getLength(value);
            values = new Object[count];
            for (int idx = 0; idx < count; ++idx) {
                values[idx] = Array.get(value, idx);
            }
        } else if (value instanceof Collection) {
            Collection valueCollection = (Collection)value;
            values = valueCollection.toArray();
        } else {
            values = new Object[]{value};
        }
        return values;
    }

    @Override
    public Map<String, Object> getParameterValues(String reportUnitURI, ReportParameterValueBean[] beanValues, ExecutionContext context) {
        HashMap<String, Object> values;
        if (beanValues == null || beanValues.length == 0) {
            values = null;
        } else {
            values = new HashMap<String, Object>();
            ReportUnit reportUnit = (ReportUnit)this.getRepository().getResource(null, reportUnitURI, ReportUnit.class);
            this.populateParameterValues(reportUnit, beanValues, values, context);
        }
        return values;
    }

    protected void populateParameterValues(ReportUnit reportUnit, ReportParameterValueBean[] beanValues, Map<String, Object> values, ExecutionContext context) {
        Map inputControls = this.collectInputControls(reportUnit, context);
        JRReport jReport = this.getReport(reportUnit);
        for (int i = 0; i < beanValues.length; ++i) {
            ReportParameterValueBean beanParam = beanValues[i];
            String name = (String)beanParam.getName();
            Object[] beanValue = beanParam.getValues();
            if (beanValue != null) {
                for (int j = 0; j < beanValue.length; ++j) {
                    if (!NULL_SUBSTITUTE.equals(beanValue[j])) continue;
                    beanValue[j] = null;
                }
            } else {
                beanValue = new Object[]{null};
            }
            Object value = this.toParameterValue(reportUnit, inputControls, jReport, name, beanValue);
            values.put(name, value);
        }
    }

    @Override
    public Map<String, Object> getParameterValues(ReportUnit reportUnit, ReportParameterValueBean[] beanValues, ExecutionContext context) {
        HashMap<String, Object> values;
        if (beanValues == null || beanValues.length == 0) {
            values = null;
        } else {
            values = new HashMap<String, Object>();
            this.populateParameterValues(reportUnit, beanValues, values, context);
        }
        return values;
    }

    protected JRReport getReport(ReportUnit reportUnit) {
        FileResource mainReportRes;
        ResourceReference mainReportRef = reportUnit.getMainReport();
        InputStream jrxmlStream = null;
        if (mainReportRef.isLocal() && (mainReportRes = (FileResource)mainReportRef.getLocalResource()).hasData()) {
            jrxmlStream = new ByteArrayInputStream(mainReportRes.getData());
        }
        if (jrxmlStream == null) {
            String jrxmlUri = mainReportRef.getTargetURI();
            FileResourceData jrxmlData = this.getRepository().getResourceData(null, jrxmlUri);
            jrxmlStream = jrxmlData.getDataStream();
        }
        try {
            JasperDesign design;
            JasperDesign jasperDesign = design = JRXmlLoader.load(jrxmlStream);
            return jasperDesign;
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        finally {
            try {
                jrxmlStream.close();
            }
            catch (IOException e) {
                log.warn((Object)"Error closing resource data stream", (Throwable)e);
            }
        }
    }

    protected Map collectInputControls(ReportUnit reportUnit, ExecutionContext context) {
        HashMap<String, InputControl> controls = new HashMap<String, InputControl>();
        List inputControls = this.reportLoadingService.getInputControls(context, (InputControlsContainer)reportUnit);
        if (inputControls != null) {
            for (InputControl inputControl : inputControls) {
                controls.put(inputControl.getName(), inputControl);
            }
        }
        return controls;
    }

    protected Object toParameterValue(ReportUnit reportUnit, Map inputControls, JRReport jReport, String name, Object[] beanValue) {
        JRParameter parameter;
        InputControl control = (InputControl)inputControls.get(name);
        Object value = control == null ? ((parameter = this.getParameter(jReport, name)) == null ? beanValue : (parameter.getValueClass().isArray() ? this.toArrayValue(parameter.getValueClass(), beanValue) : (Collection.class.isAssignableFrom(parameter.getValueClass()) ? this.toCollectionValue(parameter.getValueClass(), beanValue) : (Object.class.equals((Object)parameter.getValueClass()) ? (beanValue == null || beanValue.length == 0 ? null : (beanValue.length == 1 ? beanValue[0] : beanValue)) : this.toSingleValue(reportUnit, name, beanValue))))) : (this.isMulti(control) ? this.toCollectionValue(Collection.class, beanValue) : this.toSingleValue(reportUnit, name, beanValue));
        return value;
    }

    protected boolean isMulti(InputControl control) {
        byte type = control.getType();
        return type == 6 || type == 10 || type == 7 || type == 11 || type == 5;
    }

    protected JRParameter getParameter(JRReport report, String name) {
        JRParameter parameter = null;
        JRParameter[] parameters = report.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!name.equals(parameters[i].getName())) continue;
            parameter = parameters[i];
            break;
        }
        return parameter;
    }

    protected Object toSingleValue(ReportUnit reportUnit, String name, Object[] beanValue) {
        Object value;
        if (beanValue == null || beanValue.length == 0) {
            value = null;
        } else if (beanValue.length == 1) {
            value = beanValue[0];
        } else {
            throw new JSException("jsexception.import.multiple.values.for.single.parameter", new Object[]{name, reportUnit.getURIString()});
        }
        return value;
    }

    protected Object toArrayValue(Class valueClass, Object[] beanValue) {
        Object value;
        Class<?> componentType = valueClass.getComponentType();
        if (beanValue == null) {
            value = Array.newInstance(componentType, 0);
        } else {
            value = Array.newInstance(componentType, beanValue.length);
            for (int i = 0; i < beanValue.length; ++i) {
                Array.set(value, i, beanValue[i]);
            }
        }
        return value;
    }

    protected Object toCollectionValue(Class valueClass, Object[] beanValue) {
        Object value;
        if (valueClass.equals(Object.class) || valueClass.equals(Collection.class) || valueClass.equals(Set.class)) {
            value = new ListOrderedSet();
            if (beanValue != null) {
                for (int i = 0; i < beanValue.length; ++i) {
                    value.add(beanValue[i]);
                }
            }
        } else if (valueClass.equals(List.class)) {
            if (beanValue == null) {
                value = new ArrayList(0);
            } else {
                value = new ArrayList(beanValue.length);
                for (int i = 0; i < beanValue.length; ++i) {
                    value.add(beanValue[i]);
                }
            }
        } else {
            throw new JSException("jsexception.unknown.parameter.type.for.multiple.value.input", new Object[]{valueClass.getName()});
        }
        return value;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }
}

