/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorImpl;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobIdHolder;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRuntimeInformation;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSimpleTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsScheduler;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportSchedulerListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronScheduleBuilder;
import org.quartz.DateBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Matcher;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.KeyMatcher;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.utils.Key;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class ReportJobsQuartzScheduler
implements ReportJobsScheduler,
InitializingBean {
    protected static final Log log = LogFactory.getLog(ReportJobsQuartzScheduler.class);
    private static final String GROUP = "ReportJobs";
    private static final String TRIGGER_LISTENER_NAME = "reportSchedulerTriggerListener";
    private static final long COEFFICIENT_MINUTE = 60000L;
    private static final long COEFFICIENT_HOUR = 3600000L;
    private static final long COEFFICIENT_DAY = 86400000L;
    private static final long COEFFICIENT_WEEK = 604800000L;
    private static final int COUNT_WEEKDAYS = 7;
    private static final int COUNT_MONTHS = 12;
    private Scheduler scheduler;
    private Class reportExecutionJobClass;
    private final Set listeners = new HashSet();
    private final SchedulerListener schedulerListener = new ReportSchedulerQuartzListener();
    private final TriggerListener triggerListener = new ReportSchedulerTriggerListener("reportSchedulerTriggerListener");

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Class getReportExecutionJobClass() {
        return this.reportExecutionJobClass;
    }

    public void setReportExecutionJobClass(Class reportExecutionJobClass) {
        this.reportExecutionJobClass = reportExecutionJobClass;
    }

    public void afterPropertiesSet() {
        try {
            this.getScheduler().getListenerManager().addTriggerListener(this.triggerListener, (List)null);
            this.getScheduler().getListenerManager().addSchedulerListener(this.schedulerListener);
        }
        catch (SchedulerException e) {
            log.error((Object)"Error (de)registering Quartz listener", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void scheduleJob(ExecutionContext context, ReportJob job) {
        JobDetail jobDetail = this.createJobDetail(job);
        Trigger trigger = this.createTrigger(job);
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created job " + jobDetail.getKey().getName() + " and trigger " + trigger.getKey().getName() + " for job " + job.getId()));
            }
        }
        catch (SchedulerException e) {
            log.error((Object)"Error scheduling Quartz job", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected JobDetail createJobDetail(ReportJob job) {
        String jobName = this.jobName(job.getId());
        JobDetail jobDetail = JobBuilder.newJob((Class)this.getReportExecutionJobClass()).withIdentity(jobName, GROUP).requestRecovery(true).build();
        return jobDetail;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void rescheduleJob(ExecutionContext context, ReportJob job) {
        try {
            Trigger oldTrigger = this.getReportJobTrigger(job.getId());
            String jobName = this.jobName(job.getId());
            Trigger trigger = this.createTrigger(job);
            if (oldTrigger == null) {
                this.scheduler.scheduleJob(trigger);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Scheduled trigger " + trigger.getKey().getName() + " for job " + job.getId()));
                }
            } else {
                this.scheduler.rescheduleJob(oldTrigger.getKey(), trigger);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trigger " + oldTrigger.getKey().getName() + " rescheduled by " + trigger.getKey().getName() + " for job " + job.getId()));
                }
            }
        }
        catch (SchedulerException e) {
            log.error((Object)"Error rescheduling Quartz job", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected Trigger getReportJobTrigger(long jobId) throws SchedulerException {
        Trigger trigger;
        String jobName = this.jobName(jobId);
        ArrayList<Trigger> triggers = this.scheduler.getTriggersOfJob(this.getJobKey(jobName));
        ArrayList<Trigger> filteredTriggersList = new ArrayList<Trigger>();
        for (Trigger currTrigger : triggers) {
            if (!GROUP.equals(currTrigger.getKey().getGroup())) continue;
            filteredTriggersList.add(currTrigger);
        }
        triggers = filteredTriggersList;
        if (triggers == null || triggers.isEmpty()) {
            trigger = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("No trigger found for job " + jobId));
            }
        } else if (triggers.size() == 1) {
            trigger = (Trigger)triggers.get(0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trigger " + trigger.getKey().getName() + " found for job " + jobId));
            }
        } else {
            throw new JSException("jsexception.job.has.more.than.one.trigger", new Object[]{new Long(jobId)});
        }
        return trigger;
    }

    protected String jobName(long jobId) {
        return "job_" + jobId;
    }

    protected String triggerName(ReportJobTrigger jobTrigger) {
        return "trigger_" + jobTrigger.getId() + "_" + jobTrigger.getVersion();
    }

    protected Trigger createTrigger(ReportJob reportJob) {
        Trigger trigger;
        ReportJobTrigger jobTrigger = reportJob.getTrigger();
        if (jobTrigger instanceof ReportJobSimpleTrigger) {
            trigger = this.createTrigger((ReportJobSimpleTrigger)jobTrigger);
        } else if (jobTrigger instanceof ReportJobCalendarTrigger) {
            trigger = this.createTrigger((ReportJobCalendarTrigger)jobTrigger);
        } else {
            String quotedJobTrigger = "\"" + jobTrigger.getClass().getName() + "\"";
            throw new JSException("jsexception.job.unknown.trigger.type", new Object[]{quotedJobTrigger});
        }
        JobDataMap jobDataMap = trigger.getJobDataMap();
        jobDataMap.put("jobDetailsID", (Object)new Long(reportJob.getId()));
        jobDataMap.put("jobUser", reportJob.getUsername());
        TriggerKey tk = this.getTriggerKey(jobTrigger);
        KeyMatcher matcher = KeyMatcher.keyEquals((Key)tk);
        try {
            this.getScheduler().getListenerManager().addTriggerListener(this.triggerListener, (Matcher)matcher);
        }
        catch (SchedulerException e) {
            throw new JSException("Error adding Quartz Trigger Listener: " + e.getMessage());
        }
        return trigger;
    }

    protected Trigger createTrigger(ReportJobSimpleTrigger jobTrigger) {
        String triggerName = this.triggerName((ReportJobTrigger)jobTrigger);
        Date startDate = this.getStartDate((ReportJobTrigger)jobTrigger);
        Date endDate = this.getEndDate((ReportJobTrigger)jobTrigger);
        String calendarName = jobTrigger.getCalendarName();
        int repeatCount = this.repeatCount(jobTrigger);
        Trigger trigger = null;
        if (repeatCount == 0) {
            trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, GROUP).startAt(startDate).modifiedByCalendar(calendarName).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(0)).build();
        } else {
            int recurrenceInterval = jobTrigger.getRecurrenceInterval();
            long unitCoefficient = this.getIntervalUnitCoefficient(jobTrigger);
            long interval = (long)recurrenceInterval * unitCoefficient;
            trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, GROUP).startAt(startDate).endAt(endDate).modifiedByCalendar(calendarName).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(interval).withRepeatCount(repeatCount).withMisfireHandlingInstructionFireNow()).build();
        }
        return trigger;
    }

    protected Trigger createTrigger(ReportJobCalendarTrigger jobTrigger) {
        String triggerName = this.triggerName((ReportJobTrigger)jobTrigger);
        Date startDate = this.getStartDate((ReportJobTrigger)jobTrigger);
        Date endDate = this.getEndDate((ReportJobTrigger)jobTrigger);
        String calendarName = jobTrigger.getCalendarName();
        String cronExpression = this.getCronExpression(jobTrigger);
        try {
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, GROUP).startAt(startDate).endAt(endDate).modifiedByCalendar(calendarName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).inTimeZone(this.getTriggerTimeZone((ReportJobTrigger)jobTrigger))).build();
            return trigger;
        }
        catch (Exception e) {
            log.error((Object)"Error creating Quartz Cron trigger", (Throwable)e);
            throw new JSExceptionWrapper(e);
        }
    }

    protected long getIntervalUnitCoefficient(ReportJobSimpleTrigger jobTrigger) {
        long coefficient;
        switch (jobTrigger.getRecurrenceIntervalUnit()) {
            case 1: {
                coefficient = 60000L;
                break;
            }
            case 2: {
                coefficient = 3600000L;
                break;
            }
            case 3: {
                coefficient = 86400000L;
                break;
            }
            case 4: {
                coefficient = 604800000L;
                break;
            }
            default: {
                throw new JSException("jsexception.job.unknown.interval.unit", new Object[]{jobTrigger.getRecurrenceIntervalUnit()});
            }
        }
        return coefficient;
    }

    protected Date getEndDate(ReportJobTrigger jobTrigger) {
        return this.translateFromTriggerTimeZone(jobTrigger, jobTrigger.getEndDate());
    }

    protected Date translateFromTriggerTimeZone(ReportJobTrigger jobTrigger, Date date) {
        TimeZone tz;
        if (date != null && (tz = this.getTriggerTimeZone(jobTrigger)) != null) {
            date = DateBuilder.translateTime((Date)date, (TimeZone)TimeZone.getDefault(), (TimeZone)tz);
        }
        return date;
    }

    protected Date getStartDate(ReportJobTrigger jobTrigger) {
        Date startDate;
        switch (jobTrigger.getStartType()) {
            case 1: {
                Calendar calendar = Calendar.getInstance();
                calendar.set(13, 0);
                calendar.set(14, 0);
                startDate = calendar.getTime();
                break;
            }
            case 2: {
                startDate = this.translateFromTriggerTimeZone(jobTrigger, jobTrigger.getStartDate());
                break;
            }
            default: {
                throw new JSException("jsexception.job.unknown.start.type", new Object[]{new Byte(jobTrigger.getStartType())});
            }
        }
        return startDate;
    }

    protected int repeatCount(ReportJobSimpleTrigger jobTrigger) {
        int repeatCount;
        int recurrenceCount = jobTrigger.getOccurrenceCount();
        switch (recurrenceCount) {
            case -1: {
                repeatCount = -1;
                break;
            }
            default: {
                repeatCount = recurrenceCount - 1;
            }
        }
        return repeatCount;
    }

    protected TimeZone getTriggerTimeZone(ReportJobTrigger jobTrigger) {
        TimeZone tz;
        String tzId = jobTrigger.getTimezone();
        if (tzId == null || tzId.length() == 0) {
            tz = null;
        } else {
            tz = TimeZone.getTimeZone(tzId);
            if (tz == null) {
                String quotedTzId = "\"" + tzId + "\"";
                throw new JSException("jsexception.unknown.timezone", new Object[]{quotedTzId});
            }
        }
        return tz;
    }

    protected String getCronExpression(ReportJobCalendarTrigger jobTrigger) {
        String monthDays;
        String weekDays;
        String minutes = jobTrigger.getMinutes();
        String hours = jobTrigger.getHours();
        switch (jobTrigger.getDaysType()) {
            case 1: {
                weekDays = "?";
                monthDays = "*";
                break;
            }
            case 2: {
                weekDays = this.enumerateCronVals(jobTrigger.getWeekDays(), 7);
                monthDays = "?";
                break;
            }
            case 3: {
                weekDays = "?";
                monthDays = jobTrigger.getMonthDays();
                break;
            }
            default: {
                throw new JSException("jsexception.job.unknown.calendar.trigger.days.type", new Object[]{new Byte(jobTrigger.getDaysType())});
            }
        }
        String months = this.enumerateCronVals(jobTrigger.getMonths(), 12);
        StringBuffer cronExpression = new StringBuffer();
        cronExpression.append("0 ");
        cronExpression.append(minutes);
        cronExpression.append(' ');
        cronExpression.append(hours);
        cronExpression.append(' ');
        cronExpression.append(monthDays);
        cronExpression.append(' ');
        cronExpression.append(months);
        cronExpression.append(' ');
        cronExpression.append(weekDays);
        return cronExpression.toString();
    }

    protected int getMisfireCode(ReportJobTrigger jobTrigger) {
        int i = jobTrigger.getMisfireInstruction();
        if (i == 0) {
            return -1;
        }
        if (jobTrigger instanceof ReportJobSimpleTrigger) {
            if (i == 1) {
                return 1;
            }
            if (i == 5) {
                return 5;
            }
            if (i == 4) {
                return 4;
            }
            if (i == 2) {
                return 2;
            }
            if (i == 3) {
                return 3;
            }
        } else if (jobTrigger instanceof ReportJobCalendarTrigger) {
            if (i == 2) {
                return 2;
            }
            if (i == 1) {
                return 1;
            }
        }
        if (i == -1) {
            return -1;
        }
        if (i == -999) {
            return 0;
        }
        throw new JSException("Unhandled misfire instruction of value " + i);
    }

    protected String enumerateCronVals(SortedSet vals, int totalCount) {
        if (vals == null || vals.isEmpty()) {
            throw new JSException("jsexception.no.values.to.enumerate");
        }
        if (vals.size() == totalCount) {
            return "*";
        }
        StringBuffer enumStr = new StringBuffer();
        for (Byte val : vals) {
            enumStr.append(val.byteValue());
            enumStr.append(',');
        }
        return enumStr.substring(0, enumStr.length() - 1);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void removeScheduledJob(ExecutionContext context, long jobId) {
        try {
            String jobName = this.jobName(jobId);
            if (this.scheduler.deleteJob(this.getJobKey(jobName))) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Job " + jobName + "deleted"));
                }
            } else {
                log.info((Object)("Quartz job " + jobId + " was not found to be deleted"));
            }
        }
        catch (SchedulerException e) {
            log.error((Object)("Error deleting Quartz job " + jobId), (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    public ReportJobRuntimeInformation[] getJobsRuntimeInformation(ExecutionContext context, long[] jobIds) {
        if (jobIds == null) {
            return null;
        }
        try {
            Set executingJobNames = this.getExecutingJobNames();
            ReportJobRuntimeInformation[] infos = new ReportJobRuntimeInformation[jobIds.length];
            for (int i = 0; i < jobIds.length; ++i) {
                infos[i] = this.getJobRuntimeInformation(jobIds[i], executingJobNames);
            }
            return infos;
        }
        catch (SchedulerException e) {
            log.error((Object)"Error while fetching Quartz runtime information", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected ReportJobRuntimeInformation getJobRuntimeInformation(long jobId, Set executingJobNames) throws SchedulerException {
        ReportJobRuntimeInformation info = new ReportJobRuntimeInformation();
        Trigger trigger = this.getReportJobTrigger(jobId);
        if (trigger == null) {
            info.setState((byte)0);
        } else {
            info.setPreviousFireTime(trigger.getPreviousFireTime());
            if (trigger.mayFireAgain()) {
                info.setNextFireTime(trigger.getNextFireTime());
            }
            byte state = this.getJobState(trigger, executingJobNames);
            info.setState(state);
        }
        return info;
    }

    protected byte getJobState(Trigger trigger, Set executingJobNames) throws SchedulerException {
        int state;
        Trigger.TriggerState quartzState = this.scheduler.getTriggerState(trigger.getKey());
        switch (quartzState) {
            case NORMAL: 
            case BLOCKED: {
                state = executingJobNames.contains(trigger.getKey().getName()) ? 2 : 1;
                break;
            }
            case COMPLETE: {
                state = 4;
                break;
            }
            case PAUSED: {
                state = 3;
                break;
            }
            case ERROR: {
                state = 5;
                break;
            }
            default: {
                state = 0;
            }
        }
        return (byte)state;
    }

    protected Set getExecutingJobNames() throws SchedulerException {
        List executingJobs = this.scheduler.getCurrentlyExecutingJobs();
        HashSet<String> executingJobNames = new HashSet<String>();
        for (JobExecutionContext executionContext : executingJobs) {
            JobDetail jobDetail = executionContext.getJobDetail();
            if (!jobDetail.getKey().getGroup().equals(GROUP)) continue;
            executingJobNames.add(jobDetail.getKey().getName());
        }
        return executingJobNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReportSchedulerListener(ReportSchedulerListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeReportSchedulerListener(ReportSchedulerListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public void pause(List<ReportJob> jobs, boolean all) {
        if (all) {
            this.pauseById(null, all);
            return;
        }
        ArrayList<ReportJobIdHolder> ids = new ArrayList<ReportJobIdHolder>();
        for (ReportJob job : jobs) {
            ids.add(new ReportJobIdHolder(job.getId()));
        }
        this.pauseById(ids, all);
    }

    public void pauseById(List<ReportJobIdHolder> jobIds, boolean all) {
        boolean exception = false;
        StringBuilder sb = new StringBuilder();
        if (all) {
            try {
                this.scheduler.pauseAll();
                return;
            }
            catch (SchedulerException e) {
                sb.append("Exception while attempting to do 'pauseAll()' on Quartz Scheduler. ");
                throw new JSException(sb.toString(), e.getUnderlyingException());
            }
        }
        if (jobIds == null || jobIds.size() <= 0) {
            return;
        }
        for (ReportJobIdHolder id : jobIds) {
            String jobName = this.jobName(id.getId());
            try {
                this.scheduler.pauseJob(this.getJobKey(jobName));
                sb.append("pause of ReportJob id='" + id + "' successful.");
            }
            catch (SchedulerException e) {
                exception = true;
                sb.append("Exception while attempting to do pause of ReportJob id='" + id + "' on Quartz Scheduler: ");
                sb.append(e.getMessage());
                sb.append("\n");
            }
        }
        if (exception) {
            throw new JSException(sb.toString());
        }
    }

    public void resume(List<ReportJob> jobs, boolean all) {
        if (all) {
            this.resumeById(null, all);
            return;
        }
        ArrayList<ReportJobIdHolder> ids = new ArrayList<ReportJobIdHolder>();
        for (ReportJob job : jobs) {
            ids.add(new ReportJobIdHolder(job.getId()));
        }
        this.resumeById(ids, all);
    }

    public void resumeById(List<ReportJobIdHolder> jobIds, boolean all) {
        boolean exception = false;
        StringBuilder sb = new StringBuilder();
        if (all) {
            try {
                this.scheduler.resumeAll();
                return;
            }
            catch (SchedulerException e) {
                sb.append("Exception while attempting to do 'resumeAll()' on Quartz Scheduler. ");
                throw new JSException(e.getUnderlyingException());
            }
        }
        if (jobIds == null || jobIds.size() <= 0) {
            return;
        }
        for (ReportJobIdHolder id : jobIds) {
            String jobName = this.jobName(id.getId());
            try {
                this.scheduler.resumeJob(this.getJobKey(jobName));
                sb.append("resume of ReportJob id='" + id.getId() + "' successful.");
            }
            catch (SchedulerException e) {
                exception = true;
                sb.append("Exception while attempting to do resume of ReportJob id='" + id.getId() + "' on Quartz Scheduler: ");
                sb.append(e.getMessage());
                sb.append("\n");
            }
        }
        if (exception) {
            throw new JSException(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListenersOfFinalizedJob(long jobId) {
        Set set = this.listeners;
        synchronized (set) {
            for (ReportSchedulerListener listener : this.listeners) {
                listener.reportJobFinalized(jobId);
            }
        }
    }

    protected void reportTriggerFinalized(Trigger trigger) {
        long jobId = trigger.getJobDataMap().getLongValue("jobDetailsID");
        this.notifyListenersOfFinalizedJob(jobId);
    }

    protected JobKey getJobKey(ReportJob job) {
        return this.getJobKey(this.jobName(job.getId()));
    }

    protected JobKey getJobKey(String jobName) {
        return new JobKey(jobName, GROUP);
    }

    protected TriggerKey getTriggerKey(ReportJobTrigger jobTrigger) {
        return new TriggerKey(this.triggerName(jobTrigger), GROUP);
    }

    public void addCalendar(String calName, org.quartz.Calendar calendar, boolean replace, boolean updateTriggers) throws JSException {
        try {
            this.scheduler.addCalendar(calName, calendar, replace, updateTriggers);
        }
        catch (Exception ex) {
            throw new JSException((Throwable)ex);
        }
    }

    public boolean deleteCalendar(String calName) throws JSException {
        try {
            return this.scheduler.deleteCalendar(calName);
        }
        catch (Exception ex) {
            throw new JSException((Throwable)ex);
        }
    }

    public org.quartz.Calendar getCalendar(String calName) throws JSException {
        try {
            return this.scheduler.getCalendar(calName);
        }
        catch (Exception ex) {
            throw new JSException((Throwable)ex);
        }
    }

    public List<String> getCalendarNames() throws JSException {
        try {
            return this.scheduler.getCalendarNames();
        }
        catch (Exception ex) {
            throw new JSException((Throwable)ex);
        }
    }

    public void validate(ReportJob job, ValidationErrors errors) {
        Trigger quartzTrigger = this.createTrigger(job);
        AbstractTrigger abstrTrigger = (AbstractTrigger)quartzTrigger;
        Date firstFireTime = abstrTrigger.computeFirstFireTime(null);
        if (firstFireTime == null) {
            errors.add((ValidationError)new ValidationErrorImpl("error.report.job.trigger.no.fire", null, null, "trigger"));
        }
    }

    private void p(String s) {
        System.err.println(this.getClass().getName() + " - " + s);
    }

    protected class ReportSchedulerTriggerListener
    implements TriggerListener {
        private final String name;

        public ReportSchedulerTriggerListener(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void triggerFired(Trigger trigger, JobExecutionContext context) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz trigger fired " + trigger.getKey()));
            }
        }

        public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
            return false;
        }

        public void triggerMisfired(Trigger trigger) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz trigger misfired " + trigger.getKey()));
            }
            if (!trigger.getKey().getGroup().equals(ReportJobsQuartzScheduler.GROUP) || trigger.getFireTimeAfter(new Date()) == null) {
                // empty if block
            }
        }

        public void triggerComplete(Trigger trigger, JobExecutionContext context, Trigger.CompletedExecutionInstruction triggerInstructionCode) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz trigger complete " + trigger.getKey() + " triggerInstructionCode=" + triggerInstructionCode));
            }
        }
    }

    protected class ReportSchedulerQuartzListener
    implements SchedulerListener {
        public void jobUnscheduled(TriggerKey triggerKey) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz job with triggerKey: " + triggerKey + " unscheduled"));
            }
        }

        public void triggerPaused(TriggerKey triggerKey) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz job trigger" + triggerKey + " paused"));
            }
        }

        public void triggersPaused(String triggerGroup) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz job trigger group " + triggerGroup + " paused "));
            }
        }

        public void triggerResumed(TriggerKey triggerKey) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz job trigger " + triggerKey + " resumed "));
            }
        }

        public void triggersResumed(String triggerGroup) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz job trigger group" + triggerGroup + " resumed "));
            }
        }

        public void jobAdded(JobDetail jobDetail) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz job " + jobDetail.getKey() + " added. "));
            }
        }

        public void jobDeleted(JobKey jobKey) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz job " + jobKey + " deleted "));
            }
        }

        public void jobPaused(JobKey jobKey) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz job " + jobKey + " paused "));
            }
        }

        public void jobsPaused(String jobGroup) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz job Group " + jobGroup + " paused "));
            }
        }

        public void jobResumed(JobKey jobKey) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz job " + jobKey + " resumed  "));
            }
        }

        public void jobsResumed(String jobGroup) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz job  Group " + jobGroup + " resumed  "));
            }
        }

        public void schedulerInStandbyMode() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Quartz Scheduler in standby mode ");
            }
        }

        public void schedulerStarted() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Quartz Scheduler started");
            }
        }

        public void schedulerShuttingdown() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Quartz Scheduler shutting down");
            }
        }

        public void schedulingDataCleared() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Quartz Scheduler Data Cleared");
            }
        }

        public void jobScheduled(Trigger trigger) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz job " + trigger.getKey() + " scheduled by trigger " + trigger.getKey()));
            }
        }

        public void jobUnscheduled(String name, String group) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz job unscheduled " + group + "." + name));
            }
        }

        public void triggerFinalized(Trigger trigger) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Quartz trigger finalized " + trigger.getKey()));
            }
            if (trigger.getKey().getGroup().equals(ReportJobsQuartzScheduler.GROUP)) {
                ReportJobsQuartzScheduler.this.reportTriggerFinalized(trigger);
            }
        }

        public void schedulerError(String msg, SchedulerException cause) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Quartz scheduler error: " + msg), (Throwable)cause);
            }
        }

        public void schedulerShutdown() {
            if (log.isInfoEnabled()) {
                log.info((Object)"Quartz scheduler shutdown");
            }
        }
    }
}

