/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.JSException;
import java.util.Date;
import java.util.Map;
import org.quartz.JobDetail;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Constants;
import org.springframework.scheduling.quartz.JobDetailAwareTrigger;

public class JSSimpleTriggerBean
extends SimpleTriggerImpl
implements JobDetailAwareTrigger,
BeanNameAware,
InitializingBean {
    private static final Constants constants = new Constants(SimpleTriggerImpl.class);
    private JobDetail jobDetail;
    private String beanName;
    private long startDelay = 0L;

    public JSSimpleTriggerBean() {
        this.setRepeatCount(-1);
    }

    public void setJobDataAsMap(Map jobDataAsMap) {
        this.getJobDataMap().putAll(jobDataAsMap);
    }

    public void setMisfireInstructionName(String constantName) {
        this.setMisfireInstruction(constants.asNumber(constantName).intValue());
    }

    public void setTriggerListenerNames(String[] names) {
        int i = 0;
        if (i < names.length) {
            throw new JSException("Error !  unhandled setTriggerListenerNames from old Quartz 1.5.  Need to port to Quartz 2.1.2");
        }
    }

    public void setStartDelay(long startDelay) {
        this.startDelay = startDelay;
    }

    public void setJobDetail(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    public JobDetail getJobDetail() {
        return this.jobDetail;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getName() == null) {
            this.setName(this.beanName);
        }
        if (this.getGroup() == null) {
            this.setGroup("DEFAULT");
        }
        if (this.getStartTime() == null) {
            this.setStartTime(new Date(System.currentTimeMillis() + this.startDelay));
        }
        if (this.jobDetail != null) {
            this.setJobKey(this.jobDetail.getKey());
        }
    }
}

