/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.hibernate;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.FTPInfoModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.reportjobmodel.ReportJobRepositoryDestinationModel;
import com.jaspersoft.jasperserver.api.engine.scheduling.hibernate.PersistentFTPInfo;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.hibernate.RepoUser;
import com.jaspersoft.jasperserver.api.metadata.user.service.ProfileAttributeService;
import java.util.Iterator;
import java.util.List;

public class PersistentReportJobRepositoryDestination {
    private long id;
    private int version = -1;
    private String folderURI;
    private boolean sequentialFilenames;
    private boolean overwriteFiles;
    private String outputDescription;
    private String timestampPattern;
    private boolean saveToRepository = true;
    private static String DEFAULT_REPORT_OUTPUT_FOLDER_URI = "DEFAULT_REPORT_OUTPUT_FOLDER_URI";
    private boolean usingDefaultReportOutputFolderURI = true;
    private String outputLocalFolder = null;
    private PersistentFTPInfo outputFTPInfo = null;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getFolderURI() {
        return this.folderURI;
    }

    public void setFolderURI(String folder) {
        this.folderURI = folder;
    }

    public boolean isSequentialFilenames() {
        return this.sequentialFilenames;
    }

    public void setSequentialFilenames(boolean sequentialFilenames) {
        this.sequentialFilenames = sequentialFilenames;
    }

    public boolean isOverwriteFiles() {
        return this.overwriteFiles;
    }

    public void setOverwriteFiles(boolean overwriteFiles) {
        this.overwriteFiles = overwriteFiles;
    }

    public boolean isSaveToRepository() {
        return this.saveToRepository;
    }

    public void setSaveToRepository(boolean saveToRepository) {
        this.saveToRepository = saveToRepository;
    }

    public boolean isUsingDefaultReportOutputFolderURI() {
        return this.usingDefaultReportOutputFolderURI;
    }

    public void setUsingDefaultReportOutputFolderURI(boolean usingDefaultReportOutputFolderURI) {
        this.usingDefaultReportOutputFolderURI = usingDefaultReportOutputFolderURI;
    }

    public String getOutputLocalFolder() {
        return this.outputLocalFolder;
    }

    public void setOutputLocalFolder(String outputLocalFolder) {
        this.outputLocalFolder = outputLocalFolder;
    }

    public PersistentFTPInfo getOutputFTPInfo() {
        return this.outputFTPInfo;
    }

    public void setOutputFTPInfo(PersistentFTPInfo outputFTPInfo) {
        this.outputFTPInfo = outputFTPInfo;
    }

    public void copyFrom(ReportJobRepositoryDestination repositoryDestination, List unusedEntities, ProfileAttributeService profileAttributeService, RepoUser user, ExecutionContext context) {
        this.setFolderURI(repositoryDestination.getFolderURI());
        this.setSequentialFilenames(repositoryDestination.isSequentialFilenames());
        this.setOverwriteFiles(repositoryDestination.isOverwriteFiles());
        this.setOutputDescription(repositoryDestination.getOutputDescription());
        this.setTimestampPattern(repositoryDestination.getTimestampPattern());
        this.setSaveToRepository(repositoryDestination.isSaveToRepository());
        if (repositoryDestination.getDefaultReportOutputFolderURI() != null) {
            this.setDefaultScheduledReportOutputFolderURI(repositoryDestination.getDefaultReportOutputFolderURI(), profileAttributeService, user, context);
        }
        this.setUsingDefaultReportOutputFolderURI(repositoryDestination.isUsingDefaultReportOutputFolderURI());
        this.setOutputLocalFolder(repositoryDestination.getOutputLocalFolder());
        this.copyFTPInfo(repositoryDestination);
    }

    public void copyFrom(ReportJobRepositoryDestinationModel repositoryDestination, List unusedEntities, ProfileAttributeService profileAttributeService, RepoUser user, ExecutionContext context) {
        if (repositoryDestination.isFolderURIModified()) {
            this.setFolderURI(repositoryDestination.getFolderURI());
        }
        if (repositoryDestination.isSequentialFilenames()) {
            this.setSequentialFilenames(repositoryDestination.isSequentialFilenames());
        }
        if (repositoryDestination.isOverwriteFilesModified()) {
            this.setOverwriteFiles(repositoryDestination.isOverwriteFiles());
        }
        if (repositoryDestination.isOutputDescriptionsModified()) {
            this.setOutputDescription(repositoryDestination.getOutputDescription());
        }
        if (repositoryDestination.isTimestampPatternModified()) {
            this.setTimestampPattern(repositoryDestination.getTimestampPattern());
        }
        if (repositoryDestination.isSaveToRepositoryModified()) {
            this.setSaveToRepository(repositoryDestination.isSaveToRepository());
        }
        if (repositoryDestination.isDefaultReportOutputFolderURIModified() && repositoryDestination.getDefaultReportOutputFolderURI() != null) {
            this.setDefaultScheduledReportOutputFolderURI(repositoryDestination.getDefaultReportOutputFolderURI(), profileAttributeService, user, context);
        }
        if (repositoryDestination.isUsingDefaultReportOutputFolderURIModified()) {
            this.setUsingDefaultReportOutputFolderURI(repositoryDestination.isUsingDefaultReportOutputFolderURI());
        }
        if (repositoryDestination.isOutputLocalFolderModified()) {
            this.setOutputLocalFolder(repositoryDestination.getOutputLocalFolder());
        }
        if (repositoryDestination.isOutputFTPInfoModified()) {
            this.copyFTPInfo(repositoryDestination.getOutputFTPInfoModel());
        }
    }

    public ReportJobRepositoryDestination toClient(ProfileAttributeService profileAttributeService, RepoUser user, ExecutionContext context) {
        ReportJobRepositoryDestination repositoryDestination = new ReportJobRepositoryDestination();
        repositoryDestination.setId(this.getId());
        repositoryDestination.setVersion(this.getVersion());
        repositoryDestination.setFolderURI(this.getFolderURI());
        repositoryDestination.setSequentialFilenames(this.isSequentialFilenames());
        repositoryDestination.setOverwriteFiles(this.isOverwriteFiles());
        repositoryDestination.setOutputDescription(this.getOutputDescription());
        repositoryDestination.setTimestampPattern(this.getTimestampPattern());
        repositoryDestination.setSaveToRepository(this.isSaveToRepository());
        repositoryDestination.setDefaultReportOutputFolderURI(this.getDefaultScheduledReportOutputFolderURI(profileAttributeService, user, context));
        repositoryDestination.setUsingDefaultReportOutputFolderURI(this.isUsingDefaultReportOutputFolderURI());
        repositoryDestination.setOutputLocalFolder(this.getOutputLocalFolder());
        if (this.getOutputFTPInfo() != null) {
            repositoryDestination.setOutputFTPInfo(this.getOutputFTPInfo().toClient());
        }
        return repositoryDestination;
    }

    public String getDefaultScheduledReportOutputFolderURI(ProfileAttributeService profileAttributeService, RepoUser user, ExecutionContext context) {
        List attrList = profileAttributeService.getProfileAttributesForPrincipal(context, (Object)user);
        if (attrList == null) {
            return null;
        }
        Iterator it = attrList.iterator();
        while (!attrList.isEmpty() && it.hasNext()) {
            ProfileAttribute elem = (ProfileAttribute)it.next();
            if (!DEFAULT_REPORT_OUTPUT_FOLDER_URI.equals(elem.getAttrName())) continue;
            return elem.getAttrValue();
        }
        return null;
    }

    public void setDefaultScheduledReportOutputFolderURI(String folderURI, ProfileAttributeService profileAttributeService, RepoUser user, ExecutionContext context) {
        String originalValue = this.getDefaultScheduledReportOutputFolderURI(profileAttributeService, user, context);
        if (originalValue == null && folderURI == null) {
            return;
        }
        if (originalValue != null && originalValue.equalsIgnoreCase(folderURI)) {
            return;
        }
        ProfileAttribute attr = profileAttributeService.newProfileAttribute(context);
        attr.setPrincipal((Object)user);
        attr.setAttrName(DEFAULT_REPORT_OUTPUT_FOLDER_URI);
        attr.setAttrValue(folderURI);
        profileAttributeService.putProfileAttribute(context, attr);
    }

    protected void copyFTPInfo(ReportJobRepositoryDestination destination) {
        if (this.getOutputFTPInfo() == null) {
            this.setOutputFTPInfo(new PersistentFTPInfo());
            if (destination.getOutputFTPInfo() == null) {
                return;
            }
        }
        if (destination.getOutputFTPInfo() != null) {
            this.getOutputFTPInfo().copyFrom(destination.getOutputFTPInfo());
        } else {
            this.setOutputFTPInfo(new PersistentFTPInfo());
        }
    }

    protected void copyFTPInfo(FTPInfoModel jobFTPInfo) {
        if (this.getOutputFTPInfo() == null) {
            this.setOutputFTPInfo(new PersistentFTPInfo());
            if (jobFTPInfo == null) {
                return;
            }
        }
        if (jobFTPInfo != null) {
            this.getOutputFTPInfo().copyFrom(jobFTPInfo);
        } else {
            this.setOutputFTPInfo(new PersistentFTPInfo());
        }
    }

    public boolean isNew() {
        return this.getVersion() == -1;
    }

    public String getOutputDescription() {
        return this.outputDescription;
    }

    public void setOutputDescription(String outputDescription) {
        this.outputDescription = outputDescription;
    }

    public String getTimestampPattern() {
        return this.timestampPattern;
    }

    public void setTimestampPattern(String timestampPattern) {
        this.timestampPattern = timestampPattern;
    }
}

