/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util.repo;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceContainer;
import com.jaspersoft.jasperserver.api.metadata.common.service.JSResourceNotFoundException;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryConnection
extends URLConnection {
    private static final Log log = LogFactory.getLog(RepositoryConnection.class);
    private final RepositoryContext repositoryContext;

    public RepositoryConnection(RepositoryContext repository, URL url) {
        super(url);
        this.repositoryContext = repository;
    }

    @Override
    public void connect() throws IOException {
        this.connected = true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            FileResource resource;
            InputStream data = null;
            String path = this.url.getPath();
            if (!path.startsWith("/")) {
                ResourceContainer reportUnit = this.repositoryContext.getReportUnit();
                resource = null;
                if (reportUnit != null) {
                    resource = reportUnit.getResourceLocal(path);
                }
                if (resource == null || !resource.hasData()) {
                    path = this.repositoryContext.getContextURI() + "/" + path;
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Loading resource \"" + resource.getName() + "\" from in-memory report unit"));
                    }
                    data = resource.getDataStream();
                    if (resource.getFileType().equals("jrxml")) {
                        data = this.repositoryContext.getCompiledReportProvider().getCompiledReport(this.repositoryContext.getExecutionContext(), data);
                    }
                }
            }
            if (data == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loading resource \"" + path + "\" from repository"));
                }
                RepositoryService repository = this.repositoryContext.getRepository();
                resource = (FileResource)repository.getResource(this.repositoryContext.getExecutionContext(), path, FileResource.class);
                while (resource != null && resource.isReference()) {
                    resource = (FileResource)repository.getResource(this.repositoryContext.getExecutionContext(), resource.getReferenceURI(), FileResource.class);
                }
                if (resource == null) {
                    throw new IOException("Repository file resource " + path + " could not be loaded");
                }
                if (resource.getFileType().equals("jrxml")) {
                    data = this.repositoryContext.getCompiledReportProvider().getCompiledReport(this.repositoryContext.getExecutionContext(), path);
                } else {
                    FileResourceData resourceData = repository.getResourceData(this.repositoryContext.getExecutionContext(), path);
                    data = resourceData.getDataStream();
                }
            }
            return data;
        }
        catch (JSResourceNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }
}

