/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryResourceKey;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.repo.RepositoryURLHandlerFactory;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;

public class RepositoryResourceClassLoader
extends ClassLoader {
    private final Map resourceKeys;
    private final boolean localURLs;

    public RepositoryResourceClassLoader(ClassLoader parent, Map resourceKeys, boolean localURLs) {
        super(parent);
        this.resourceKeys = resourceKeys;
        this.localURLs = localURLs;
    }

    @Override
    protected URL findResource(String name) {
        return this.getRepositoryURL(name);
    }

    protected URL getRepositoryURL(String name) {
        URL url = null;
        RepositoryResourceKey resourceKey = (RepositoryResourceKey)this.resourceKeys.get(name);
        if (resourceKey != null) {
            url = this.localURLs ? RepositoryURLHandlerFactory.createRepoURL(name) : RepositoryURLHandlerFactory.createRepoURL(resourceKey.getUri());
        }
        return url;
    }

    protected Enumeration findResources(String name) {
        final URL url = this.getRepositoryURL(name);
        return new Enumeration(){
            private Object obj;
            {
                this.obj = url;
            }

            @Override
            public boolean hasMoreElements() {
                return this.obj != null;
            }

            public Object nextElement() {
                Object next = this.obj;
                this.obj = null;
                return next;
            }
        };
    }
}

