/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportExecutionListener;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportExecutionListenerFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequestBase;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.logging.context.LoggingContextProvider;
import java.util.Date;

public class ReportExecutionAuditListenerFactory
implements ReportExecutionListenerFactory {
    private LoggingContextProvider loggingContextProvider;
    private AuditContext auditContext;

    @Override
    public ReportExecutionListener createListener(ReportUnitRequestBase request) {
        if (!request.isCreateAuditEvent()) {
            return null;
        }
        return new ReportExecutionAuditListener(request.getStartTime());
    }

    public LoggingContextProvider getLoggingContextProvider() {
        return this.loggingContextProvider;
    }

    public void setLoggingContextProvider(LoggingContextProvider loggingContextProvider) {
        this.loggingContextProvider = loggingContextProvider;
    }

    public AuditContext getAuditContext() {
        return this.auditContext;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    protected class ReportExecutionAuditListener
    implements ReportExecutionListener {
        private final long startTime;
        private Thread originalThread;

        public ReportExecutionAuditListener(long startTime) {
            this.startTime = startTime;
        }

        @Override
        public void init() {
            this.originalThread = Thread.currentThread();
        }

        @Override
        public void start() {
            ReportExecutionAuditListenerFactory.this.getAuditContext().doInAuditContext(new AuditContext.AuditContextCallback(){

                public void execute() {
                    ReportExecutionAuditListenerFactory.this.getAuditContext().createAuditEvent("runReport");
                }
            });
        }

        @Override
        public void end(boolean success) {
            if (success) {
                ReportExecutionAuditListenerFactory.this.getAuditContext().doInAuditContext("runReport", new AuditContext.AuditContextCallbackWithEvent(){

                    public void execute(AuditEvent auditEvent) {
                        ReportExecutionAuditListenerFactory.this.getAuditContext().addPropertyToAuditEvent("reportExecutionStartTime", (Object)new Date(ReportExecutionAuditListener.this.startTime), auditEvent);
                        ReportExecutionAuditListenerFactory.this.getAuditContext().addPropertyToAuditEvent("reportExecutionTime", (Object)(System.currentTimeMillis() - ReportExecutionAuditListener.this.startTime), auditEvent);
                        ReportExecutionAuditListenerFactory.this.getAuditContext().closeAuditEvent(auditEvent);
                    }
                });
            }
            if (!Thread.currentThread().equals(this.originalThread)) {
                ReportExecutionAuditListenerFactory.this.loggingContextProvider.flushContext();
            }
        }
    }
}

