/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.ValidationDetail;
import com.jaspersoft.jasperserver.api.common.domain.ValidationResult;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationDetailImpl;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationResultImpl;
import com.jaspersoft.jasperserver.api.engine.common.domain.Request;
import com.jaspersoft.jasperserver.api.engine.common.domain.Result;
import com.jaspersoft.jasperserver.api.engine.common.service.BuiltInParameterProvider;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.common.service.IQueryManipulator;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportExecutionStatusInformation;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportExecutionStatusSearchCriteria;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlInformation;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlValuesInformation;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlsInformation;
import com.jaspersoft.jasperserver.api.engine.common.service.SchedulerReportExecutionStatusSearchCriteria;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.ReportExecuter;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.CompositeReportExecutionListener;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportExecutionListener;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportExecutionListenerFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequest;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequestBase;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.TrialReportUnitRequest;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataCacheProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.InputControlsInfoExtractor;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CacheableCompiledReports;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CompiledReportProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.DefaultRepositoryContextManager;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.InputControlsInfoRoutingExtractor;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.InternalReportCompiler;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JasperReportInputControlInformation;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.ReportInputControlWithoutParameterInformation;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.ReportInputControlsInformationImpl;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.RepositoryContextManager;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.DataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.DefaultProtectionDomainProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.InputControlLabelResolver;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JRQueryExecuterAdapter;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JarsClassLoader;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.MessageSourceLoader;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.ProtectionDomainProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.ReportInputControlValuesInformationLoader;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryCacheMap;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryResourceClassLoader;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryResourceKey;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryUtil;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.ResourceCollector;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.repo.RepositoryURLHandlerFactory;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportExecutionJob;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControlsContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.MemoryDataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryCache;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryCacheableItem;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryUnsecure;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataCacheSnapshot;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataSnapshotPersistentMetadata;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarFile;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import net.sf.jasperreports.data.cache.DataSnapshotException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.fill.AsynchronousFilllListener;
import net.sf.jasperreports.engine.fill.BaseFillHandle;
import net.sf.jasperreports.engine.fill.FillHandle;
import net.sf.jasperreports.engine.fill.FillListener;
import net.sf.jasperreports.engine.fill.JRParameterDefaultValuesEvaluator;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlTemplateLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.web.servlets.AsyncJasperPrintAccessor;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import net.sf.jasperreports.web.servlets.SimpleJasperPrintAccessor;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class EngineServiceImpl
implements EngineService,
ReportExecuter,
CompiledReportProvider,
InternalReportCompiler,
InitializingBean {
    protected static final Log log = LogFactory.getLog(EngineServiceImpl.class);
    protected static final Log valueQueryLog = LogFactory.getLog((String)"valueQueryLog");
    private DataSourceServiceFactory dataSourceServiceFactories;
    protected RepositoryUnsecure unsecureRepository;
    protected RepositoryService repository;
    private SecurityContextProvider securityContextProvider;
    private ProtectionDomainProvider reportJarsProtectionDomainProvider = new DefaultProtectionDomainProvider();
    private String reportParameterLabelKeyPrefix;
    private IQueryManipulator queryManipulator = null;
    private boolean autoUpdateJRXMLs;
    private RepositoryCacheMap tempJarFiles;
    private RepositoryCache compiledReportsCache;
    private final ReferenceMap jarsClassLoaderCache;
    private final ReferenceMap resourcesClassLoaderCache;
    private RepositoryCacheableItem cacheableCompiledReports;
    private RepositoryContextManager repositoryContextManager;
    private List builtInParameterProviders = new ArrayList();
    private AuditContext auditContext;
    protected InputControlsInfoExtractor inputControlsInfoExtractor = new InputControlsInfoRoutingExtractor();
    private final ThreadLocal<ReportExecutionStatus> currentExecutionStatus = new ThreadLocal();
    private final Map<String, ReportExecutionStatus> executions = Collections.synchronizedMap(new HashMap());
    private Executor syncReportExecutorService = SynchronousExecutor.INSTANCE;
    private Executor asyncReportExecutorService = Executors.newCachedThreadPool();
    private List<ReportExecutionListenerFactory> reportExecutionListenerFactories;
    private DataCacheProvider dataCacheProvider;

    public EngineServiceImpl() {
        this.jarsClassLoaderCache = new ReferenceMap(2, 1);
        this.resourcesClassLoaderCache = new ReferenceMap(2, 1);
        this.cacheableCompiledReports = new CacheableCompiledReports(this);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.repositoryContextManager == null) {
            this.repositoryContextManager = new DefaultRepositoryContextManager(this.repository, this);
        }
        this.createJarFilesCache();
    }

    public IQueryManipulator getQueryManipulator() {
        return this.queryManipulator;
    }

    public void setQueryManipulator(IQueryManipulator queryManipulator) {
        this.queryManipulator = queryManipulator;
    }

    public RepositoryService getRepositoryService() {
        return this.repository;
    }

    public void setRepositoryService(RepositoryService repository) {
        this.repository = repository;
    }

    public RepositoryCache getCompiledReportsCache() {
        return this.compiledReportsCache;
    }

    public void setCompiledReportsCache(RepositoryCache compiledReportsCache) {
        this.compiledReportsCache = compiledReportsCache;
    }

    public RepositoryCacheableItem getCacheableCompiledReports() {
        return this.cacheableCompiledReports;
    }

    public void setCacheableCompiledReports(RepositoryCacheableItem cacheableCompiledReports) {
        this.cacheableCompiledReports = cacheableCompiledReports;
    }

    public RepositoryContextManager getRepositoryContextManager() {
        return this.repositoryContextManager;
    }

    public void setRepositoryContextManager(RepositoryContextManager repositoryContextManager) {
        this.repositoryContextManager = repositoryContextManager;
    }

    public AuditContext getAuditContext() {
        return this.auditContext;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    public List getBuiltInParameterProviders() {
        return this.builtInParameterProviders;
    }

    public void setBuiltInParameterProviders(List builtInParameterProviders) {
        this.builtInParameterProviders = builtInParameterProviders;
    }

    public void setInputControlsInfoExtractor(InputControlsInfoExtractor inputControlsInfoExtractor) {
        this.inputControlsInfoExtractor = inputControlsInfoExtractor;
    }

    public ProtectionDomainProvider getReportJarsProtectionDomainProvider() {
        return this.reportJarsProtectionDomainProvider;
    }

    public void setReportJarsProtectionDomainProvider(ProtectionDomainProvider protectionDomainProvider) {
        this.reportJarsProtectionDomainProvider = protectionDomainProvider;
    }

    protected void createJarFilesCache() {
        this.tempJarFiles = new RepositoryCacheMap(this.repository, this.repositoryContextManager, new TempJarFileCacheObject());
    }

    protected InputStream getFileResourceDataStream(ExecutionContext context, FileResource fileResource) {
        InputStream data;
        if (fileResource.hasData()) {
            data = fileResource.getDataStream();
        } else {
            FileResourceData resourceData = this.repository.getResourceData(context, fileResource.getURIString());
            data = resourceData.getDataStream();
        }
        return data;
    }

    protected RepositoryCacheMap.CacheObject getCacheJarFile(ExecutionContext context, FileResource jar, boolean cache) {
        return this.tempJarFiles.cache(context, jar, cache);
    }

    protected byte[] getFileResourceData(ExecutionContext context, FileResource fileResource) {
        byte[] data;
        if (fileResource.hasData()) {
            data = fileResource.getData();
        } else {
            FileResourceData resourceData = this.repository.getResourceData(context, fileResource.getURIString());
            data = resourceData.getData();
        }
        return data;
    }

    public DataSourceServiceFactory getDataSourceServiceFactories() {
        return this.dataSourceServiceFactories;
    }

    public void setDataSourceServiceFactories(DataSourceServiceFactory dataSourceServiceFactories) {
        this.dataSourceServiceFactories = dataSourceServiceFactories;
    }

    public Result execute(ExecutionContext context, Request request) {
        ReportUnitRequestBase reportUnitRequest = (ReportUnitRequestBase)request;
        return reportUnitRequest.execute(context, this);
    }

    protected void startExecution(Request request) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Launching execution " + request.getId()));
        }
        ReportExecutionStatus status = null;
        status = request instanceof ReportUnitRequest ? new ReportExecutionStatus(request, ((ReportUnitRequest)request).getPropertyMap()) : new ReportExecutionStatus(request);
        this.executions.put(request.getId(), status);
        this.currentExecutionStatus.set(status);
    }

    protected void endExecution(Request request) {
        this.executions.remove(request.getId());
        this.currentExecutionStatus.set(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ended execution " + request.getId()));
        }
    }

    protected ReportExecutionStatus currentExecutionStatus() {
        return this.currentExecutionStatus.get();
    }

    protected String currentExecutionId() {
        ReportExecutionStatus status = this.currentExecutionStatus();
        return status == null ? "Not tracked" : status.getRequestId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToPdf(ExecutionContext context, String reportUnitURI, Map exportParameters) {
        ReportUnit reportUnit = this.getRepositoryResource(context, reportUnitURI, ReportUnit.class);
        this.setThreadRepositoryContext(context, null, reportUnitURI);
        try {
            OrigContextClassLoader origContext = this.setContextClassLoader(context, (ResourceContainer)reportUnit, false);
            try {
                exportParameters.put(JRExporterParameter.URL_HANDLER_FACTORY, RepositoryURLHandlerFactory.getInstance());
                JRPdfExporter exporter = new JRPdfExporter();
                exporter.setParameters(exportParameters);
                exporter.exportReport();
            }
            finally {
                this.revert(origContext);
            }
        }
        catch (JRException e) {
            log.error((Object)"Error while exporting report to PDF", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        finally {
            this.resetThreadRepositoryContext();
        }
    }

    protected void setThreadRepositoryContext(ExecutionContext context, ResourceContainer reportUnit, String reportUnitURI) {
        context = EngineServiceImpl.getRuntimeExecutionContext(context);
        this.repositoryContextManager.setRepositoryContext(context, reportUnitURI, reportUnit);
    }

    protected void resetThreadRepositoryContext() {
        this.repositoryContextManager.resetRepositoryContext();
    }

    protected ReportUnitResult fillReport(ExecutionContext context, ReportUnitRequestBase request, ReportUnit reportUnit, boolean inMemoryUnit) {
        Map params;
        JasperPrintAccessor reportAccessor;
        ReportExecutionListener executionListener = this.createReportExecutionListener(request);
        boolean asynchronous = request.isAsynchronous();
        ReportFiller filler = this.createReportFiller(asynchronous);
        Executor executor = this.getReportExecutor(asynchronous);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running report " + reportUnit.getURIString() + " on " + executor));
        }
        executionListener.init();
        ReportFill reportFill = new ReportFill(context, request, reportUnit, inMemoryUnit, filler, executionListener);
        executor.execute(reportFill);
        try {
            reportAccessor = filler.getResult();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JSException(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning fill result " + reportAccessor));
        }
        JRVirtualizer virtualizer = (params = request.getReportParameters()) == null ? null : (JRVirtualizer)params.get("REPORT_VIRTUALIZER");
        ReportUnitResult result = new ReportUnitResult(reportUnit.getURIString(), reportAccessor, virtualizer);
        result.setRequestId(request.getId());
        result.setDataTimestamp(filler.getDataTimestamp());
        result.setReportContext(request.getReportContext());
        return result;
    }

    protected ReportExecutionListener createReportExecutionListener(ReportUnitRequestBase request) {
        LinkedList<ReportExecutionListener> listeners = new LinkedList<ReportExecutionListener>();
        for (ReportExecutionListenerFactory listenerFactory : this.getReportExecutionListenerFactories()) {
            ReportExecutionListener listener = listenerFactory.createListener(request);
            if (listener == null) continue;
            listeners.add(listener);
        }
        return CompositeReportExecutionListener.asListener(listeners);
    }

    protected ReportFiller createReportFiller(boolean asynchronous) {
        ReportFiller filler = asynchronous ? new AsynchronousReportFiller() : new SynchronousReportFiller();
        return filler;
    }

    protected Executor getReportExecutor(boolean asynchronous) {
        Executor executor = asynchronous ? this.asyncReportExecutorService : this.syncReportExecutorService;
        return executor;
    }

    protected void checkRequestCanceled() {
        ReportExecutionStatus status = this.currentExecutionStatus();
        if (status != null && status.isCancelRequested()) {
            throw new JSException("Report execution request canceled");
        }
    }

    protected void setExecutionCancelable(ReportExecutionCancelable cancelable) {
        ReportExecutionStatus status = this.currentExecutionStatus();
        if (status == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Execution not tracked");
            }
        } else {
            status.setCancelable(cancelable);
        }
    }

    protected void clearExecutionCancelable() {
        this.setExecutionCancelable(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelExecution(String requestId) {
        ReportExecutionStatus status = this.executions.get(requestId);
        if (status == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No execution found for request " + requestId));
            }
            return false;
        }
        ReportExecutionStatus reportExecutionStatus = status;
        synchronized (reportExecutionStatus) {
            return status.cancel();
        }
    }

    protected Map getReportParameters(ExecutionContext context, JasperReport report, Map requestParameters) {
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        reportParameters.put("REPORT_URL_HANDLER_FACTORY", RepositoryURLHandlerFactory.getInstance());
        if (context != null && context.getLocale() != null && reportParameters.get("REPORT_LOCALE") == null) {
            reportParameters.put("REPORT_LOCALE", context.getLocale());
        }
        if (context != null && context.getTimeZone() != null) {
            reportParameters.put("REPORT_TIME_ZONE", context.getTimeZone());
        }
        if (requestParameters != null) {
            reportParameters.putAll(requestParameters);
        }
        this.setBuiltinParameters(context, true, report.getParameters(), reportParameters, null);
        return reportParameters;
    }

    protected void setReportTemplates(ExecutionContext context, Map unitResources, Map reportParameters) {
        if (!reportParameters.containsKey("REPORT_TEMPLATES")) {
            ArrayList<JRTemplate> templates = new ArrayList<JRTemplate>();
            for (FileResource resource : unitResources.values()) {
                if (!resource.getFileType().equals("jrtx")) continue;
                JRTemplate template = this.loadTemplate(context, resource);
                templates.add(template);
            }
            reportParameters.put("REPORT_TEMPLATES", templates);
        }
    }

    protected JRTemplate loadTemplate(ExecutionContext context, FileResource resource) {
        InputStream templateDataStream = this.getFileResourceDataStream(context, resource);
        try {
            return JRXmlTemplateLoader.load((InputStream)templateDataStream);
        }
        catch (JRRuntimeException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected void revert(OrigContextClassLoader origContext) {
        if (origContext.set) {
            Thread.currentThread().setContextClassLoader(origContext.origClassLoader);
            for (RepositoryCacheMap.CacheObject cacheJarFile : origContext.jars) {
                if (cacheJarFile.isCached()) continue;
                JarFile jarFile = (JarFile)cacheJarFile.getObject();
                this.dispose(jarFile);
            }
        }
    }

    protected OrigContextClassLoader setContextClassLoader(ExecutionContext context, ResourceContainer reportUnit, boolean inMemoryUnit) {
        return this.setContextClassLoader(context, reportUnit.getResources(), inMemoryUnit);
    }

    protected OrigContextClassLoader setContextClassLoader(ExecutionContext context, List<ResourceReference> resources, boolean inMemoryUnit) {
        Map unitResources = this.loadFinalResources(context, resources);
        return this.setContextClassLoader(context, unitResources, inMemoryUnit);
    }

    protected Map loadFinalResources(ExecutionContext context, List<ResourceReference> resources) {
        LinkedHashMap<ResourceReference, FileResource> finalResources = new LinkedHashMap<ResourceReference, FileResource>();
        if (resources != null) {
            for (ResourceReference resRef : resources) {
                FileResource resource = this.getFinalFileResource(context, resRef);
                finalResources.put(resRef, resource);
            }
        }
        return finalResources;
    }

    protected OrigContextClassLoader setContextClassLoader(ExecutionContext context, Map unitResources, boolean inMemoryUnit) {
        OrigContextClassLoader origContext;
        Map resourceBundleKeys;
        ClassLoader jarsClassLoader;
        Thread thread = Thread.currentThread();
        ClassLoader origClassLoader = thread.getContextClassLoader();
        ClassLoader newClassLoader = null;
        List jarFiles = this.getJarFiles(context, unitResources, !inMemoryUnit);
        if (jarFiles.isEmpty()) {
            jarsClassLoader = origClassLoader;
        } else {
            newClassLoader = jarsClassLoader = this.getJarsClassLoader(origClassLoader, jarFiles);
        }
        if (RepositoryUtil.hasThreadRepositoryContext() && !(resourceBundleKeys = this.getResourceBundleKeys(context, unitResources)).isEmpty()) {
            newClassLoader = this.getResourcesClassLoader(jarsClassLoader, resourceBundleKeys, inMemoryUnit);
        }
        if (newClassLoader == null) {
            origContext = OrigContextClassLoader.NOT_SET;
        } else {
            origContext = new OrigContextClassLoader(origClassLoader, jarFiles);
            thread.setContextClassLoader(newClassLoader);
        }
        return origContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassLoader getJarsClassLoader(ClassLoader origClassLoader, List jarFiles) {
        ClassLoader classLoader;
        boolean caching;
        RepositoryCacheMap.CacheObject cacheJarFile;
        Iterator it = jarFiles.iterator();
        for (caching = true; caching && it.hasNext(); caching &= cacheJarFile.isCached()) {
            cacheJarFile = (RepositoryCacheMap.CacheObject)it.next();
        }
        if (caching) {
            Map childrenClassLoaders;
            ReferenceMap referenceMap = this.jarsClassLoaderCache;
            synchronized (referenceMap) {
                childrenClassLoaders = (Map)this.jarsClassLoaderCache.get((Object)origClassLoader);
                if (childrenClassLoaders == null) {
                    childrenClassLoaders = new ReferenceMap(0, 1);
                    this.jarsClassLoaderCache.put((Object)origClassLoader, (Object)childrenClassLoaders);
                }
            }
            Object classLoaderKey = this.getJarFileNames(jarFiles);
            Map map = childrenClassLoaders;
            synchronized (map) {
                classLoader = (ClassLoader)childrenClassLoaders.get(classLoaderKey);
                if (classLoader == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creating class loader for parent " + origClassLoader + " and jars " + classLoaderKey));
                    }
                    classLoader = this.createJarsClassLoader(origClassLoader, jarFiles);
                    childrenClassLoaders.put(classLoaderKey, classLoader);
                }
            }
        }
        classLoader = this.createJarsClassLoader(origClassLoader, jarFiles);
        return classLoader;
    }

    protected ClassLoader createJarsClassLoader(ClassLoader origClassLoader, List jarFiles) {
        JarFile[] jars = new JarFile[jarFiles.size()];
        int i = 0;
        Iterator it = jarFiles.iterator();
        while (it.hasNext()) {
            jars[i] = (JarFile)((RepositoryCacheMap.CacheObject)it.next()).getObject();
            ++i;
        }
        return new JarsClassLoader(jars, origClassLoader, this.reportJarsProtectionDomainProvider.getProtectionDomain());
    }

    private Object getJarFileNames(List jarFiles) {
        ArrayList<String> jarFileNames = new ArrayList<String>(jarFiles.size());
        Iterator it = jarFiles.iterator();
        while (it.hasNext()) {
            JarFile jar = (JarFile)((RepositoryCacheMap.CacheObject)it.next()).getObject();
            jarFileNames.add(jar.getName());
        }
        return jarFileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassLoader getResourcesClassLoader(ClassLoader parent, Map resourceBundleKeys, boolean inMemoryUnit) {
        ClassLoader repositoryResourceClassLoader;
        if (inMemoryUnit) {
            repositoryResourceClassLoader = new RepositoryResourceClassLoader(parent, resourceBundleKeys, true);
        } else {
            Map childrenClassLoaders;
            Object object = this.resourcesClassLoaderCache;
            synchronized (object) {
                childrenClassLoaders = (Map)this.resourcesClassLoaderCache.get((Object)parent);
                if (childrenClassLoaders == null) {
                    childrenClassLoaders = new ReferenceMap(0, 1);
                    this.resourcesClassLoaderCache.put((Object)parent, (Object)childrenClassLoaders);
                }
            }
            object = childrenClassLoaders;
            synchronized (object) {
                repositoryResourceClassLoader = (ClassLoader)childrenClassLoaders.get(resourceBundleKeys);
                if (repositoryResourceClassLoader == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creating class loader for parent " + parent + " and resources " + resourceBundleKeys));
                    }
                    repositoryResourceClassLoader = new RepositoryResourceClassLoader(parent, resourceBundleKeys, false);
                    childrenClassLoaders.put(resourceBundleKeys, repositoryResourceClassLoader);
                }
            }
        }
        return repositoryResourceClassLoader;
    }

    protected List getJarFiles(ExecutionContext context, Map unitResources, boolean cache) {
        ArrayList<RepositoryCacheMap.CacheObject> jarFiles = new ArrayList<RepositoryCacheMap.CacheObject>();
        for (FileResource resource : unitResources.values()) {
            if (!resource.getFileType().equals("jar")) continue;
            RepositoryCacheMap.CacheObject cacheJarFile = this.getCacheJarFile(context, resource, cache);
            jarFiles.add(cacheJarFile);
        }
        return jarFiles;
    }

    protected Map getResourceBundleKeys(ExecutionContext context, Map unitResources) {
        HashMap<String, RepositoryResourceKey> resourceBundleKeys = new HashMap<String, RepositoryResourceKey>();
        for (Map.Entry entry : unitResources.entrySet()) {
            ResourceReference resRef = (ResourceReference)entry.getKey();
            FileResource finalResource = (FileResource)entry.getValue();
            if (!finalResource.getFileType().equals("prop")) continue;
            String resName = resRef.isLocal() ? resRef.getLocalResource().getName() : finalResource.getName();
            String resPathKey = this.repositoryContextManager.getRepositoryPathKey(finalResource.getURIString());
            String uri = this.repositoryContextManager.getRepositoryUriForKey(resPathKey);
            RepositoryResourceKey resourceKey = new RepositoryResourceKey(resPathKey, uri, finalResource.getVersion(), finalResource.getCreationDate());
            resourceBundleKeys.put(resName, resourceKey);
        }
        return resourceBundleKeys;
    }

    protected JasperReport getJasperReport(ExecutionContext context, ReportUnitRequestBase request, ReportUnit reportUnit, boolean inMemoryUnit) {
        JasperDesignCache cache = JasperDesignCache.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance(), (ReportContext)request.getReportContext());
        return this.getJasperReport(context, cache, reportUnit, inMemoryUnit);
    }

    protected JasperReport getJasperReport(ExecutionContext context, JasperDesignCache cache, ReportUnit reportUnit, boolean inMemoryUnit) {
        FileResource reportRes = this.getFinalResource(context, reportUnit.getMainReport(), FileResource.class);
        String location = reportUnit.getPath();
        return this.getJasperReport(context, cache, reportRes, location, inMemoryUnit);
    }

    protected JasperReport getJasperReport(ExecutionContext context, JasperDesignCache cache, FileResource reportRes, String location, boolean inMemoryUnit) {
        JasperReport report = null;
        try {
            if (inMemoryUnit) {
                InputStream fileResourceData = this.getFileResourceDataStream(context, reportRes);
                report = this.compileReport(fileResourceData);
            } else {
                if (cache != null) {
                    report = cache.getJasperReport(location);
                }
                if (report == null) {
                    InputStream compiledReport = this.getCompiledReport(context, reportRes);
                    try {
                        report = (JasperReport)JRLoader.loadObject((InputStream)compiledReport);
                        if (cache != null) {
                            cache.set(location, report);
                        }
                    }
                    catch (JRException e) {
                        Throwable cause = e.getCause();
                        if (cause == null || !(cause instanceof InvalidClassException)) {
                            throw e;
                        }
                        if (log.isInfoEnabled()) {
                            log.info((Object)"InvalidClassException caught while loading compiled report, clearing the compiled report cache");
                        }
                        this.clearCompiledReportCache();
                        compiledReport = this.getCompiledReport(context, reportRes);
                        report = (JasperReport)JRLoader.loadObject((InputStream)compiledReport);
                    }
                }
            }
            return report;
        }
        catch (JRException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected JasperReport getJasperReport(ExecutionContext context, ReportUnit reportUnit, boolean inMemoryUnit) {
        FileResource reportRes = this.getFinalResource(context, reportUnit.getMainReport(), FileResource.class);
        try {
            JasperReport report;
            if (inMemoryUnit) {
                InputStream fileResourceData = this.getFileResourceDataStream(context, reportRes);
                report = this.compileReport(fileResourceData);
            } else {
                InputStream compiledReport = this.getCompiledReport(context, reportRes);
                try {
                    report = (JasperReport)JRLoader.loadObject((InputStream)compiledReport);
                }
                catch (JRException e) {
                    Throwable cause = e.getCause();
                    if (cause == null || !(cause instanceof InvalidClassException)) {
                        throw e;
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)"InvalidClassException caught while loading compiled report, clearing the compiled report cache");
                    }
                    this.clearCompiledReportCache();
                    compiledReport = this.getCompiledReport(context, reportRes);
                    report = (JasperReport)JRLoader.loadObject((InputStream)compiledReport);
                }
            }
            return report;
        }
        catch (JRException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected void clearCompiledReportCache() {
        this.compiledReportsCache.clearCache(this.cacheableCompiledReports);
    }

    protected void addReportUnitToAuditEvent(final ReportUnit reportUnit) {
        this.getAuditContext().doInAuditContext("runReport", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                auditEvent.setResourceUri(reportUnit.getURI());
                EngineServiceImpl.this.auditContext.setResourceTypeToAuditEvent(reportUnit.getResourceType(), auditEvent);
                String uri = reportUnit.getDataSource() != null ? reportUnit.getDataSource().getReferenceURI() : "";
                EngineServiceImpl.this.getAuditContext().addPropertyToAuditEvent("dataSource", (Object)uri, auditEvent);
            }
        });
    }

    protected void addPropertyToAuditEvent(final String propertyType, final Object param) {
        this.getAuditContext().doInAuditContext("runReport", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                EngineServiceImpl.this.getAuditContext().addPropertyToAuditEvent(propertyType, param, auditEvent);
            }
        });
    }

    protected void fillReport(ExecutionContext context, ReportUnit reportUnit, JasperReport report, Map reportParameters, ReportDataSource datasource, Query query, ReportFiller filler) {
        ReportDataSourceService dataSourceService = null;
        boolean dsClosing = false;
        this.addReportUnitToAuditEvent(reportUnit);
        try {
            if (datasource != null) {
                dataSourceService = this.createDataSourceService(datasource);
                dataSourceService.setReportParameterValues(reportParameters);
                this.setThreadRepositoryContext(context, (ResourceContainer)reportUnit, reportUnit.getURIString());
            }
            long renderingStartTime = System.currentTimeMillis();
            this.addPropertyToAuditEvent("reportRenderingStartTime", new Date(renderingStartTime));
            if (query == null) {
                filler.fillReport(report, reportParameters, null);
            } else {
                this.fillQueryReport(context, report, reportParameters, query, filler);
            }
            this.addPropertyToAuditEvent("reportRenderingTime", System.currentTimeMillis() - renderingStartTime);
            dsClosing = true;
            if (dataSourceService != null) {
                dataSourceService.closeConnection();
                dataSourceService = null;
            }
        }
        catch (JRException e) {
            log.error((Object)"Error while filling report", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        finally {
            if (!dsClosing && dataSourceService != null) {
                try {
                    dataSourceService.closeConnection();
                }
                catch (Exception e) {
                    log.error((Object)"Error while closing data source connection", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JRDataSource createQueryDataSource(JRQueryExecuter queryExecuter) throws JRException {
        this.checkRequestCanceled();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing query for request " + this.currentExecutionId()));
        }
        QueryExecuterCancelable cancelable = new QueryExecuterCancelable(queryExecuter);
        this.setExecutionCancelable(cancelable);
        try {
            JRDataSource jRDataSource = queryExecuter.createDatasource();
            return jRDataSource;
        }
        finally {
            this.clearExecutionCancelable();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ended query for request " + this.currentExecutionId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JasperPrint fillReport(JasperReport report, Map parameters, JRDataSource dataSource) throws JRException {
        FillResultListener fillResult = new FillResultListener();
        this.checkRequestCanceled();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Filling report for request " + this.currentExecutionId()));
        }
        SynchronousFillHandle fillHandle = new SynchronousFillHandle(report, parameters, dataSource);
        fillHandle.addListener(fillResult);
        FillHandleCancelable cancelable = new FillHandleCancelable((FillHandle)fillHandle);
        this.setExecutionCancelable(cancelable);
        try {
            fillHandle.startFill();
        }
        finally {
            this.clearExecutionCancelable();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ended fill for request " + this.currentExecutionId()));
        }
        return fillResult.getJasperPrint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillQueryReport(ExecutionContext context, JasperReport report, Map reportParameters, Query query, ReportFiller filler) throws JRException {
        JRQueryExecuter queryExecuter = JRQueryExecuterAdapter.createQueryExecuter(report, reportParameters, query);
        boolean closing = false;
        try {
            JRDataSource reportDatasource = this.createQueryDataSource(queryExecuter);
            filler.fillReport(report, reportParameters, reportDatasource);
            closing = true;
            queryExecuter.close();
        }
        finally {
            if (!closing) {
                queryExecuter.close();
            }
        }
    }

    public ReportDataSourceService createDataSourceService(ReportDataSource dataSource) {
        ReportDataSourceServiceFactory factory = (ReportDataSourceServiceFactory)this.getDataSourceServiceFactories().getBean(dataSource.getClass());
        return factory.createService(dataSource);
    }

    public Resource[] getResources(ResourceReference jrxmlReference) {
        FileResource jrxml = this.getFinalResource(null, jrxmlReference, FileResource.class);
        return ResourceCollector.getResources(this.getFileResourceDataStream(null, jrxml));
    }

    protected <T extends Resource> T getRepositoryResource(ExecutionContext context, String uri, Class<T> type) {
        return (T)this.getRepositoryService().getResource(context, uri, type);
    }

    public ExecutionContext getRuntimeExecutionContext() {
        return EngineServiceImpl.getRuntimeExecutionContext(null);
    }

    public static ExecutionContext getRuntimeExecutionContext(ExecutionContext originalContext) {
        return ExecutionContextImpl.getRuntimeExecutionContext((ExecutionContext)originalContext);
    }

    public <T extends Resource> T getFinalResource(ExecutionContext context, ResourceReference res, Class<T> type) {
        if (res == null) {
            return null;
        }
        Object finalRes = res.isLocal() ? res.getLocalResource() : this.getRepositoryResource(context, res.getReferenceURI(), type);
        return (T)finalRes;
    }

    protected FileResource getFinalFileResource(ExecutionContext context, ResourceReference resRef) {
        ExecutionContext runtimeContext = EngineServiceImpl.getRuntimeExecutionContext(context);
        FileResource res = this.getFinalResource(runtimeContext, resRef, FileResource.class);
        while (res.isReference()) {
            res = this.getRepositoryResource(runtimeContext, res.getReferenceURI(), FileResource.class);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationResult validate(ExecutionContext context, ReportUnit reportUnit) {
        OrigContextClassLoader origContext = this.setContextClassLoader(context, (ResourceContainer)reportUnit, true);
        ValidationResultImpl result = new ValidationResultImpl();
        try {
            List resources;
            ResourceReference mainReport = reportUnit.getMainReport();
            if (mainReport != null) {
                this.validateJRXML(context, result, mainReport);
            }
            if ((resources = reportUnit.getResources()) != null && !resources.isEmpty()) {
                for (ResourceReference resource : resources) {
                    this.validateJRXML(context, result, resource);
                }
            }
        }
        finally {
            this.revert(origContext);
        }
        return result;
    }

    protected void validateJRXML(ExecutionContext context, ValidationResultImpl result, ResourceReference resourceRef) {
        FileResource resource = this.getFinalFileResource(context, resourceRef);
        if (resource.getFileType().equals("jrxml")) {
            try {
                JasperCompileManager.compileReport((InputStream)this.getFileResourceDataStream(context, resource));
            }
            catch (JRException e) {
                ValidationDetailImpl detail = new ValidationDetailImpl();
                detail.setValidationClass(FileResource.class);
                detail.setName(resource.getName());
                detail.setLabel(resource.getLabel());
                detail.setResult("ERROR");
                detail.setException((Exception)((Object)e));
                detail.setMessage(e.getMessage());
                result.addValidationDetail((ValidationDetail)detail);
            }
        }
    }

    @Override
    public ReportUnitResult executeReportUnitRequest(ExecutionContext context, ReportUnitRequest request) {
        ReportUnit reportUnit = this.getRepositoryResource(context, request.getReportUnitUri(), ReportUnit.class);
        return this.fillReport(context, request, reportUnit, false);
    }

    @Override
    public ReportUnitResult executeTrialReportUnitRequest(ExecutionContext context, TrialReportUnitRequest request) {
        return this.fillReport(context, request, request.getReportUnit(), true);
    }

    @Override
    public InputStream getCompiledReport(ExecutionContext context, InputStream jrxmlData) {
        JasperReport report = this.compileReport(jrxmlData);
        byte[] reportBytes = this.reportBytes(report);
        return new ByteArrayInputStream(reportBytes);
    }

    protected JasperReport compileReport(InputStream jrxmlData) {
        JasperDesign design = this.loadReportDesign(jrxmlData);
        JasperReport report = this.compileReport(design);
        return report;
    }

    protected JasperDesign loadReportDesign(InputStream jrxmlData) {
        JasperDesign design;
        try {
            design = JRXmlLoader.load((InputStream)jrxmlData);
        }
        catch (JRException e) {
            log.error((Object)"error loading JRXML", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        return design;
    }

    protected JasperReport compileReport(JasperDesign design) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("compiling report " + design.getName()));
        }
        try {
            JasperReport report = JasperCompileManager.compileReport((JasperDesign)design);
            return report;
        }
        catch (JRException e) {
            log.error((Object)"error compiling report", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected InputStream getCompiledReport(ExecutionContext context, FileResource jrxml) {
        return this.compiledReportsCache.cache(context, jrxml, this.cacheableCompiledReports);
    }

    protected byte[] reportBytes(JasperReport report) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JRSaver.saveObject((Object)report, (OutputStream)bout);
            byte[] reportBytes = bout.toByteArray();
            return reportBytes;
        }
        catch (JRException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    @Override
    public InputStream getCompiledReport(ExecutionContext context, String jrxmlURI) {
        return this.compiledReportsCache.cache(context, jrxmlURI, this.cacheableCompiledReports);
    }

    private void addReportUnitTypeToAudit(final Resource reportUnit) {
        this.auditContext.doInAuditContext("runReport", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                if (reportUnit != null) {
                    if (auditEvent.getResourceType() == null) {
                        EngineServiceImpl.this.auditContext.setResourceTypeToAuditEvent(reportUnit.getResourceType(), auditEvent);
                    }
                    if (auditEvent.getResourceUri() == null) {
                        auditEvent.setResourceUri(reportUnit.getURI());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JasperReport getMainJasperReport(ExecutionContext context, String reportUnitURI) {
        JasperReport jasperReport = null;
        ReportUnit reportUnit = this.getRepositoryResource(context, reportUnitURI, ReportUnit.class);
        if (reportUnit != null) {
            this.addReportUnitTypeToAudit((Resource)reportUnit);
            OrigContextClassLoader origContext = this.setContextClassLoader(context, (ResourceContainer)reportUnit, false);
            try {
                jasperReport = this.getJasperReport(context, reportUnit, false);
            }
            finally {
                this.revert(origContext);
            }
        }
        return jasperReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JasperReport getMainJasperReport(ExecutionContext context, InputControlsContainer container) {
        JasperReport jasperReport = null;
        if (container != null) {
            if (container instanceof ReportUnit) {
                this.addReportUnitTypeToAudit((Resource)container);
                OrigContextClassLoader origContext = this.setContextClassLoader(context, (ResourceContainer)((ReportUnit)container), false);
                try {
                    jasperReport = this.getJasperReport(context, (ReportUnit)container, false);
                }
                finally {
                    this.revert(origContext);
                }
            } else {
                throw new JSException("Unsupported report object " + container.getClass().getName());
            }
        }
        return jasperReport;
    }

    public void release() {
        this.tempJarFiles.release();
    }

    protected void dispose(JarFile jarFile) {
        try {
            jarFile.close();
        }
        catch (IOException e) {
            log.warn((Object)("Unable to close jar file \"" + jarFile.getName() + "\""), (Throwable)e);
        }
        File file = new File(jarFile.getName());
        if (file.exists() && !file.delete()) {
            log.warn((Object)("Unable to delete jar file \"" + jarFile.getName() + "\""));
        }
    }

    public void clearCaches(Class resourceItf, String resourceURI) {
        if (FileResource.class.isAssignableFrom(resourceItf)) {
            this.compiledReportsCache.clearCache(resourceURI, this.cacheableCompiledReports);
            this.tempJarFiles.remove(resourceURI);
        }
    }

    public SecurityContextProvider getSecurityContextProvider() {
        return this.securityContextProvider;
    }

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    public OrderedMap executeQuery(ExecutionContext context, ResourceReference queryReference, String keyColumn, String[] resultColumns, ResourceReference defaultDataSourceReference) {
        return this.executeQuery(context, queryReference, keyColumn, resultColumns, defaultDataSourceReference, null);
    }

    protected void addReportUnitToAuditEvent(final String dataSourceUri) {
        this.getAuditContext().doInAuditContext("inputControlsQuery", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                EngineServiceImpl.this.getAuditContext().addPropertyToAuditEvent("dataSource", (Object)dataSourceUri, auditEvent);
            }
        });
    }

    protected ReportDataSource getQueryDataSource(ExecutionContext context, ResourceReference dataSourceReference, ResourceReference defaultDataSourceReference) {
        if (dataSourceReference == null) {
            dataSourceReference = defaultDataSourceReference;
        }
        this.addReportUnitToAuditEvent(dataSourceReference != null ? dataSourceReference.getTargetURI() : null);
        return (ReportDataSource)this.getFinalResource(context, dataSourceReference, Resource.class);
    }

    public OrderedMap executeQuery(ExecutionContext context, ResourceReference queryReference, String keyColumn, String[] resultColumns, ResourceReference defaultDataSourceReference, Map parameterValues) {
        return this.executeQuery(context, queryReference, keyColumn, resultColumns, defaultDataSourceReference, parameterValues, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedMap executeQuery(ExecutionContext context, ResourceReference queryReference, String keyColumn, String[] resultColumns, ResourceReference defaultDataSourceReference, Map parameterValues, Map<String, Class<?>> parameterTypes, boolean formatValueColumns) {
        context = EngineServiceImpl.getRuntimeExecutionContext(context);
        Query query = this.getFinalResource(context, queryReference, Query.class);
        ReportDataSource dataSource = this.getQueryDataSource(context, query.getDataSource(), defaultDataSourceReference);
        ReportDataSourceService dataSourceService = this.createDataSourceService(dataSource);
        boolean dsClosing = false;
        try {
            HashMap parameters = new HashMap();
            if (parameterValues != null) {
                parameters.putAll(parameterValues);
            }
            ArrayList additionalParameters = new ArrayList();
            this.setBuiltinParameters(context, false, null, parameters, additionalParameters);
            dataSourceService.setReportParameterValues(parameters);
            if (this.queryManipulator != null) {
                query.setSql(this.queryManipulator.updateQuery(query.getSql(), parameters));
            }
            long start = System.currentTimeMillis();
            OrderedMap result = JRQueryExecuterAdapter.executeQuery(query, keyColumn, resultColumns, parameters, parameterTypes, additionalParameters, formatValueColumns);
            if (valueQueryLog.isDebugEnabled()) {
                valueQueryLog.debug((Object)("query took " + (System.currentTimeMillis() - start) + " ms: " + query.getSql()));
                valueQueryLog.debug((Object)("params: " + parameters));
            }
            dsClosing = true;
            if (dataSourceService != null) {
                dataSourceService.closeConnection();
                dataSourceService = null;
            }
            OrderedMap orderedMap = result;
            return orderedMap;
        }
        finally {
            if (!dsClosing && dataSourceService != null) {
                try {
                    dataSourceService.closeConnection();
                }
                catch (Exception e) {
                    log.error((Object)"Error while closing data source connection", (Throwable)e);
                }
            }
        }
    }

    public void setBuiltinParameters(ExecutionContext context, boolean onlyExistingParameters, JRParameter[] existingJRParameters, Map parametersMap, List additionalParameters) {
        for (Object o : this.getBuiltInParameterProviders()) {
            BuiltInParameterProvider pProvider = (BuiltInParameterProvider)o;
            List results = pProvider.getParameters(context, additionalParameters, parametersMap);
            for (Object[] aResult : results) {
                this.setBuiltInParameter(context, onlyExistingParameters, existingJRParameters, parametersMap, additionalParameters, aResult);
            }
            if (!onlyExistingParameters) continue;
            for (JRParameter jrParameter : existingJRParameters) {
                Object[] aResult;
                Object parameterMapValue = parametersMap.get(jrParameter.getName());
                if (parameterMapValue != null || (aResult = pProvider.getParameter(context, additionalParameters, parametersMap, jrParameter.getName())) == null) continue;
                this.setBuiltInParameter(context, onlyExistingParameters, existingJRParameters, parametersMap, additionalParameters, aResult);
            }
        }
    }

    public void setBuiltInParameter(ExecutionContext context, boolean onlyExistingParameters, JRParameter[] existingJRParameters, Map parametersMap, List additionalParameters, Object[] aResult) {
        JRParameter jrParameter = (JRParameter)aResult[0];
        Object aValue = aResult[1];
        boolean set = false;
        Object parameterFromMap = parametersMap.get(jrParameter.getName());
        JRParameter existingJRParameter = null;
        if (onlyExistingParameters) {
            for (JRParameter existingJRParameterFromArray : existingJRParameters) {
                if (!existingJRParameterFromArray.getName().equals(jrParameter.getName())) continue;
                existingJRParameter = existingJRParameterFromArray;
                break;
            }
        }
        if (onlyExistingParameters) {
            if (existingJRParameter != null) {
                if (existingJRParameter.getDefaultValueExpression() != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Report parameter " + jrParameter.getName() + " has a default value expression, not setting value"));
                    }
                } else if (!existingJRParameter.getValueClass().isAssignableFrom(jrParameter.getValueClass())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Report parameter " + jrParameter.getName() + " type " + jrParameter.getValueClassName() + " not compatible with java.lang.String, not setting value"));
                    }
                } else {
                    set = true;
                }
            }
        } else if (parameterFromMap == null) {
            set = true;
        }
        if (set) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting report parameter " + jrParameter.getName() + " to " + aValue));
            }
            if (!onlyExistingParameters) {
                additionalParameters.add(jrParameter);
            }
            parametersMap.put(jrParameter.getName(), aValue);
        }
    }

    public ResourceLookup[] getDataSources(ExecutionContext context, String queryLanguage) {
        ResourceLookup[] datasources;
        if (queryLanguage == null) {
            datasources = this.repository.findResource(context, FilterCriteria.createFilter(ReportDataSource.class));
        } else {
            Set dataSourceTypes = this.dataSourceServiceFactories.getSupportingDataSourceTypes(queryLanguage);
            if (dataSourceTypes == null || dataSourceTypes.isEmpty()) {
                datasources = null;
            } else {
                FilterCriteria[] criteria = new FilterCriteria[dataSourceTypes.size()];
                int i = 0;
                for (Class type : dataSourceTypes) {
                    criteria[i] = FilterCriteria.createFilter((Class)type);
                    ++i;
                }
                datasources = this.repository.findResources(context, criteria);
            }
        }
        return datasources;
    }

    public String getQueryLanguage(ExecutionContext context, ResourceReference jrxmlResource) {
        JasperDesign jasperDesign = this.loadJRXML(context, jrxmlResource);
        JRQuery query = jasperDesign.getQuery();
        return query == null ? null : query.getLanguage();
    }

    protected JasperDesign loadJRXML(ExecutionContext context, ResourceReference jrxmlResource) {
        JasperDesign jasperDesign;
        FileResource jrxmlRes = this.getFinalFileResource(context, jrxmlResource);
        InputStream jrxmlData = this.getFileResourceDataStream(context, jrxmlRes);
        boolean close = true;
        try {
            jasperDesign = JRXmlLoader.load((InputStream)jrxmlData);
            close = false;
            jrxmlData.close();
        }
        catch (JRException e) {
            log.error((Object)"Error parsing JRXML", (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        finally {
            if (close) {
                try {
                    jrxmlData.close();
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        return jasperDesign;
    }

    public Set getDataSourceTypes(ExecutionContext context, String queryLanguage) {
        return this.dataSourceServiceFactories.getSupportingDataSourceTypes(queryLanguage);
    }

    @Deprecated
    public Map getReportInputControlDefaultValues(ExecutionContext context, String reportURI, Map initialParameters) {
        ReportUnit reportUnit = this.getRepositoryResource(context, reportURI, ReportUnit.class);
        ReportInputControlsInformation infos = this.getReportInputControlsInformation(context, (InputControlsContainer)reportUnit, initialParameters);
        return infos.getDefaultValuesMap();
    }

    public ReportInputControlsInformation getReportInputControlsInformation(ExecutionContext context, String reportURI, Map initialParameters) {
        ReportUnit reportUnit = this.getRepositoryResource(context, reportURI, ReportUnit.class);
        return this.getReportInputControlsInformation(context, (InputControlsContainer)reportUnit, initialParameters);
    }

    protected void setSnapshotParameterValues(ExecutionContext context, ReportUnit reportUnit, ReportInputControlsInformation infos) {
        Set controlNames = infos.getControlNames();
        if (controlNames.isEmpty()) {
            return;
        }
        DataSnapshotPersistentMetadata snapshot = this.dataCacheProvider.loadSavedDataSnapshot(context, reportUnit);
        if (snapshot == null) {
            return;
        }
        Map snapshotParams = snapshot.getSnapshotMetadata().getParameters();
        if (snapshotParams == null || snapshotParams.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("setting default param values for " + reportUnit.getURIString() + " from data snapshot " + reportUnit.getDataSnapshotId()));
        }
        for (String controlName : controlNames) {
            Object value;
            ReportInputControlInformation info = infos.getInputControlInformation(controlName);
            if (!snapshotParams.containsKey(controlName) || !this.matchesInputControlType(info, value = snapshotParams.get(controlName))) continue;
            info.setDefaultValue(value);
        }
    }

    protected boolean matchesInputControlType(ReportInputControlInformation info, Object value) {
        if (value == null) {
            return true;
        }
        Class controlType = info.getValueType();
        if (controlType == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Could not determine type of snapshot parameter %s", info.getParameterName()));
            }
            return false;
        }
        if (!controlType.isInstance(value)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("snapshot parameter " + info.getParameterName() + " of type " + value.getClass().getName() + " does not match expected type " + controlType.getName()));
            }
            return false;
        }
        if (Collection.class.isAssignableFrom(controlType)) {
            Object firstValue;
            Collection collectionValues = (Collection)value;
            Class nestedType = info.getNestedType();
            if (nestedType != null && !collectionValues.isEmpty() && !nestedType.isInstance(firstValue = collectionValues.iterator().next())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("snapshot collection parameter " + info.getParameterName() + " with item type " + firstValue.getClass().getName() + " does not match expected type " + nestedType.getName()));
                }
                return false;
            }
        }
        return true;
    }

    /*
     * Loose catch block
     */
    public ReportInputControlsInformation getReportInputControlsInformation(ExecutionContext context, InputControlsContainer icContainer, Map initialParameters) {
        this.setThreadRepositoryContext(context, (ResourceContainer)icContainer, icContainer.getURIString());
        try {
            OrigContextClassLoader origContext = this.setContextClassLoader(context, (ResourceContainer)icContainer, false);
            try {
                List inputControls = icContainer.getInputControls();
                if (!(icContainer instanceof ReportUnit)) {
                    throw new JRException("Unsupported report object " + icContainer.getClass().getName());
                }
                JasperReport report = this.getJasperReport(context, (ReportUnit)icContainer, false);
                MessageSource messages = MessageSourceLoader.loadMessageSource(context, (ResourceContainer)icContainer, this.repository);
                ReportInputControlsInformation infos = this.getReportInputControlsInformation(context, report, inputControls, initialParameters, messages);
                if (icContainer instanceof ReportUnit) {
                    this.setSnapshotParameterValues(context, (ReportUnit)icContainer, infos);
                }
                ReportInputControlsInformation reportInputControlsInformation = infos;
                return reportInputControlsInformation;
            }
            catch (JRException e) {
                throw new JSExceptionWrapper((Exception)((Object)e));
            }
            finally {
                this.revert(origContext);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.resetThreadRepositoryContext();
        }
    }

    protected ReportInputControlsInformation getReportInputControlsInformation(ExecutionContext context, JasperReport report, List<ResourceReference> inputControls, Map initialParameters, MessageSource serverMessageSource) throws JRException {
        ReportInputControlsInformationImpl result = new ReportInputControlsInformationImpl();
        if (inputControls == null) {
            return result;
        }
        initialParameters = this.getReportParameters(context, report, initialParameters);
        HashMap<String, JRParameter> jrParametersMap = new HashMap<String, JRParameter>();
        JRParameter[] params = report.getParameters();
        for (int i = 0; i < params.length; ++i) {
            jrParametersMap.put(params[i].getName(), params[i]);
        }
        ResourceBundle reportBundle = this.loadResourceBundle(report);
        Map jrDefaultValues = JRParameterDefaultValuesEvaluator.evaluateParameterDefaultValues((JasperReport)report, (Map)initialParameters);
        for (ResourceReference inputControlRef : inputControls) {
            ReportInputControlInformation info;
            InputControl inputControl = this.getFinalResource(EngineServiceImpl.getRuntimeExecutionContext(context), inputControlRef, InputControl.class);
            String name = inputControl.getName();
            JRParameter param = (JRParameter)jrParametersMap.get(name);
            String label = InputControlLabelResolver.resolve(inputControl.getLabel(), reportBundle, serverMessageSource);
            ReportInputControlValuesInformation valuesInformation = null;
            ResourceReference listOfValuesResourceReference = inputControl.getListOfValues();
            if (listOfValuesResourceReference != null && (serverMessageSource != null || reportBundle != null)) {
                valuesInformation = this.getReportInputControlValuesInformation(context, reportBundle, serverMessageSource, listOfValuesResourceReference);
            }
            if (param != null) {
                JasperReportInputControlInformation jrInfo = new JasperReportInputControlInformation();
                jrInfo.setReportParameter(param);
                jrInfo.setDefaultValue(jrDefaultValues.get(name));
                jrInfo.setPromptLabel(label);
                jrInfo.setReportInputControlValuesInformation(valuesInformation);
                info = jrInfo;
            } else {
                info = this.createReportInputControlInformationWithoutParameter(inputControl.getName(), label, valuesInformation);
            }
            result.setInputControlInformation(name, info);
        }
        return result;
    }

    private ReportInputControlInformation createReportInputControlInformationWithoutParameter(String name, String label, ReportInputControlValuesInformation valuesInformation) {
        return new ReportInputControlWithoutParameterInformation(name, label, valuesInformation);
    }

    private ReportInputControlValuesInformation getReportInputControlValuesInformation(ExecutionContext context, ResourceBundle resourceBundle, MessageSource messageSource, ResourceReference listOfValuesResourceReference) {
        ListOfValues listOfValuesResource = null;
        listOfValuesResource = listOfValuesResourceReference.isLocal() ? (ListOfValues)listOfValuesResourceReference.getLocalResource() : (ListOfValues)this.repository.getResource(context, listOfValuesResourceReference.getReferenceURI());
        return ReportInputControlValuesInformationLoader.getReportInputControlValuesInformation(listOfValuesResource, resourceBundle, messageSource);
    }

    protected ResourceBundle loadResourceBundle(JasperReport report) {
        ResourceBundle bundle = null;
        String baseName = report.getResourceBundle();
        if (baseName != null) {
            Locale locale = LocaleContextHolder.getLocale();
            bundle = JRResourcesUtil.loadResourceBundle((String)baseName, (Locale)locale);
        }
        return bundle;
    }

    public String getReportParameterLabelKeyPrefix() {
        return this.reportParameterLabelKeyPrefix;
    }

    public void setReportParameterLabelKeyPrefix(String reportParameterLabelKeyPrefix) {
        this.reportParameterLabelKeyPrefix = reportParameterLabelKeyPrefix;
    }

    @Override
    public byte[] compileReport(ExecutionContext context, FileResource resource) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("compiling report " + resource.getURIString()));
        }
        InputStream jrxmlData = this.getFileResourceDataStream(context, resource);
        JasperDesign design = this.loadReportDesign(jrxmlData);
        JasperReport report = this.compileReport(design);
        byte[] reportBytes = this.reportBytes(report);
        if (!design.hasUUID()) {
            if (this.isAutoUpdateJRXMLs()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Auto updating JRXML resource at " + resource.getURIString() + ", missing UUID"));
                }
                this.autoUpdateJRXMLResource(resource, design);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("JRXML at " + resource.getURIString() + " does not have UUID, not updating"));
            }
        }
        return reportBytes;
    }

    protected void autoUpdateJRXMLResource(FileResource resource, JasperDesign report) {
        try {
            MemoryDataContainer jrxmlData = new MemoryDataContainer();
            OutputStream jrxmlStream = jrxmlData.getOutputStream();
            JRXmlWriter.writeReport((JRReport)report, (OutputStream)jrxmlStream, (String)"UTF-8");
            jrxmlStream.close();
            this.getUnsecureRepository().replaceFileResourceData(resource.getURIString(), (DataContainer)jrxmlData);
            if (resource.hasData()) {
                resource.setData(jrxmlData.getData());
            }
        }
        catch (Exception e) {
            log.warn((Object)("Failed to auto update JRXML resource with missing UUID at " + resource.getURIString()), (Throwable)e);
        }
    }

    public Executor getSyncReportExecutorService() {
        return this.syncReportExecutorService;
    }

    public void setSyncReportExecutorService(Executor syncReportExecutorService) {
        this.syncReportExecutorService = syncReportExecutorService;
    }

    public Executor getAsyncReportExecutorService() {
        return this.asyncReportExecutorService;
    }

    public void setAsyncReportExecutorService(Executor asyncReportExecutorService) {
        this.asyncReportExecutorService = asyncReportExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<ReportExecutionStatusInformation> getReportExecutionStatusList() {
        if (this.executions == null) {
            return null;
        }
        ArrayList<ReportExecutionStatusInformation> result = new ArrayList<ReportExecutionStatusInformation>();
        Map<String, ReportExecutionStatus> map = this.executions;
        synchronized (map) {
            Set<Map.Entry<String, ReportExecutionStatus>> entries = this.executions.entrySet();
            for (Map.Entry<String, ReportExecutionStatus> entry : entries) {
                result.add(entry.getValue());
            }
        }
        return result;
    }

    public List<ReportExecutionStatusInformation> getReportExecutionStatusList(ReportExecutionStatusSearchCriteria searchCriteria) {
        List<ReportExecutionStatusInformation> executions = this.getReportExecutionStatusList();
        if (executions == null) {
            return null;
        }
        ArrayList<ReportExecutionStatusInformation> newSet = new ArrayList<ReportExecutionStatusInformation>();
        for (ReportExecutionStatusInformation entry : executions) {
            Map entryProperties = entry.getProperties();
            if (searchCriteria.getReportURI() != null && !searchCriteria.getReportURI().equalsIgnoreCase((String)entryProperties.get(ReportExecutionStatus.PROPERTY_REPORTURI))) continue;
            newSet.add(entry);
        }
        return newSet;
    }

    public ReportExecutionStatusInformation getReportExecutionStatusByID(String reportExecutionStatusID) {
        List<ReportExecutionStatusInformation> list = this.getReportExecutionStatusList();
        if (list == null) {
            return null;
        }
        for (ReportExecutionStatusInformation entry : list) {
            if (!entry.getRequestId().equals(reportExecutionStatusID)) continue;
            return entry;
        }
        return null;
    }

    public List<ReportExecutionStatusInformation> getSchedulerReportExecutionStatusList() {
        List<ReportExecutionStatusInformation> executions = this.getReportExecutionStatusList();
        if (executions == null) {
            return null;
        }
        ArrayList<ReportExecutionStatusInformation> newSet = new ArrayList<ReportExecutionStatusInformation>();
        for (ReportExecutionStatusInformation entry : executions) {
            Map entryProperties = entry.getProperties();
            if (entryProperties == null || entryProperties.size() <= 0) continue;
            newSet.add(entry);
        }
        return newSet;
    }

    public List<ReportExecutionStatusInformation> getSchedulerReportExecutionStatusList(SchedulerReportExecutionStatusSearchCriteria searchCriteria) {
        List<ReportExecutionStatusInformation> executions = this.getReportExecutionStatusList();
        if (executions == null) {
            return null;
        }
        ArrayList<ReportExecutionStatusInformation> newSet = new ArrayList<ReportExecutionStatusInformation>();
        for (ReportExecutionStatusInformation entry : executions) {
            Map entryProperties = entry.getProperties();
            if (searchCriteria.getJobID() != null && !this.equals(searchCriteria.getJobID(), entryProperties.get(ReportExecutionStatus.PROPERTY_JOBID)) || searchCriteria.getJobLabel() != null && !this.equals(searchCriteria.getJobLabel(), entryProperties.get(ReportExecutionStatus.PROPERTY_JOBLABEL)) || searchCriteria.getReportURI() != null && !this.equals(searchCriteria.getReportURI(), entryProperties.get(ReportExecutionStatus.PROPERTY_REPORTURI)) || (searchCriteria.getFireTimeFrom() != null || searchCriteria.getFireTimeTo() != null) && !this.isBetween((Date)entryProperties.get(ReportExecutionStatus.PROPERTY_FIRETIME), searchCriteria.getFireTimeFrom(), searchCriteria.getFireTimeTo()) || searchCriteria.getUserName() != null && !this.equals(searchCriteria.getUserName(), entryProperties.get(ReportExecutionStatus.PROPERTY_USERNAME))) continue;
            newSet.add(entry);
        }
        return newSet;
    }

    private boolean isBetween(Date fireTime, Date from, Date to) {
        boolean result = false;
        if (fireTime != null && (from != null || to != null)) {
            if (from != null && to != null) {
                result = !(!fireTime.after(from) && !fireTime.equals(from) || !fireTime.before(to) && !fireTime.equals(to));
            } else if (from != null && to == null) {
                result = fireTime.after(from) || fireTime.equals(from);
            } else if (from == null && to != null) {
                result = fireTime.before(to) || fireTime.equals(to);
            }
        }
        return result;
    }

    private boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1 instanceof Date && obj2 instanceof Date) {
            GregorianCalendar calendar1 = new GregorianCalendar();
            calendar1.setTime((Date)obj1);
            calendar1.set(13, 0);
            calendar1.set(14, 0);
            GregorianCalendar calendar2 = new GregorianCalendar();
            calendar2.setTime((Date)obj2);
            calendar2.set(13, 0);
            calendar2.set(14, 0);
            return calendar1.compareTo(calendar2) == 0;
        }
        if (obj1 instanceof String && obj2 instanceof String) {
            return ((String)obj1).equalsIgnoreCase((String)obj2);
        }
        return obj1.equals(obj2);
    }

    public DataCacheProvider getDataCacheProvider() {
        return this.dataCacheProvider;
    }

    public void setDataCacheProvider(DataCacheProvider dataCacheProvider) {
        this.dataCacheProvider = dataCacheProvider;
    }

    public boolean isAutoUpdateJRXMLs() {
        return this.autoUpdateJRXMLs;
    }

    public void setAutoUpdateJRXMLs(boolean autoUpdateJRXMLs) {
        this.autoUpdateJRXMLs = autoUpdateJRXMLs;
    }

    public RepositoryUnsecure getUnsecureRepository() {
        return this.unsecureRepository;
    }

    public void setUnsecureRepository(RepositoryUnsecure unsecureRepository) {
        this.unsecureRepository = unsecureRepository;
    }

    public List<ReportExecutionListenerFactory> getReportExecutionListenerFactories() {
        return this.reportExecutionListenerFactories;
    }

    public void setReportExecutionListenerFactories(List<ReportExecutionListenerFactory> reportExecutionListenerFactories) {
        this.reportExecutionListenerFactories = reportExecutionListenerFactories;
    }

    protected static class OrigContextClassLoader {
        public final boolean set;
        public final ClassLoader origClassLoader;
        public final List jars;
        public static final OrigContextClassLoader NOT_SET = new OrigContextClassLoader(false);

        private OrigContextClassLoader(boolean set) {
            this.set = set;
            this.origClassLoader = null;
            this.jars = null;
        }

        public OrigContextClassLoader(ClassLoader origClassLoader, List jars) {
            this.set = true;
            this.origClassLoader = origClassLoader;
            this.jars = jars;
        }
    }

    protected class FillResultListener
    implements AsynchronousFilllListener {
        private JasperPrint jasperPrint;

        protected FillResultListener() {
        }

        public void reportFinished(JasperPrint jasperPrint) {
            this.jasperPrint = jasperPrint;
        }

        public void reportCancelled() {
            throw new JSException("Report has been cancelled");
        }

        public void reportFillError(Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new JSException("Error filling report", t);
        }

        public JasperPrint getJasperPrint() {
            return this.jasperPrint;
        }
    }

    @XmlRootElement(name="reportExecution")
    public static class ReportExecutionStatus
    implements ReportExecutionStatusInformation {
        public static String PROPERTY_REPORTURI = "REPORTEXECUTIONSTATUS_REPORTURI";
        public static String PROPERTY_JOBID = "REPORTEXECUTIONSTATUS_JOBID";
        public static String PROPERTY_JOBLABEL = "REPORTEXECUTIONSTATUS_JOBLABEL";
        public static String PROPERTY_FIRETIME = "REPORTEXECUTIONSTATUS_FIRETIME";
        public static String PROPERTY_USERNAME = "REPORTEXECUTIONSTATUS_USERNAME";
        public static String PROPERTY_QUARTZJOB = "REPORTEXECUTIONSTATUS_QUARTZJOB";
        private String requestId;
        private boolean cancelRequested;
        private ReportExecutionCancelable cancelable;
        private Map<String, Object> propertyMap = null;

        public ReportExecutionStatus() {
        }

        public ReportExecutionStatus(Request request) {
            this.requestId = request.getId();
        }

        public ReportExecutionStatus(Request request, Map<String, Object> propertyMap) {
            this.requestId = request.getId();
            this.propertyMap = propertyMap;
            if (propertyMap == null) {
                propertyMap = new HashMap<String, Object>();
            }
        }

        @XmlElement
        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public synchronized void setCancelable(ReportExecutionCancelable cancelable) {
            this.cancelable = cancelable;
        }

        @XmlTransient
        public synchronized ReportExecutionCancelable getCancelable() {
            return this.cancelable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean cancel() {
            Object quartzJob;
            this.cancelRequested = true;
            if (this.propertyMap != null && (quartzJob = this.propertyMap.get(PROPERTY_QUARTZJOB)) != null && quartzJob instanceof ReportExecutionJob) {
                ((ReportExecutionJob)quartzJob).cancelExecution();
            }
            ReportExecutionStatus reportExecutionStatus = this;
            synchronized (reportExecutionStatus) {
                if (this.cancelable != null) {
                    return this.cancelable.cancel(this.requestId);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No cancelable found for request " + this.requestId));
                }
                return true;
            }
        }

        public Map<String, Object> getProperties() {
            return this.propertyMap;
        }

        @XmlTransient
        public synchronized boolean isCancelRequested() {
            return this.cancelRequested;
        }
    }

    protected static class FillHandleCancelable
    implements ReportExecutionCancelable {
        private final FillHandle fillHandle;

        public FillHandleCancelable(FillHandle fillHandle) {
            this.fillHandle = fillHandle;
        }

        @Override
        public boolean cancel(String requestId) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Canceling filler for request " + requestId));
            }
            try {
                this.fillHandle.cancellFill();
            }
            catch (JRException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Error canceling report filler", (Throwable)e);
                }
                return false;
            }
            return true;
        }
    }

    protected static class QueryExecuterCancelable
    implements ReportExecutionCancelable {
        private final JRQueryExecuter queryExecuter;

        public QueryExecuterCancelable(JRQueryExecuter queryExecuter) {
            this.queryExecuter = queryExecuter;
        }

        @Override
        public boolean cancel(String requestId) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Canceling query executer for request " + requestId));
            }
            try {
                return this.queryExecuter.cancelQuery();
            }
            catch (JRException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Error canceling query executer", (Throwable)e);
                }
                return false;
            }
        }
    }

    protected static interface ReportExecutionCancelable {
        public boolean cancel(String var1);
    }

    protected class ReportFill
    extends ReportRunnable {
        private final ExecutionContext context;
        private final ReportUnit reportUnit;
        private final boolean inMemoryUnit;

        public ReportFill(ExecutionContext context, ReportUnitRequestBase request, ReportUnit reportUnit, boolean inMemoryUnit, ReportFiller filler, ReportExecutionListener executionListener) {
            super(request, filler, executionListener);
            this.context = context;
            this.reportUnit = reportUnit;
            this.inMemoryUnit = inMemoryUnit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void runReport() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initiating report execution for " + this.reportUnit.getURIString()));
            }
            ExecutionContext runtimeContext = EngineServiceImpl.getRuntimeExecutionContext(this.context);
            EngineServiceImpl.this.setThreadRepositoryContext(runtimeContext, (ResourceContainer)this.reportUnit, this.reportUnit.getURIString());
            try {
                Map unitResources = EngineServiceImpl.this.loadFinalResources(runtimeContext, this.reportUnit.getResources());
                OrigContextClassLoader origContext = EngineServiceImpl.this.setContextClassLoader(runtimeContext, unitResources, this.inMemoryUnit);
                try {
                    DataCacheSnapshot snapshot;
                    JasperReport report = EngineServiceImpl.this.getJasperReport(runtimeContext, this.request, this.reportUnit, this.inMemoryUnit);
                    boolean reportAsyncable = JRPropertiesUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).getBooleanProperty((JRPropertiesHolder)report, "net.sf.jasperreports.viewer.async", true);
                    this.filler.setAsyncable(reportAsyncable);
                    boolean hasCachedData = false;
                    if (EngineServiceImpl.this.dataCacheProvider != null && (snapshot = EngineServiceImpl.this.dataCacheProvider.setReportExecutionCache(runtimeContext, this.request, this.reportUnit)) != null) {
                        hasCachedData = true;
                        this.filler.setDataTimestamp(snapshot.getMetadata().getSnapshotDate());
                    }
                    Map reportParameters = EngineServiceImpl.this.getReportParameters(runtimeContext, report, this.request.getReportParameters());
                    EngineServiceImpl.this.setReportTemplates(runtimeContext, unitResources, reportParameters);
                    if (hasCachedData) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"running report with cached data");
                        }
                        try {
                            HashMap paramsCopy = new HashMap(reportParameters);
                            EngineServiceImpl.this.fillReport(runtimeContext, this.reportUnit, report, paramsCopy, null, null, this.filler);
                        }
                        catch (RuntimeException e) {
                            if (this.filler.hasResult()) {
                                throw e;
                            }
                            int snapshotExcIdx = ExceptionUtils.indexOfType((Throwable)e, DataSnapshotException.class);
                            if (snapshotExcIdx < 0) {
                                throw e;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("running report " + this.reportUnit.getURIString() + " with the data snapshot resulted in exception"), (Throwable)e);
                            }
                            EngineServiceImpl.this.dataCacheProvider.handleInvalidSnapshot(runtimeContext, this.request, this.reportUnit);
                        }
                    }
                    if (!this.filler.hasResult()) {
                        Query query;
                        this.filler.setDataTimestamp(new Date());
                        ReportDataSource datasource = null;
                        ResourceReference queryRef = this.reportUnit.getQuery();
                        Query query2 = query = queryRef == null ? null : EngineServiceImpl.this.getFinalResource(runtimeContext, queryRef, Query.class);
                        if (query != null && query.getDataSource() != null) {
                            datasource = (ReportDataSource)EngineServiceImpl.this.getFinalResource(runtimeContext, query.getDataSource(), Resource.class);
                        }
                        ResourceReference dsRef = this.reportUnit.getDataSource();
                        if (datasource == null && dsRef != null) {
                            datasource = (ReportDataSource)EngineServiceImpl.this.getFinalResource(runtimeContext, dsRef, Resource.class);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"running report with data source");
                        }
                        EngineServiceImpl.this.fillReport(runtimeContext, this.reportUnit, report, reportParameters, datasource, query, this.filler);
                    }
                }
                finally {
                    EngineServiceImpl.this.revert(origContext);
                }
            }
            finally {
                EngineServiceImpl.this.resetThreadRepositoryContext();
            }
        }
    }

    protected abstract class ReportRunnable
    implements Runnable {
        protected final ReportUnitRequestBase request;
        protected final ReportFiller filler;
        private final ReportExecutionListener executionListener;

        public ReportRunnable(ReportUnitRequestBase request, ReportFiller filler, ReportExecutionListener executionListener) {
            this.request = request;
            this.filler = filler;
            this.executionListener = executionListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            this.executionListener.start();
            try {
                EngineServiceImpl.this.startExecution(this.request);
                try {
                    this.runReport();
                }
                finally {
                    EngineServiceImpl.this.endExecution(this.request);
                }
                this.executionListener.end(!this.filler.hasError());
            }
            catch (Throwable t) {
                try {
                    this.filler.setError(t);
                    this.executionListener.end(!this.filler.hasError());
                }
                catch (Throwable throwable) {
                    this.executionListener.end(!this.filler.hasError());
                    throw throwable;
                }
            }
        }

        protected abstract void runReport() throws Exception;
    }

    protected static class SynchronousExecutor
    implements Executor {
        public static final SynchronousExecutor INSTANCE = new SynchronousExecutor();

        protected SynchronousExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    protected static class SynchronousFillHandle
    extends BaseFillHandle {
        protected SynchronousFillHandle(JasperReport jasperReport, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
            super((JasperReportsContext)DefaultJasperReportsContext.getInstance(), jasperReport, parameters, dataSource, null);
        }

        protected Executor getReportExecutor() {
            return SynchronousExecutor.INSTANCE;
        }
    }

    protected class AsynchronousReportFiller
    extends ReportFiller {
        protected AsynchronousReportFiller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fillReport(JasperReport report, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
            EngineServiceImpl.this.checkRequestCanceled();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Filling report for request " + EngineServiceImpl.this.currentExecutionId()));
            }
            SynchronousFillHandle fillHandle = new SynchronousFillHandle(report, parameters, dataSource);
            final AsyncJasperPrintAccessor result = new AsyncJasperPrintAccessor((FillHandle)fillHandle);
            if (this.asyncable) {
                fillHandle.addFillListener(new FillListener(){

                    public void pageGenerated(JasperPrint jasperPrint, int pageIndex) {
                        if (pageIndex == 0) {
                            AsynchronousReportFiller.this.setResult((JasperPrintAccessor)result, false);
                        }
                    }

                    public void pageUpdated(JasperPrint jasperPrint, int pageIndex) {
                    }
                });
            }
            FillResultListener fillResult = new FillResultListener();
            fillHandle.addListener(fillResult);
            FillHandleCancelable cancelable = new FillHandleCancelable((FillHandle)fillHandle);
            EngineServiceImpl.this.setExecutionCancelable(cancelable);
            try {
                fillHandle.startFill();
            }
            finally {
                EngineServiceImpl.this.clearExecutionCancelable();
            }
            this.setResult((JasperPrintAccessor)result, true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ended fill for request " + EngineServiceImpl.this.currentExecutionId()));
            }
        }
    }

    protected class SynchronousReportFiller
    extends ReportFiller {
        @Override
        public void fillReport(JasperReport report, Map<String, Object> parameters, JRDataSource dataSource) throws JRException {
            JasperPrint jasperPrint = EngineServiceImpl.this.fillReport(report, parameters, dataSource);
            SimpleJasperPrintAccessor result = new SimpleJasperPrintAccessor(jasperPrint);
            this.setResult((JasperPrintAccessor)result, false);
        }
    }

    protected static abstract class ReportFiller {
        private final Lock resultLock = new ReentrantLock();
        private final Condition resultSync = this.resultLock.newCondition();
        private JasperPrintAccessor result;
        private Throwable error;
        private Date dataTimestamp;
        protected boolean asyncable;

        protected ReportFiller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean hasResult() {
            this.resultLock.lock();
            try {
                boolean bl = this.result != null || this.error != null;
                return bl;
            }
            finally {
                this.resultLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setResult(JasperPrintAccessor result, boolean skipWhenSet) {
            this.resultLock.lock();
            try {
                if (this.result == null || !skipWhenSet) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Report fill result available " + result));
                    }
                    this.result = result;
                    this.resultSync.signalAll();
                }
            }
            finally {
                this.resultLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setError(Throwable error) {
            this.resultLock.lock();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Report fill error", error);
                }
                this.error = error;
                this.resultSync.signalAll();
            }
            finally {
                this.resultLock.unlock();
            }
        }

        public boolean hasError() {
            return this.error != null;
        }

        public JasperPrintAccessor getResult() throws Throwable {
            this.resultLock.lock();
            try {
                while (this.result == null && this.error == null) {
                    this.resultSync.await();
                }
                if (this.error != null) {
                    throw this.error;
                }
                JasperPrintAccessor jasperPrintAccessor = this.result;
                return jasperPrintAccessor;
            }
            catch (InterruptedException e) {
                throw new JSException((Throwable)e);
            }
            finally {
                this.resultLock.unlock();
            }
        }

        public abstract void fillReport(JasperReport var1, Map<String, Object> var2, JRDataSource var3) throws JRException;

        public Date getDataTimestamp() {
            return this.dataTimestamp;
        }

        public void setDataTimestamp(Date dataTimestamp) {
            this.dataTimestamp = dataTimestamp;
        }

        public void setAsyncable(boolean asyncable) {
            this.asyncable = asyncable;
        }
    }

    protected final class TempJarFileCacheObject
    implements RepositoryCacheMap.ObjectCache {
        protected TempJarFileCacheObject() {
        }

        @Override
        public boolean isValid(Object o) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object create(ExecutionContext context, FileResource res) {
            try {
                File tempFile = File.createTempFile("report_jar", ".jar");
                tempFile.deleteOnExit();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Created temp jar file \"" + tempFile.getPath() + "\" for resource \"" + res.getURIString() + "\""));
                }
                byte[] data = EngineServiceImpl.this.getFileResourceData(context, res);
                BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(tempFile));
                try {
                    ((OutputStream)fileOut).write(data);
                    ((OutputStream)fileOut).flush();
                }
                finally {
                    ((OutputStream)fileOut).close();
                }
                JarFile jarFile = new JarFile(tempFile);
                return jarFile;
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
                throw new JSExceptionWrapper((Exception)e);
            }
        }

        @Override
        public void release(Object o) {
            EngineServiceImpl.this.dispose((JarFile)o);
        }
    }
}

