/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.ofc;

import net.sf.jasperreports.components.ofc.ChartDataGenerator;
import net.sf.jasperreports.components.ofc.FillPieDataset;
import net.sf.jasperreports.components.ofc.PieChartComponent;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateGenericElement;
import net.sf.jasperreports.engine.fill.JRTemplateGenericPrintElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class FillPieChart
extends BaseFillComponent
implements JRFillCloneable {
    public static final JRGenericElementType CHART_PRINT_TYPE = new JRGenericElementType("http://jasperreports.sourceforge.net/openflashchart", "chart");
    private final PieChartComponent chart;
    private final FillPieDataset dataset;
    private String title;

    public FillPieChart(PieChartComponent chart, JRFillObjectFactory factory) {
        this.chart = chart;
        this.dataset = new FillPieDataset(chart.getDataset(), factory);
        factory.registerElementDataset((JRFillElementDataset)this.dataset);
    }

    protected boolean isEvaluateNow() {
        return this.chart.getEvaluationTime() == EvaluationTimeEnum.NOW;
    }

    public void evaluate(byte evaluation) throws JRException {
        if (this.isEvaluateNow()) {
            this.evaluateChart(evaluation);
        }
    }

    protected void evaluateChart(byte evaluation) throws JRException {
        this.title = (String)this.fillContext.evaluate(this.chart.getTitleExpression(), evaluation);
        this.dataset.evaluateDatasetRun(evaluation);
    }

    public JRPrintElement fill() {
        JRComponentElement element = this.fillContext.getComponentElement();
        JRTemplateGenericElement template = new JRTemplateGenericElement(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider(), CHART_PRINT_TYPE);
        JRTemplateGenericPrintElement printElement = new JRTemplateGenericPrintElement(template, this.elementId);
        printElement.setX(element.getX());
        printElement.setY(this.fillContext.getElementPrintY());
        printElement.setWidth(element.getWidth());
        printElement.setHeight(element.getHeight());
        if (this.isEvaluateNow()) {
            this.copy((JRGenericPrintElement)printElement);
        } else {
            this.fillContext.registerDelayedEvaluation((JRPrintElement)printElement, this.chart.getEvaluationTime(), this.chart.getEvaluationGroup());
        }
        return printElement;
    }

    public FillPrepareResult prepare(int availableHeight) {
        return FillPrepareResult.PRINT_NO_STRETCH;
    }

    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        throw new UnsupportedOperationException();
    }

    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluateChart(evaluation);
        this.copy((JRGenericPrintElement)element);
    }

    protected void copy(JRGenericPrintElement printElement) {
        this.dataset.finishDataset();
        String chartData = ChartDataGenerator.instance().generatePieChart(this.title, this.dataset);
        printElement.setParameterValue("ChartData", (Object)chartData);
    }
}

