/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.ofc;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.components.ofc.BarChartCompiler;
import net.sf.jasperreports.components.ofc.BarDataset;
import net.sf.jasperreports.components.ofc.BarSeries;
import net.sf.jasperreports.components.ofc.FillBarSeries;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.util.Pair;

public class FillBarDataset
extends JRFillElementDataset {
    private final BarDataset dataset;
    private List<FillBarSeries> seriesList;
    private Set<String> seriesKeys = new LinkedHashSet<String>();
    private Set<String> categories = new LinkedHashSet<String>();
    private Map<Pair<String, String>, Number> values = new LinkedHashMap<Pair<String, String>, Number>();

    public FillBarDataset(BarDataset dataset, JRFillObjectFactory factory) {
        super((JRElementDataset)dataset, factory);
        this.dataset = dataset;
        List<BarSeries> datasetSeries = dataset.getSeries();
        this.seriesList = new ArrayList<FillBarSeries>(datasetSeries.size());
        for (BarSeries series : datasetSeries) {
            FillBarSeries fillSeries = new FillBarSeries(series);
            this.seriesList.add(fillSeries);
        }
    }

    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        for (FillBarSeries series : this.seriesList) {
            series.evaluate(calculator);
        }
    }

    protected void customIncrement() {
        for (FillBarSeries series : this.seriesList) {
            String seriesKey = series.getSeriesKey();
            String category = series.getCategory();
            Number value = series.getValue();
            this.seriesKeys.add(seriesKey);
            this.categories.add(category);
            this.values.put((Pair<String, String>)new Pair((Object)seriesKey, (Object)category), value);
        }
    }

    protected void customInitialize() {
        this.seriesKeys.clear();
        this.categories.clear();
        this.values.clear();
    }

    public void collectExpressions(JRExpressionCollector collector) {
        BarChartCompiler.collectExpressions(this.dataset, collector);
    }

    public void finishDataset() {
        super.increment();
    }

    public Set<String> getSeriesKeys() {
        return this.seriesKeys;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public Number getValue(String seriesKey, String category) {
        return this.values.get(new Pair((Object)seriesKey, (Object)category));
    }
}

