/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.ofc;

import java.util.Iterator;
import java.util.Set;
import net.sf.jasperreports.components.ofc.FillBarDataset;
import net.sf.jasperreports.components.ofc.FillPieDataset;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ChartDataGenerator {
    private static final String BGCOLOR = "ffffff";
    private static final String[] COLORS = new String[]{"fadf12", "ed262a", "006f3c", "fa6112", "409dcf", "e5018c", "eaab35"};
    protected static final ChartDataGenerator INSTANCE = new ChartDataGenerator();

    public static ChartDataGenerator instance() {
        return INSTANCE;
    }

    public String generatePieChart(String title, FillPieDataset dataset) {
        try {
            JSONObject chart = new JSONObject();
            chart.put("bg_colour", (Object)BGCOLOR);
            chart.put("title", (Object)new JSONObject().put("text", (Object)title));
            JSONObject pie = new JSONObject();
            pie.put("type", (Object)"pie");
            pie.put("animate", true);
            pie.put("tip", (Object)"#val# of #total#<br>#percent#");
            pie.put("start-angle", 35);
            pie.put("border", 2);
            pie.put("alpha", 0.6);
            JSONArray colors = new JSONArray();
            for (int i = 0; i < COLORS.length; ++i) {
                colors.put((Object)COLORS[i]);
            }
            pie.put("colours", (Object)colors);
            JSONArray pieValues = new JSONArray();
            Iterator<String> labelIt = dataset.getKeys().iterator();
            Iterator<Number> valueIt = dataset.getValues().iterator();
            while (labelIt.hasNext() && valueIt.hasNext()) {
                String label = labelIt.next();
                Number value = valueIt.next();
                JSONObject pieValue = new JSONObject();
                pieValue.put("value", (Object)value);
                pieValue.put("label", (Object)label);
                pieValues.put((Object)pieValue);
            }
            pie.put("values", (Object)pieValues);
            JSONArray elements = new JSONArray();
            elements.put((Object)pie);
            chart.put("elements", (Object)elements);
            return chart.toString();
        }
        catch (JSONException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    public String generateBarChart(String title, FillBarDataset dataset) {
        try {
            Set<String> seriesKeys = dataset.getSeriesKeys();
            Set<String> categories = dataset.getCategories();
            JSONObject chart = new JSONObject();
            chart.put("bg_colour", (Object)BGCOLOR);
            chart.put("title", (Object)new JSONObject().put("text", (Object)title));
            JSONObject xAxis = new JSONObject();
            JSONArray labels = new JSONArray(categories);
            xAxis.put("labels", (Object)new JSONObject().put("labels", (Object)labels));
            chart.put("x_axis", (Object)xAxis);
            JSONArray elements = new JSONArray();
            int seriesIdx = 0;
            double max = 0.0;
            for (String seriesKey : seriesKeys) {
                JSONObject bar = new JSONObject();
                bar.put("type", (Object)"bar_glass");
                bar.put("colour", (Object)COLORS[seriesIdx % COLORS.length]);
                bar.put("alpha", 0.9);
                JSONArray values = new JSONArray();
                for (String category : categories) {
                    Number value = dataset.getValue(seriesKey, category);
                    if (value == null) {
                        value = new Integer(0);
                    }
                    JSONObject valueObject = new JSONObject();
                    valueObject.put("top", (Object)value);
                    valueObject.put("tip", (Object)(seriesKey + " #top#"));
                    values.put((Object)valueObject);
                    if (!(value.doubleValue() > max)) continue;
                    max = value.doubleValue();
                }
                bar.put("values", (Object)values);
                elements.put((Object)bar);
                ++seriesIdx;
            }
            int yMax = (int)Math.ceil(max);
            int m = 1;
            while (yMax > 100) {
                yMax = (int)Math.ceil((double)yMax / 10.0);
                m *= 10;
            }
            yMax = 5 * (int)Math.ceil((double)yMax / 5.0);
            int steps = (yMax *= m) / 5;
            JSONObject yAxis = new JSONObject();
            yAxis.put("max", yMax);
            yAxis.put("steps", steps);
            chart.put("y_axis", (Object)yAxis);
            chart.put("elements", (Object)elements);
            return chart.toString();
        }
        catch (JSONException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }
}

