/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.security.JasperServerAclEntry;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.services.PermissionsService;
import com.jaspersoft.jasperserver.remote.services.ResourcesManagementRemoteService;
import com.jaspersoft.jasperserver.remote.utils.AuditHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component(value="permissionsService")
public class PermissionsServiceImpl
implements PermissionsService {
    @Resource(name="concreteObjectPermissionsService")
    protected ObjectPermissionService objectPermissionService;
    @Resource(name="concreteRepository")
    protected RepositoryService repositoryService;
    @Resource
    private AuditHelper auditHelper;
    @Resource
    private ResourcesManagementRemoteService resourcesManagementRemoteService;
    @Resource(name="mappingResourceFactory")
    private ResourceFactory resourceFactory;
    @Resource(name="concreteUserAuthorityService")
    protected UserAuthorityService userAuthorityService;

    public void setResourcesManagementRemoteService(ResourcesManagementRemoteService resourcesManagementRemoteService) {
        this.resourcesManagementRemoteService = resourcesManagementRemoteService;
    }

    public void setAuditHelper(AuditHelper auditHelper) {
        this.auditHelper = auditHelper;
    }

    @Override
    public List<ObjectPermission> getPermissions(String resourceURI) throws RemoteException {
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.resourcesManagementRemoteService.locateResource(resourceURI);
        return this.objectPermissionService.getObjectPermissionsForObject(this.makeExecutionContext(), (Object)resource);
    }

    @Override
    public List<ObjectPermission> getPermissionsForObject(String targetURI) throws RemoteException {
        if (!this.objectPermissionService.isObjectAdministrable(this.makeExecutionContext(), (Object)targetURI)) {
            throw new RemoteException("Access is denied");
        }
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource res = this.repositoryService.getResource(this.makeExecutionContext(), targetURI);
        if (res == null && (res = this.repositoryService.getFolder(this.makeExecutionContext(), targetURI)) == null) {
            throw new RemoteException("There is no resource or folder for target URI \"" + targetURI + "\"");
        }
        return this.objectPermissionService.getObjectPermissionsForObject(this.makeExecutionContext(), (Object)res);
    }

    @Override
    public ObjectPermission putPermission(ObjectPermission objectPermission) throws RemoteException {
        this.changePermissionConsistencyCheck(objectPermission);
        ObjectPermission existingObjectPermission = this.objectPermissionService.getObjectPermission(this.makeExecutionContext(), objectPermission);
        String auditEventType = existingObjectPermission == null ? "createPermission" : "updatePermission";
        this.auditHelper.createAuditEvent(auditEventType);
        this.objectPermissionService.putObjectPermission(this.makeExecutionContext(), objectPermission);
        this.auditHelper.closeAuditEvent(auditEventType);
        return this.objectPermissionService.getObjectPermission(this.makeExecutionContext(), objectPermission);
    }

    @Override
    public void deletePermission(ObjectPermission objectPermission) throws RemoteException {
        this.changePermissionConsistencyCheck(objectPermission);
        this.auditHelper.createAuditEvent("deletePermission");
        this.objectPermissionService.deleteObjectPermission(this.makeExecutionContext(), objectPermission);
        this.auditHelper.closeAuditEvent("deletePermission");
    }

    @Override
    public ObjectPermission newObjectPermission() {
        return this.objectPermissionService.newObjectPermission(this.makeExecutionContext());
    }

    @Override
    public int getAppliedPermissionMaskForObjectAndCurrentUser(String targetURI) throws RemoteException {
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.repositoryService.getResource(this.makeExecutionContext(), targetURI);
        if (resource == null && (resource = this.repositoryService.getFolder(this.makeExecutionContext(), targetURI)) == null) {
            throw new RemoteException("There is no resource or folder for target URI \"" + targetURI + "\"");
        }
        HashSet<Integer> allUserPermissions = null;
        List<Object> currentUserRecipients = this.getCurrentUserRecipients();
        if (currentUserRecipients != null && currentUserRecipients.size() > 0) {
            allUserPermissions = new HashSet<Integer>();
            for (Object recipient : this.getCurrentUserRecipients()) {
                List permissions = this.objectPermissionService.getObjectPermissionsForObjectAndRecipient(this.makeExecutionContext(), (Object)resource, recipient);
                if (permissions != null && !permissions.isEmpty()) {
                    ObjectPermission permissionObject = (ObjectPermission)permissions.get(0);
                    allUserPermissions.add(permissionObject.getPermissionMask());
                    continue;
                }
                allUserPermissions.add(this.objectPermissionService.getInheritedObjectPermissionMask(this.makeExecutionContext(), (Object)resource, recipient));
            }
        }
        if (allUserPermissions != null && allUserPermissions.size() > 0) {
            JasperServerAclEntry jasperServerAclEntry = new JasperServerAclEntry();
            return jasperServerAclEntry.printPermissionsOverlappingBlock(allUserPermissions);
        }
        return 0;
    }

    protected List<Object> getCurrentUserRecipients() {
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        ArrayList<Object> recipients = new ArrayList<Object>();
        if (authenticationToken.getPrincipal() instanceof User) {
            User user = (User)authenticationToken.getPrincipal();
            recipients.add(user);
            recipients.addAll(user.getRoles());
            return recipients;
        }
        return null;
    }

    protected void changePermissionConsistencyCheck(ObjectPermission objectPermission) throws RemoteException {
        if (StringUtils.isBlank((String)objectPermission.getURI())) {
            throw new RemoteException("URI is blank");
        }
        if (objectPermission.getPermissionRecipient() == null) {
            throw new RemoteException("Permission recipient is null");
        }
        if (this.isPermissionForRootRessource(objectPermission)) {
            throw new RemoteException("Setting/changing/deleting permissions for root URI is forbidden");
        }
    }

    public void setObjectPermissionService(ObjectPermissionService objectPermissionService) {
        this.objectPermissionService = objectPermissionService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setUserAuthorityService(UserAuthorityService userAuthorityService) {
        this.userAuthorityService = userAuthorityService;
    }

    protected boolean isPermissionForRootRessource(ObjectPermission objectPermission) {
        return "repo:/".equals(objectPermission.getURI()) || "/".equals(objectPermission.getURI());
    }

    protected ExecutionContext makeExecutionContext() {
        return ExecutionContextImpl.getRuntimeExecutionContext();
    }

    protected Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }
}

