/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.RepositoryResourceHandler;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class DataTypeHandler
extends RepositoryResourceHandler {
    @Override
    public Class getResourceType() {
        return DataType.class;
    }

    @Override
    protected void doGet(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        DataType fileResource = (DataType)resource;
        descriptor.setWsType("dataType");
        descriptor.setHasData(false);
        descriptor.setIsReference(false);
        descriptor.setDataType(fileResource.getType());
        descriptor.setPattern(fileResource.getRegularExpr());
        descriptor.setMaxValue(fileResource.getMaxValue() == null ? null : fileResource.getMaxValue() + "");
        descriptor.setMinValue(fileResource.getMinValue() == null ? null : fileResource.getMinValue() + "");
        descriptor.setStrictMax(fileResource.isStrictMax());
        descriptor.setStrictMin(fileResource.isStrictMin());
    }

    @Override
    protected void updateResource(Resource resource, ResourceDescriptor descriptor, Map options) {
        super.updateResource(resource, descriptor, options);
        DataType dataType = (DataType)resource;
        dataType.setType(descriptor.getDataType());
        dataType.setRegularExpr(descriptor.getPattern());
        dataType.setMaxValue((Comparable)((Object)descriptor.getMaxValue()));
        dataType.setStrictMax(descriptor.isStrictMax());
        dataType.setMinValue((Comparable)((Object)descriptor.getMinValue()));
        dataType.setStrictMin(descriptor.isStrictMin());
    }
}

