/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.UniversalValidationErrorFilter;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.search.SearchFilter;
import com.jaspersoft.jasperserver.remote.ResourceActionResolver;
import com.jaspersoft.jasperserver.remote.ResourceHandler;
import com.jaspersoft.jasperserver.remote.ResourceResolverAdapter;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.handlers.ResourceContainer;
import com.jaspersoft.jasperserver.remote.services.PermissionsService;
import com.jaspersoft.jasperserver.remote.services.ResourcesManagementRemoteService;
import com.jaspersoft.jasperserver.remote.services.RunReportService;
import com.jaspersoft.jasperserver.ws.xml.ByteArrayDataSource;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public abstract class AbstractResourceHandler
implements ResourceHandler,
ResourceResolverAdapter {
    private static final Log log = LogFactory.getLog(AbstractResourceHandler.class);
    @Resource(name="concreteRepository")
    private RepositoryService repository;
    @Autowired
    private MessageSource messageSource;
    @Resource
    private ResourcesManagementRemoteService resourcesManagementRemoteService;
    @Resource(name="remoteResourceActionResolver")
    private ResourceActionResolver remoteResourceActionResolver;
    @Resource(name="runReportService")
    private RunReportService runReportService;
    @Resource(name="concretePermissionsService")
    private PermissionsService permissionsService;

    protected ResourceActionResolver getResourceActionResolver() {
        return this.remoteResourceActionResolver;
    }

    public void setRunReportService(RunReportService runReportService) {
        this.runReportService = runReportService;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public void setPermissionsService(PermissionsService permissionsService) {
        this.permissionsService = permissionsService;
    }

    public void setRemoteResourceActionResolver(ResourceActionResolver remoteResourceActionResolver) {
        this.remoteResourceActionResolver = remoteResourceActionResolver;
    }

    public void setResourcesManagementRemoteService(ResourcesManagementRemoteService resourcesManagementRemoteService) {
        this.resourcesManagementRemoteService = resourcesManagementRemoteService;
    }

    @Override
    public void setResourceActionHandler(ResourceActionResolver resourceActionResolver) {
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public ResourcesManagementRemoteService getResourcesManagementRemoteService() {
        return this.resourcesManagementRemoteService;
    }

    public ResourceActionResolver getRemoteResourceActionResolver() {
        return this.remoteResourceActionResolver;
    }

    public RunReportService getRunReportService() {
        return this.runReportService;
    }

    @Override
    public SearchFilter getSearchFilter(String uri, String queryString, String wsType, boolean recursive, int maxItems, int startIndex) {
        return null;
    }

    @Override
    public ResourceDescriptor get(com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource, Map options) throws ServiceException {
        ResourceDescriptor descriptor = new ResourceDescriptor();
        this.setCommonAttributes(resource, descriptor, options);
        this.doGet(resource, descriptor, options);
        return descriptor;
    }

    protected void setCommonAttributes(com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource, ResourceDescriptor descriptor, Map options) {
        descriptor.setUriString(resource.getURIString());
        descriptor.setDescription(resource.getDescription());
        descriptor.setLabel(resource.getLabel());
        descriptor.setName(resource.getName());
        descriptor.setResourceType(resource.getResourceType());
        descriptor.setParentFolder(resource.getParentFolder());
        descriptor.setVersion(resource.getVersion());
        descriptor.setCreationDate(resource.getCreationDate());
        try {
            descriptor.setResourceProperty("PROP_SECURITY_PERMISSION_MASK", this.permissionsService.getAppliedPermissionMaskForObjectAndCurrentUser(resource.getURIString()));
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (resource instanceof FileResource) {
            byte[] byteArr;
            if (options != null && options.containsKey("GET_LOCAL_RESOURCE") && ((Boolean)options.get("GET_LOCAL_RESOURCE")).booleanValue()) {
                byteArr = this.repository.getResourceData(null, resource.getURI()).getData();
                ByteArrayDataSource bads = new ByteArrayDataSource(byteArr);
                this.runReportService.getOutputAttachments().put(descriptor.getUriString(), (DataSource)bads);
                descriptor.setData(byteArr);
            }
            if (!resource.getParentFolder().endsWith("_files")) {
                byteArr = this.repository.getResourceData(null, resource.getURI()).getData();
                descriptor.setData(byteArr);
            }
        }
    }

    protected abstract void doGet(com.jaspersoft.jasperserver.api.metadata.common.domain.Resource var1, ResourceDescriptor var2, Map var3) throws ServiceException;

    protected void validate(com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource) throws ServiceException {
        UniversalValidationErrorFilter filter = resource.isNew() ? UniversalValidationErrorFilter.getInstance() : null;
        ValidationErrors errors = null;
        errors = resource instanceof Folder ? this.repository.validateFolder(null, (Folder)resource, (ValidationErrorFilter)filter) : this.repository.validateResource(null, resource, (ValidationErrorFilter)filter);
        if (log.isDebugEnabled()) {
            log.debug((Object)(errors.getErrors().size() + " Error were found"));
        }
        if (errors.isError()) {
            String errorString = "";
            List errorsList = errors.getErrors();
            for (int i = 0; i < errorsList.size(); ++i) {
                ValidationError ve = (ValidationError)errorsList.get(i);
                if (errorString.length() > 0) {
                    errorString = errorString + "\n";
                }
                errorString = errorString + this.messageSource.getMessage(ve.getErrorCode(), ve.getErrorArguments(), ve.getDefaultMessage(), LocaleContextHolder.getLocale());
            }
            throw new ServiceException(400, errorString);
        }
    }

    public ResourceDescriptor update(ResourceDescriptor descriptor, Map options) throws ServiceException {
        return this.update(descriptor, options, true);
    }

    @Override
    public ResourceDescriptor update(ResourceDescriptor descriptor, Map options, boolean save) throws ServiceException {
        ResourceHandler pResourceHandler;
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource parentResource = this.getParentResource(descriptor);
        ResourceContainer parentHandler = null;
        if (parentResource != null && (pResourceHandler = this.resourcesManagementRemoteService.getHandler(parentResource)) instanceof ResourceContainer) {
            parentHandler = (ResourceContainer)((Object)pResourceHandler);
        }
        if (descriptor.getIsNew()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("creating " + descriptor.getUriString()));
            }
            if (parentHandler == null) {
                com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.createResource(descriptor);
                this.validate(resource);
                if (save) {
                    if (resource instanceof Folder) {
                        this.repository.saveFolder(null, (Folder)resource);
                    } else {
                        this.repository.saveResource(null, resource);
                    }
                }
                return this.resourcesManagementRemoteService.createResourceDescriptor(resource);
            }
            com.jaspersoft.jasperserver.api.metadata.common.domain.Resource subResource = parentHandler.addSubResource(parentResource, descriptor);
            if (subResource != null) {
                this.validate(parentResource);
                if (save) {
                    this.repository.saveResource(null, parentResource);
                }
                return this.resourcesManagementRemoteService.createResourceDescriptor(subResource);
            }
            throw new ServiceException(403, this.messageSource.getMessage("webservices.error.cannotCreateResource", (Object[])new String[]{parentResource.getParentFolder()}, LocaleContextHolder.getLocale()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("modifying " + descriptor.getUriString()));
        }
        if (parentHandler == null) {
            Class resourceType = this.getResourceType();
            Object resource = null;
            resource = "folder".equals(descriptor.getWsType()) ? this.repository.getFolder(null, descriptor.getUriString()) : this.repository.getResource(null, descriptor.getUriString(), resourceType);
            if (resource == null) {
                throw new ServiceException(404, this.messageSource.getMessage("webservices.error.resourceNotFound", new Object[0], LocaleContextHolder.getLocale()));
            }
            this.updateResource((com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)resource, descriptor, options);
            this.validate((com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)resource);
            if (save) {
                if (resource instanceof Folder) {
                    this.repository.saveFolder(null, resource);
                } else {
                    this.repository.saveResource(null, (com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)resource);
                }
            }
            return this.resourcesManagementRemoteService.createResourceDescriptor((com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)resource);
        }
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource subResource = parentHandler.addSubResource(parentResource, descriptor);
        if (subResource != null) {
            this.validate(subResource);
            if (save) {
                this.repository.saveResource(null, parentResource);
            }
            return this.resourcesManagementRemoteService.createResourceDescriptor(subResource);
        }
        throw new ServiceException(1, this.messageSource.getMessage("webservices.error.cannotCreateResource", (Object[])new String[]{parentResource.getParentFolder()}, LocaleContextHolder.getLocale()));
    }

    protected com.jaspersoft.jasperserver.api.metadata.common.domain.Resource getModifyingParentResource(Map options) throws ServiceException {
        String reportUnitUrl;
        ReportUnit resource = null;
        if (options != null && options.containsKey("MODIFY_REPORTUNIT_URI") && (reportUnitUrl = (String)options.get("MODIFY_REPORTUNIT_URI")) != null && reportUnitUrl.length() > 0) {
            ReportUnit reportUnit;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Put: adding/modifying resource in reportUnit " + reportUnitUrl));
            }
            if ((reportUnit = (ReportUnit)this.repository.getResource(null, reportUnitUrl)) == null) {
                throw new ServiceException(404, this.messageSource.getMessage("webservices.error.reportUnitNotFound", new Object[0], LocaleContextHolder.getLocale()));
            }
            resource = reportUnit;
        }
        return resource;
    }

    protected com.jaspersoft.jasperserver.api.metadata.common.domain.Resource createResource(ResourceDescriptor descriptor) throws ServiceException {
        Class resourceType = this.getResourceType();
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.repository.newResource(null, resourceType);
        resource.setParentFolder(descriptor.getParentFolder());
        resource.setVersion(-1);
        resource.setName(descriptor.getName());
        resource.setURIString(descriptor.getUriString());
        this.updateResource(resource, descriptor, null);
        return resource;
    }

    protected com.jaspersoft.jasperserver.api.metadata.common.domain.Resource createChildResource(ResourceDescriptor descriptor) throws ServiceException {
        String childType = descriptor.getWsType();
        ResourceHandler handler = this.resourcesManagementRemoteService.getHandler(childType);
        if (handler == null || !(handler instanceof AbstractResourceHandler)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)(handler.getClass().getName() + " does not implement AbstractResourceHandler"));
            }
            return null;
        }
        return ((AbstractResourceHandler)handler).createResource(descriptor);
    }

    protected void updateResource(com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource, ResourceDescriptor descriptor, Map options) {
        resource.setLabel(descriptor.getLabel());
        resource.setDescription(descriptor.getDescription());
        resource.setParentFolder(descriptor.getParentFolder());
        resource.setURIString(descriptor.getUriString());
        resource.setName(descriptor.getName());
    }

    public boolean isDataSource(ResourceDescriptor rd) {
        String type = rd.getWsType();
        ResourceHandler handler = this.resourcesManagementRemoteService.getHandler(type);
        if (handler != null) {
            Class resourceType = handler.getResourceType();
            ResourceHandler parentHandler = this.resourcesManagementRemoteService.getHandler("datasource");
            Class parentResourceType = parentHandler.getResourceType();
            return parentResourceType.isAssignableFrom(resourceType);
        }
        return false;
    }

    private com.jaspersoft.jasperserver.api.metadata.common.domain.Resource getParentResource(ResourceDescriptor descriptor) {
        String parentResourceUri;
        String resourceUri = descriptor.getUriString();
        int lastSeparatorPos = descriptor.getUriString().lastIndexOf("/");
        String string = parentResourceUri = lastSeparatorPos == 0 ? null : resourceUri.substring(0, lastSeparatorPos);
        if (parentResourceUri == null) {
            return null;
        }
        if (parentResourceUri.endsWith("_files")) {
            parentResourceUri = parentResourceUri.substring(0, parentResourceUri.length() - "_files".length());
            if (log.isDebugEnabled()) {
                log.debug((Object)("getParentResource: removing the local resource suffix parent resource uri= " + parentResourceUri));
            }
        }
        try {
            return this.resourcesManagementRemoteService.locateResource(parentResourceUri);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void delete(ResourceDescriptor descriptor) throws ServiceException {
        if (this.remoteResourceActionResolver.isResourceDeletable(descriptor.getUriString())) {
            if (descriptor.getWsType().equals("folder")) {
                this.repository.deleteFolder(null, descriptor.getUriString());
            } else {
                com.jaspersoft.jasperserver.api.metadata.common.domain.Resource parentResource = this.getParentResource(descriptor);
                if (parentResource != null) {
                    ResourceHandler pResourceHandler = this.resourcesManagementRemoteService.getHandler(parentResource);
                    if (pResourceHandler instanceof ResourceContainer) {
                        ((ResourceContainer)((Object)pResourceHandler)).deleteSubResource(parentResource, descriptor);
                        this.repository.saveResource(null, parentResource);
                    } else {
                        this.repository.deleteResource(null, descriptor.getUriString());
                    }
                }
            }
        } else {
            throw new ServiceException(403, this.messageSource.getMessage("webservices.error.notDeletableResource", new Object[0], LocaleContextHolder.getLocale()));
        }
    }
}

