/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.exception.builders;

import com.jaspersoft.jasperserver.remote.exception.xml.ErrorDescriptor;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class LocalizedErrorDescriptorBuilder
extends ErrorDescriptor.Builder {
    private MessageSource messageSource;

    public LocalizedErrorDescriptorBuilder(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public ErrorDescriptor createDescriptor(String errorCode, Object[] params) {
        Locale locale = LocaleContextHolder.getLocale();
        String message = this.messageSource != null ? this.messageSource.getMessage(errorCode, params, null, locale) : errorCode;
        return this.setMessage(message).setErrorCode(errorCode).setParameters(params).getErrorDescriptor();
    }

    public ErrorDescriptor createDescriptor(String errorCode) {
        return this.createDescriptor(errorCode, null);
    }
}

