/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.tags;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataCacheProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.HtmlExportUtil;
import com.jaspersoft.jasperserver.war.action.WebflowReportContext;
import com.jaspersoft.jasperserver.war.action.hyperlinks.HyperlinkProducerFactoryFlowFactory;
import com.jaspersoft.jasperserver.war.util.JRHtmlExportUtils;
import com.jaspersoft.jasperserver.war.util.SessionObjectSerieAccessor;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import net.sf.jasperreports.web.servlets.ReportExecutionStatus;
import net.sf.jasperreports.web.servlets.ReportPageStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.tags.RequestContextAwareTag;

public class JasperViewerTag
extends RequestContextAwareTag {
    protected static final Log log = LogFactory.getLog(JasperViewerTag.class);
    public static final String DEFAULT_RENDER_JSP = "/WEB-INF/jsp/modules/viewReport/DefaultJasperViewer.jsp";
    public static final String DEFAULT_JASPER_PRINT_ATTRIBUTE = "jasperPrint";
    public static final String DEFAULT_PAGE_INDEX_ATTRIBUTE = "pageIndex";
    public static final String DEFAULT_LINK_PRODUCER_FACTORY_ATTRIBUTE = "hyperlinkHandlerFactory";
    public static final String EMPTY_REPORT_ATTRIBUTE = "emptyReport";
    public static final String INNER_PAGINATION_ATTRIBUTE = "innerPagination";
    public static final String IGNORE_PAGE_MARGINS = "ignorePageMargins";
    public static final String MESSAGE_SOURCE = "messageSource";
    protected static final String JASPER_PRINT_ACCESSOR_BEAN_NAME = "jasperPrintAccessor";
    protected static final String DATA_CACHE_PROVIDER_BEAN_NAME = "engineServiceDataCacheProvider";
    private String imageServlet;
    private String resourceServlet;
    private String page;
    private String renderJsp;
    private String providedExporterClassName;
    private boolean innerPagination;
    private boolean ignorePageMargins;
    private Map exporterParameters;
    private String jasperPrintAttribute = "jasperPrint";
    private String pageIndexAttribute = "pageIndex";
    private String linkProducerFactoryAttribute = "hyperlinkHandlerFactory";
    private Map reportContextMap;

    protected int doStartTagInternal() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doEndTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        try {
            ReportUnitResult reportResult = this.getReportResult(request);
            JasperPrintAccessor printAccessor = reportResult.getJasperPrintAccessor();
            if (printAccessor == null) {
                log.error((Object)"There is no JasperPrint object cannot be accessed.");
                return 6;
            }
            Integer pageIndex = (Integer)request.getAttribute(this.getPageIndexAttribute());
            if (pageIndex == null) {
                pageIndex = new Integer(0);
            }
            ReportExecutionStatus reportStatus = printAccessor.getReportStatus();
            ReportPageStatus pageStatus = printAccessor.pageStatus(pageIndex.intValue(), null);
            request.setAttribute("page", (Object)this.page);
            request.setAttribute("dataTimestamp", (Object)reportResult.getDataTimestamp());
            request.setAttribute(INNER_PAGINATION_ATTRIBUTE, (Object)this.innerPagination);
            request.setAttribute(IGNORE_PAGE_MARGINS, (Object)this.ignorePageMargins);
            Integer totalPageCount = reportStatus.getTotalPageCount();
            if (totalPageCount != null) {
                request.setAttribute("lastPageIndex", (Object)new Integer(totalPageCount - 1));
                DataCacheProvider.SnapshotSaveStatus snapshotSaveStatus = this.getDataCacheProvider().getSnapshotSaveStatus(reportResult.getReportContext());
                if (snapshotSaveStatus != null) {
                    request.setAttribute("snapshotSaveStatus", (Object)snapshotSaveStatus.toString());
                }
            }
            request.setAttribute("lastPartialPageIndex", (Object)new Integer(reportStatus.getCurrentPageCount() - 1));
            boolean emptyReport = totalPageCount != null && totalPageCount == 0;
            request.setAttribute(EMPTY_REPORT_ATTRIBUTE, (Object)emptyReport);
            WebApplicationContext applicationContext = this.getRequestContext().getWebApplicationContext();
            request.setAttribute(MESSAGE_SOURCE, applicationContext.getBean(MESSAGE_SOURCE));
            if (!emptyReport) {
                HyperlinkProducerFactoryFlowFactory linkProducerFactory;
                if (!pageStatus.pageExists()) {
                    response.setHeader("reportPageNonExisting", "true");
                    throw new JSException("jsexception.view.page.does.not.exist", new Object[]{pageIndex});
                }
                request.setAttribute(DEFAULT_PAGE_INDEX_ATTRIBUTE, (Object)pageIndex);
                if (!pageStatus.isPageFinal()) {
                    request.setAttribute("pageTimestamp", (Object)pageStatus.getTimestamp());
                }
                JasperReportsContext jasperReportsContext = (JasperReportsContext)applicationContext.getBean("jasperReportsContext");
                JRExporter exporter = HtmlExportUtil.getHtmlExporter((JasperReportsContext)jasperReportsContext);
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)printAccessor.getJasperPrint());
                exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)pageIndex);
                String imageURI = response.encodeURL(this.imageServlet + "image=");
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)imageURI);
                StringBuffer htmlHeader = new StringBuffer();
                String contextPath = request.getContextPath();
                String referer = request.getHeader("Referer");
                referer = referer.substring(0, referer.indexOf(contextPath) + contextPath.length());
                htmlHeader.append("<link type='text/css' rel='stylesheet' href='" + referer + "/scripts/jquery/theme/redmond/jquery-ui-1.8.20.custom.css'></link>");
                htmlHeader.append("<link type='text/css' rel='stylesheet' href='" + this.resourceServlet.replace(contextPath, referer) + "net/sf/jasperreports/web/servlets/resources/jasperreports-global.css'></link>");
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_HEADER, (Object)htmlHeader.toString());
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_FOOTER, (Object)"");
                exporter.setParameter((JRExporterParameter)JRHtmlExportUtils.PARAMETER_HTTP_REQUEST, (Object)request);
                exporter.setParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, (Object)this.ignorePageMargins);
                WebflowReportContext webflowReportContext = WebflowReportContext.getInstance(request.getSession(), this.reportContextMap);
                webflowReportContext.setParameterValue("net.sf.jasperreports.web.app.context.path", contextPath);
                exporter.setReportContext((ReportContext)webflowReportContext);
                if (webflowReportContext.getParameterValue("viewAsDashboardFrame") != null && webflowReportContext.getParameterValue("viewAsDashboardFrame").toString().equalsIgnoreCase("true")) {
                    request.setAttribute("viewAsDashboardFrame", (Object)"true");
                }
                if ((linkProducerFactory = (HyperlinkProducerFactoryFlowFactory)request.getAttribute(this.getLinkProducerFactoryAttribute())) != null) {
                    JRHyperlinkProducerFactory hyperlinkProducerFactory = linkProducerFactory.getHyperlinkProducerFactory(request, response);
                    exporter.setParameter(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY, (Object)hyperlinkProducerFactory);
                }
                request.setAttribute("exporter", (Object)exporter);
            }
            BodyContent nestedContent = this.pageContext.pushBody();
            boolean popped = false;
            try {
                this.pageContext.include(this.getRenderJsp());
                popped = true;
                this.pageContext.popBody();
                nestedContent.writeOut((Writer)this.pageContext.getOut());
            }
            finally {
                if (!popped) {
                    this.pageContext.popBody();
                }
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e, (Throwable)e);
            }
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    protected ReportUnitResult getReportResult(HttpServletRequest request) {
        SessionObjectSerieAccessor jasperPrintAccessor = this.getJasperPrintAccessor();
        ReportUnitResult result = (ReportUnitResult)jasperPrintAccessor.getObject(request, this.getJasperPrintAttribute());
        if (result == null) {
            throw new JSException("jsexception.jasperprint.not.found", new Object[]{this.getJasperPrintAttribute()});
        }
        return result;
    }

    protected SessionObjectSerieAccessor getJasperPrintAccessor() {
        WebApplicationContext applicationContext = this.getRequestContext().getWebApplicationContext();
        SessionObjectSerieAccessor jasperPrintAccessor = (SessionObjectSerieAccessor)applicationContext.getBean(JASPER_PRINT_ACCESSOR_BEAN_NAME, SessionObjectSerieAccessor.class);
        return jasperPrintAccessor;
    }

    protected DataCacheProvider getDataCacheProvider() {
        WebApplicationContext applicationContext = this.getRequestContext().getWebApplicationContext();
        DataCacheProvider dataCacheProvider = (DataCacheProvider)applicationContext.getBean(DATA_CACHE_PROVIDER_BEAN_NAME, DataCacheProvider.class);
        return dataCacheProvider;
    }

    public String getImageServlet() {
        return this.imageServlet;
    }

    public void setImageServlet(String imageServlet) {
        this.imageServlet = imageServlet;
    }

    public String getResourceServlet() {
        return this.resourceServlet;
    }

    public void setResourceServlet(String resourceServlet) {
        this.resourceServlet = resourceServlet;
    }

    public void setInnerPagination(String innerPagination) {
        this.innerPagination = innerPagination.equals("true");
    }

    public void setReportContext(Map reportContextMap) {
        this.reportContextMap = reportContextMap;
    }

    public void setIgnorePageMargins(String ignorePageMargins) {
        boolean ignore = false;
        if (ignorePageMargins != null && ignorePageMargins.length() > 0) {
            ignore = ignorePageMargins.equalsIgnoreCase("true");
        }
        this.ignorePageMargins = ignore;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getRenderJsp() {
        if (this.renderJsp == null || this.renderJsp.trim().length() == 0) {
            return DEFAULT_RENDER_JSP;
        }
        return this.renderJsp;
    }

    public void setRenderJsp(String renderJsp) {
        this.renderJsp = renderJsp;
    }

    public String getExporterClassName() {
        return this.providedExporterClassName;
    }

    public void setExporterClassName(String exporterClassName) {
        this.providedExporterClassName = exporterClassName;
    }

    public Map getExporterParameters() {
        return this.exporterParameters;
    }

    public void setExporterParameters(Map exporterParameters) {
        this.exporterParameters = exporterParameters;
    }

    private void setParameters(JRExporter exporter) {
        if (this.exporterParameters == null || this.exporterParameters.size() == 0) {
            return;
        }
        for (Map.Entry entry : this.exporterParameters.entrySet()) {
            exporter.setParameter((JRExporterParameter)entry.getKey(), entry.getValue());
        }
    }

    public String getJasperPrintAttribute() {
        return this.jasperPrintAttribute;
    }

    public void setJasperPrintAttribute(String jasperPrintAccessorAttribute) {
        this.jasperPrintAttribute = jasperPrintAccessorAttribute;
    }

    public String getPageIndexAttribute() {
        return this.pageIndexAttribute;
    }

    public void setPageIndexAttribute(String pageIndexAttribute) {
        this.pageIndexAttribute = pageIndexAttribute;
    }

    public String getLinkProducerFactoryAttribute() {
        return this.linkProducerFactoryAttribute;
    }

    public void setLinkProducerFactoryAttribute(String linkHandlerFactoryAttribute) {
        this.linkProducerFactoryAttribute = linkHandlerFactoryAttribute;
    }
}

