/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.model;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.war.model.TreeDataProvider;
import com.jaspersoft.jasperserver.war.model.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TreeHelper {
    public static TreeNode getSubtree(ExecutionContext executionContext, TreeDataProvider dataProvider, String rootUri, List prefetchedUris, int depth) {
        TreeNode root;
        if (rootUri.length() == 0) {
            rootUri = rootUri + '/';
        }
        if ((root = dataProvider.getNode(executionContext, rootUri, 0)) == null) {
            return null;
        }
        ArrayList list = new ArrayList(prefetchedUris);
        Collections.sort(list);
        MiniNode logicalTree = new MiniNode(rootUri);
        Iterator iter = list.iterator();
        block0: while (iter.hasNext()) {
            String uri = (String)iter.next();
            if (uri.indexOf(rootUri) != 0) {
                iter.remove();
                continue;
            }
            int k = rootUri.length();
            MiniNode cn = logicalTree;
            while (k < uri.length()) {
                int i = uri.indexOf(47, k);
                String cu = i >= 0 ? uri.substring(0, i) : uri;
                MiniNode n = (MiniNode)cn.getChildren().get(cu);
                if (n == null) {
                    n = new MiniNode(cu);
                    cn.getChildren().put(cu, n);
                }
                cn = n;
                if (i < 0) continue block0;
                k = i + 1;
            }
        }
        TreeHelper.processMiniNode(executionContext, dataProvider, root, logicalTree, depth);
        return root;
    }

    private static void processMiniNode(ExecutionContext executionContext, TreeDataProvider dataProvider, TreeNode root, MiniNode node, int depth) {
        List children = dataProvider.getChildren(executionContext, root.getUriString(), 0);
        if (children == null) {
            return;
        }
        ArrayList newChildren = new ArrayList(children);
        root.getChildren().clear();
        root.getChildren().addAll(newChildren);
        for (String uri : node.getChildren().keySet()) {
            List nodeChildren;
            MiniNode ch = (MiniNode)node.getChildren().get(uri);
            TreeNode cn = TreeHelper.findChildByUri(root, uri);
            if (depth > 0 && (nodeChildren = dataProvider.getChildren(executionContext, cn.getUriString(), 0)) != null) {
                cn.getChildren().addAll(nodeChildren);
            }
            if (cn == null || ch.getChildren().isEmpty()) continue;
            TreeHelper.processMiniNode(executionContext, dataProvider, cn, ch, depth);
        }
    }

    private static TreeNode findChildByUri(TreeNode parent, String uri) {
        List children = parent.getChildren();
        if (children != null) {
            for (TreeNode cn : children) {
                if (!cn.getUriString().equals(uri)) continue;
                return cn;
            }
        }
        return null;
    }

    private static class MiniNode {
        private String uri;
        private Map children = new HashMap();

        MiniNode(String uri) {
            this.uri = uri;
        }

        Map getChildren() {
            return this.children;
        }
    }
}

