/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.handlers;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class GenericTypeProcessorRegistry {
    @Autowired
    private ApplicationContext context;
    private volatile Map<Class<?>, Map<Class<?>, Object>> processors = new HashMap();

    public <T> T getTypeProcessor(Class<?> typeToProcess, Class<T> processorType) {
        return this.getTypeProcessor(typeToProcess, processorType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getTypeProcessor(Class<?> typeToProcess, Class<T> processorType, Boolean exceptionIfNotConfigured) {
        Map<Class<?>, Object> concreteProcessors = this.processors.get(processorType);
        if (concreteProcessors == null) {
            Map<Class<?>, Map<Class<?>, Object>> map = this.processors;
            synchronized (map) {
                concreteProcessors = this.processors.get(processorType);
                if (concreteProcessors == null) {
                    concreteProcessors = this.initializeProcessors(processorType);
                    this.processors.put(processorType, concreteProcessors);
                }
            }
        }
        if (exceptionIfNotConfigured.booleanValue() && !concreteProcessors.containsKey(typeToProcess)) {
            throw new IllegalStateException("Processor of type " + processorType.getName() + " for class " + typeToProcess.getName() + " not configured");
        }
        return (T)concreteProcessors.get(typeToProcess);
    }

    protected Map<Class<?>, Object> initializeProcessors(Class<?> processorType) {
        HashMap processors = new HashMap();
        String[] dataConvertersNames = this.context.getBeanNamesForType(processorType);
        if (dataConvertersNames != null && dataConvertersNames.length > 0) {
            for (String dataConverterBeanName : dataConvertersNames) {
                Object currentDataConverter = this.context.getBean(dataConverterBeanName, processorType);
                Class<?> valueClass = null;
                Type[] genericInterfaces = currentDataConverter.getClass().getGenericInterfaces();
                if (genericInterfaces != null) {
                    if (genericInterfaces.length == 0) {
                        Type genericSuperclassType;
                        Type genericSuperclass = currentDataConverter.getClass().getGenericSuperclass();
                        if (genericSuperclass instanceof ParameterizedType && (genericSuperclassType = ((ParameterizedType)genericSuperclass).getActualTypeArguments()[0]) instanceof Class) {
                            valueClass = (Class<?>)genericSuperclassType;
                        }
                    } else {
                        for (Type currentType : genericInterfaces) {
                            if (!(currentType instanceof ParameterizedType) || ((ParameterizedType)currentType).getRawType() != processorType) continue;
                            valueClass = this.getValueClass(currentType);
                        }
                    }
                }
                if (valueClass == null) {
                    throw new IllegalStateException("Unable to find generic type of bean '" + dataConverterBeanName + "' (bean class " + currentDataConverter.getClass() + ")");
                }
                processors.put(valueClass, currentDataConverter);
            }
        }
        return processors;
    }

    protected Class<?> getValueClass(Type type) {
        Class<?> valueClass = null;
        if (type instanceof ParameterizedType) {
            Type nextType = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (nextType instanceof WildcardType) {
                type = ((ParameterizedType)type).getRawType();
            } else {
                valueClass = this.getValueClass(nextType);
            }
        }
        if (type instanceof Class) {
            valueClass = (Class<?>)type;
        }
        if (type instanceof TypeVariable) {
            valueClass = this.getValueClass(((TypeVariable)type).getBounds()[0]);
        }
        return valueClass;
    }
}

