/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.metadata.common.service.PaginatedOperationResult;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.PaginationHelper;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserManagerService;
import com.jaspersoft.jasperserver.api.security.SecurityConfiguration;
import com.jaspersoft.jasperserver.war.action.BaseManagerAction;
import com.jaspersoft.jasperserver.war.action.EntitiesListManager;
import com.jaspersoft.jasperserver.war.action.EntitiesListState;
import com.jaspersoft.jasperserver.war.helper.JSONHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.context.MessageSource;
import org.springframework.util.StringUtils;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class UserManagerAction
extends BaseManagerAction {
    protected static final String UM_DEFAULT_USER = "defaultUser";
    protected static final String UM_USER_DETAILS = "userDetails";
    protected static final String UM_USER_NAME = "userName";
    protected static final String UM_USER_NAMES = "userNames";
    protected static final String UM_ROLE_NAME = "roleName";
    protected static final String UM_USER_ROLES = "userRoles";
    protected static final String UM_FIRST_RESULT = "firstResult";
    protected static final String JSON_ATTRIBUTE_USER_NAME_SEPARATOR = "userNameSeparator";
    protected static final String JSON_ATTRIBUTE_USER_NAME_NOT_SUPPORTED_SYMBOLS = "userNameNotSupportedSymbols";
    protected static final String JSON_ATTRIBUTE_USER_DEFAULT_ROLE = "userDefaultRole";
    protected static final String JSON_ATTRIBUTE_USER_PASSWORD_MASK = "passwordMask";
    private UserManagerService managerService;

    protected MessageSource getMessages() {
        return this.messages;
    }

    protected JSONHelper getJsonHelper() {
        return this.jsonHelper;
    }

    public void setManagerService(UserManagerService managerService) {
        this.managerService = managerService;
    }

    public Event initEvent(RequestContext context) throws Exception {
        this.initState(context);
        JSONObject jsonConfiguration = new JSONObject();
        jsonConfiguration.put(JSON_ATTRIBUTE_USER_NAME_NOT_SUPPORTED_SYMBOLS, (Object)this.configuration.getUserNameNotSupportedSymbols());
        jsonConfiguration.put(JSON_ATTRIBUTE_USER_NAME_SEPARATOR, (Object)this.configuration.getUserNameSeparator());
        jsonConfiguration.put(JSON_ATTRIBUTE_USER_DEFAULT_ROLE, (Object)this.configuration.getDefaultRole());
        jsonConfiguration.put(JSON_ATTRIBUTE_USER_PASSWORD_MASK, (Object)this.configuration.getPasswordMask());
        jsonConfiguration.put("superuserRole", (Object)"ROLE_SUPERUSER");
        jsonConfiguration.put("adminRole", (Object)"ROLE_ADMINISTRATOR");
        context.getFlowScope().put("configuration", (Object)jsonConfiguration.toString());
        context.getFlowScope().put(UM_DEFAULT_USER, (Object)this.getDefaultEntity(context));
        context.getFlowScope().put("defaultEntity", (Object)this.getDefaultEntity(context));
        context.getFlowScope().put("signedUser", (Object)this.getCurrentUser());
        context.getFlowScope().put("currentUserRoles", (Object)this.jsonHelper.convertRoleListToJson(this.getCurrentUserRoles(), null).toString());
        return this.success();
    }

    @Override
    public Event next(RequestContext context) {
        String responseModel;
        BaseManagerAction.State state = this.getState(context);
        final EntitiesListState entitiesState = state.getEntitiesState();
        try {
            final Set<String> tenantIdSet = this.getSubTenantIdsSet(state.getTenantId());
            List users = this.getEntitiesAndUpdateState(entitiesState, this.configuration.getRoleItemsPerPage(), new EntitiesListManager(){

                @Override
                public int getResultsCount() {
                    return UserManagerAction.this.userService.getTenantUsersCount(null, tenantIdSet, entitiesState.getText());
                }

                @Override
                public List getResults(int resultIndex, int maxResults) {
                    return UserManagerAction.this.userService.getTenantUsers(null, tenantIdSet, entitiesState.getText(), resultIndex, maxResults);
                }
            });
            JSONObject usersJson = this.jsonHelper.createUsersResponseJson(users);
            responseModel = this.jsonHelper.createDataResponseModel(usersJson);
        }
        catch (Exception e) {
            try {
                responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    @Override
    public Event getDetails(RequestContext context) {
        String responseModel;
        BaseManagerAction.State state = this.getState(context);
        String userName = state.getSelectedEntity();
        try {
            User user = this.userService.getUser(null, userName);
            if (user == null) {
                throw new IllegalArgumentException("Cannot find user with username : " + userName);
            }
            JSONObject usersJson = this.jsonHelper.convertUserToJson(user, null);
            responseModel = this.jsonHelper.createDataResponseModel(usersJson);
        }
        catch (Exception e) {
            try {
                responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    @Override
    public Event nextAssigned(RequestContext context) {
        String responseModel;
        final BaseManagerAction.State state = this.getState(context);
        final EntitiesListState entitiesState = state.getAssignedEntitiesState();
        try {
            List roles = this.getEntitiesAndUpdateState(entitiesState, this.configuration.getEntitiesPerPage(), new EntitiesListManager(){

                @Override
                public int getResultsCount() {
                    return UserManagerAction.this.userService.getAssignedRolesCount(null, state.getSelectedEntity(), entitiesState.getText());
                }

                @Override
                public List getResults(int resultIndex, int maxResults) {
                    return UserManagerAction.this.userService.getAssignedRoles(null, state.getSelectedEntity(), entitiesState.getText(), resultIndex, maxResults);
                }
            });
            JSONObject rolesJson = this.jsonHelper.createRolesResponseJson(roles);
            responseModel = this.jsonHelper.createDataResponseModel(rolesJson);
        }
        catch (Exception e) {
            try {
                responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    @Override
    public Event nextAvailable(RequestContext context) {
        String responseModel;
        final BaseManagerAction.State state = this.getState(context);
        final EntitiesListState entitiesState = state.getAvailableEntitiesState();
        try {
            List roles = this.getEntitiesAndUpdateState(entitiesState, this.configuration.getEntitiesPerPage(), new EntitiesListManager(){

                @Override
                public int getResultsCount() {
                    return UserManagerAction.this.userService.getAvailableRolesCount(null, state.getSelectedEntity(), entitiesState.getText());
                }

                @Override
                public List getResults(int resultIndex, int maxResults) {
                    return UserManagerAction.this.userService.getAvailableRoles(null, state.getSelectedEntity(), entitiesState.getText(), resultIndex, maxResults);
                }
            });
            JSONObject rolesJson = this.jsonHelper.createRolesResponseJson(roles);
            responseModel = this.jsonHelper.createDataResponseModel(rolesJson);
        }
        catch (Exception e) {
            try {
                responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    @Override
    public Event exist(RequestContext context) {
        String responseModel;
        String userName = this.getParameter(context, "entityName");
        try {
            User user = this.userService.getUser(null, userName);
            JSONObject existJson = this.jsonHelper.createExistJson(user != null);
            responseModel = this.jsonHelper.createDataResponseModel(existJson);
        }
        catch (Exception e) {
            try {
                responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    @Override
    public Event delete(RequestContext context) {
        String responseModel;
        String userName = this.getParameter(context, "entity");
        try {
            responseModel = this.jsonHelper.createSuccessResponseModel();
        }
        catch (JSONException e) {
            return this.error((Exception)((Object)e));
        }
        try {
            if (userName.length() <= 0) {
                throw new IllegalArgumentException("Username is empty.");
            }
            this.createAuditEvent("deleteUser");
            this.userService.deleteUser(null, userName);
            this.closeAuditEvent("deleteUser");
        }
        catch (Exception e) {
            try {
                responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    @Override
    public Event deleteAll(RequestContext context) {
        String responseModel;
        try {
            responseModel = this.jsonHelper.createSuccessResponseModel();
        }
        catch (JSONException e) {
            return this.error((Exception)((Object)e));
        }
        try {
            List<String> userNames = this.getEntities(context);
            if (userNames.size() <= 0) {
                throw new IllegalArgumentException("Username is empty.");
            }
            this.createAuditEvent("deleteAllUsers");
            this.managerService.deleteAll(null, userNames);
            this.closeAuditEvent("deleteAllUsers");
        }
        catch (Exception e) {
            try {
                responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    @Override
    public Event create(RequestContext context) {
        String responseModel;
        try {
            responseModel = this.jsonHelper.createSuccessResponseModel();
        }
        catch (JSONException e) {
            return this.error((Exception)((Object)e));
        }
        try {
            User user;
            String userJson = this.getParameter(context, "entity");
            if (SecurityConfiguration.isEncryptionOn()) {
                MutableAttributeMap attributeMap = context.getExternalContext().getRequestMap();
                List decryptedJsonList = (List)attributeMap.get("DECRYPTED.entity");
                if (decryptedJsonList != null && decryptedJsonList.size() > 0) {
                    userJson = decryptedJsonList.get(0).toString();
                } else {
                    throw new Exception("Expected a decrypted password in request attribute, but found none");
                }
            }
            if (userJson != null && userJson.length() > 0) {
                Tenant tenant;
                user = this.jsonHelper.convertJsonToUser(userJson);
                if (user.getTenantId() != null && (tenant = this.tenantService.getTenant(null, user.getTenantId())) == null) {
                    throw new IllegalArgumentException("Cannot find organization with id : " + user.getTenantId());
                }
            } else {
                throw new IllegalAccessException("Error when creating user");
            }
            user.setPreviousPasswordChangeTime(new Date());
            this.createAuditEvent("createUser");
            this.userService.putUser(null, user);
            this.closeAuditEvent("createUser");
        }
        catch (Exception e) {
            try {
                responseModel = this.createUnexpectedExceptionResponseModel(e);
            }
            catch (JSONException e1) {
                return this.error((Exception)((Object)e1));
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    public Event enableAll(RequestContext context) throws Exception {
        List<String> userNames = this.getUserNames(context);
        String responseModel = this.jsonHelper.createSuccessResponseModel();
        try {
            if (userNames.size() <= 0) {
                throw new IllegalArgumentException("Username is empty.");
            }
            this.createAuditEvent("enableAllUsers");
            this.managerService.enableAll(null, userNames);
            this.closeAuditEvent("enableAllUsers");
        }
        catch (Exception e) {
            responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    public Event disableAll(RequestContext context) throws Exception {
        List<String> userNames = this.getUserNames(context);
        String responseModel = this.jsonHelper.createSuccessResponseModel();
        try {
            if (userNames.size() <= 0) {
                throw new IllegalArgumentException("Username is empty.");
            }
            this.createAuditEvent("disableAllUsers");
            this.managerService.disableAll(null, userNames);
            this.closeAuditEvent("disableAllUsers");
        }
        catch (Exception e) {
            responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    public Event updateUser(RequestContext context) throws Exception {
        String responseModel;
        block9: {
            try {
                responseModel = this.jsonHelper.createSuccessResponseModel();
            }
            catch (JSONException e) {
                return this.error((Exception)((Object)e));
            }
            try {
                String userJson = this.getParameter(context, "entity");
                if (SecurityConfiguration.isEncryptionOn()) {
                    MutableAttributeMap attributeMap = context.getExternalContext().getRequestMap();
                    List decryptedJsonList = (List)attributeMap.get("DECRYPTED.entity");
                    if (decryptedJsonList != null && decryptedJsonList.size() > 0) {
                        userJson = decryptedJsonList.get(0).toString();
                    } else {
                        throw new Exception("Expected a decrypted password in request attribute, but found none");
                    }
                }
                String userName = this.getParameter(context, "entityName");
                String assignedJson = this.getParameter(context, "assignedEntities");
                String unassignedJson = this.getParameter(context, "unassignedEntities");
                if (userJson == null || userJson.length() <= 0) break block9;
                User user = this.jsonHelper.convertJsonToUser(userJson);
                Set<Role> assigned = this.jsonHelper.convertJsonArrayToRoles(assignedJson);
                Set<Role> unassigned = this.jsonHelper.convertJsonArrayToRoles(unassignedJson);
                if (user != null && StringUtils.hasText((String)user.getUsername())) {
                    if (!StringUtils.hasText((String)user.getPassword())) {
                        user.setPassword(null);
                    }
                    this.createAuditEvent("updateUser");
                    this.managerService.updateUser(null, userName, user, assigned, unassigned);
                    this.closeAuditEvent("updateUser");
                    User userLookedup = this.userService.getUser(null, userName);
                    JSONObject usersJson = this.jsonHelper.convertUserToJson(userLookedup, null);
                    responseModel = this.jsonHelper.createDataResponseModel(usersJson);
                    break block9;
                }
                throw new IllegalArgumentException("Error when updating user details.");
            }
            catch (Exception e) {
                responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
            }
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    private String getOldUserPassword(String userName) {
        User user = this.userService.getUser(null, userName);
        return user.getPassword();
    }

    public Event getAvailableRoles(RequestContext context) throws Exception {
        String responseModel;
        final String userName = this.getUserName(context, false);
        final String roleName = this.getRoleName(context);
        final Set userRoles = this.getUserRoles(context);
        int firstResult = this.getFirstResult(context);
        int maxResults = 10;
        try {
            PaginatedOperationResult result = PaginationHelper.paginatedGetOperationResult((int)firstResult, (int)maxResults, (PaginationHelper.JasperService)new PaginationHelper.JasperService(){

                public List getResultList(int firstResult, int maxResults) {
                    return UserManagerAction.this.userService.getAvailableRoles(null, roleName, userRoles, userName, firstResult, maxResults);
                }

                public int getResultCount() {
                    return UserManagerAction.this.userService.getAvailableRolesCount(null, roleName, userRoles, userName);
                }
            });
            List roles = result.getResult();
            int rolesCount = result.getTotalResults();
            JSONObject rolesJson = this.jsonHelper.createRolesResponseJson(roles);
            responseModel = this.jsonHelper.createDataResponseModel(rolesJson);
        }
        catch (Exception e) {
            responseModel = this.createUnexpectedExceptionResponseModel(e.getMessage());
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)responseModel);
        return this.success();
    }

    public String hidePassword(String password) {
        return password == null ? password : password.replaceAll(".", this.configuration.getPasswordMask());
    }

    private String getUserJson(RequestContext context) {
        return context.getRequestParameters().get(UM_USER_DETAILS);
    }

    private List<String> getUserNames(RequestContext context) throws JSONException {
        ArrayList<String> userNames = new ArrayList<String>();
        String json = context.getRequestParameters().get(UM_USER_NAMES);
        if (json != null) {
            JSONArray array = new JSONArray(json);
            for (int i = 0; i < array.length(); ++i) {
                userNames.add(array.getString(i));
            }
        }
        return userNames;
    }

    private String getUserName(RequestContext context, boolean decode) {
        String name = decode ? this.getDecodedRequestParameter(context, UM_USER_NAME) : context.getRequestParameters().get(UM_USER_NAME);
        return name != null ? name : "";
    }

    private String getRoleName(RequestContext context) {
        String name = this.getDecodedRequestParameter(context, UM_ROLE_NAME);
        return name != null ? name : "";
    }

    private Set getUserRoles(RequestContext context) throws Exception {
        String userRolesParam = this.getDecodedRequestParameter(context, UM_USER_ROLES);
        HashSet<String> userRoles = new HashSet<String>();
        if (userRolesParam != null && userRolesParam.length() > 0) {
            JSONArray userRolesArray = new JSONArray(userRolesParam);
            for (int i = 0; i < userRolesArray.length(); ++i) {
                userRoles.add(userRolesArray.getString(i));
            }
        }
        return userRoles;
    }

    private int getFirstResult(RequestContext context) {
        String firstResult = this.getDecodedRequestParameter(context, UM_FIRST_RESULT);
        return firstResult != null ? Integer.valueOf(firstResult) : 0;
    }
}

