/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValuesItem;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ListOfValuesItemImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.ListOfValuesDTO;
import com.jaspersoft.jasperserver.war.validation.ListOfValuesValidator;
import java.beans.PropertyEditor;
import java.util.Arrays;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class ListOfValuesAction
extends FormAction {
    private static final String ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS = "resourceIdNotSupportedSymbols";
    private static final String FORM_OBJECT_KEY = "listOfValuesDTO";
    private static final String LISTOFVALUES_ATTR = "listOfValues";
    private static final String PARENT_FOLDER_ATTR = "parentFolder";
    private static final String IS_EDIT = "isEdit";
    private RepositoryService repository;
    private ConfigurationBean configuration;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        binder.registerCustomEditor(byte[].class, (PropertyEditor)new ByteArrayMultipartFileEditor());
    }

    public ListOfValuesAction() {
        this.setFormObjectClass(ListOfValuesDTO.class);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
        this.setValidator(new ListOfValuesValidator());
    }

    public Event lovList(RequestContext context) {
        ResourceLookup[] resources = this.repository.findResource(JasperServerUtil.getExecutionContext(context), FilterCriteria.createFilter(ListOfValues.class));
        context.getRequestScope().put("resources", Arrays.asList(resources));
        return this.success();
    }

    public Event setupEditForm(RequestContext context) throws Exception {
        MutableAttributeMap rs = context.getRequestScope();
        rs.put("folders", (Object)this.repository.getAllFolders(null));
        rs.put(FORM_OBJECT_KEY, this.getFormObject(context));
        context.getFlowScope().put(ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS, (Object)this.configuration.getResourceIdNotSupportedSymbols());
        return this.success();
    }

    public Object createFormObject(RequestContext context) {
        ListOfValuesDTO listOfValuesDTO;
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        String isEdit = (String)context.getFlowScope().get(IS_EDIT);
        if (isEdit == null) {
            isEdit = context.getRequestParameters().get(IS_EDIT);
            context.getFlowScope().put(IS_EDIT, (Object)isEdit);
        }
        if (isEdit != null) {
            ListOfValues listOfValues;
            String currentDataType = (String)context.getFlowScope().get(LISTOFVALUES_ATTR);
            if (currentDataType == null) {
                currentDataType = context.getRequestParameters().get("resource");
                context.getFlowScope().put(LISTOFVALUES_ATTR, (Object)currentDataType);
            }
            if ((listOfValues = (ListOfValues)this.repository.getResource((ExecutionContext)executionContext, currentDataType)) == null) {
                context.getFlowScope().remove("prevForm");
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{currentDataType});
            }
            listOfValuesDTO = new ListOfValuesDTO(listOfValues);
            listOfValuesDTO.setMode((byte)2);
        } else {
            ListOfValues listOfValues = (ListOfValues)this.repository.newResource((ExecutionContext)executionContext, ListOfValues.class);
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (parentFolder == null) {
                parentFolder = context.getRequestParameters().get("ParentFolderUri");
                context.getFlowScope().put(PARENT_FOLDER_ATTR, (Object)parentFolder);
            }
            if (parentFolder == null || parentFolder.trim().length() == 0) {
                parentFolder = "/";
            }
            listOfValues.setParentFolder(parentFolder);
            listOfValuesDTO = new ListOfValuesDTO(listOfValues);
            listOfValuesDTO.setMode((byte)1);
        }
        return listOfValuesDTO;
    }

    public Event addLovItem(RequestContext context) throws Exception {
        ListOfValuesDTO listOfValuesDTO = (ListOfValuesDTO)this.getFormObject(context);
        ListOfValues listOfValues = listOfValuesDTO.getListOfValues();
        ListOfValuesItemImpl item = new ListOfValuesItemImpl();
        item.setLabel(listOfValuesDTO.getNewLabel());
        item.setValue((Object)listOfValuesDTO.getNewValue());
        boolean exists = false;
        ListOfValuesItem[] values = listOfValues.getValues();
        for (int i = 0; i < values.length && !exists; ++i) {
            if (!values[i].getLabel().equals(item.getLabel())) continue;
            exists = true;
            values[i].setValue(item.getValue());
        }
        if (!exists) {
            listOfValues.addValue((ListOfValuesItem)item);
        }
        listOfValuesDTO.setNewLabel(null);
        listOfValuesDTO.setNewValue(null);
        return this.success();
    }

    public Event removeLovItem(RequestContext context) throws Exception {
        String[] items;
        ListOfValuesDTO listOfValuesDTO = (ListOfValuesDTO)this.getFormObject(context);
        ListOfValues listOfValues = listOfValuesDTO.getListOfValues();
        try {
            items = context.getRequestParameters().getArray("itemToDelete");
        }
        catch (IllegalArgumentException e) {
            items = new String[]{context.getRequestParameters().get("itemToDelete")};
        }
        if (items != null && items[0] != null) {
            ListOfValuesItem[] values = listOfValues.getValues();
            block2: for (int i = 0; i < values.length; ++i) {
                for (int j = 0; j < items.length; ++j) {
                    if (!values[i].getLabel().equals(items[j])) continue;
                    listOfValues.removeValue(values[i]);
                    continue block2;
                }
            }
        }
        return this.success();
    }

    public Event writeLov(RequestContext context) throws Exception {
        ListOfValuesDTO listOfValuesDTO = (ListOfValuesDTO)this.getFormObject(context);
        if (listOfValuesDTO.isStandAloneMode()) {
            try {
                this.repository.saveResource(null, (Resource)listOfValuesDTO.getListOfValues());
                return this.yes();
            }
            catch (JSDuplicateResourceException e) {
                this.getFormErrors(context).rejectValue("listOfValues.name", "ListOfValuesValidator.error.duplicate");
                return this.error();
            }
        }
        return this.success();
    }
}

