/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.dto.DataTypeWrapper;
import com.jaspersoft.jasperserver.war.util.CalendarFormatProvider;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.util.Date;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.DataBinder;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class EditDataTypeAction
extends FormAction {
    private static final String ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS = "resourceIdNotSupportedSymbols";
    private static final String FORM_OBJECT_KEY = "dataType";
    private static final String PARENT_FOLDER_ATTR = "parentFolder";
    private static final String CURRENT_DATATYPE_ATTR = "currentDataType";
    private static final String IS_EDIT = "isEdit";
    private RepositoryService repository;
    private CalendarFormatProvider calendarFormatProvider;
    protected MessageSource messages;
    private ConfigurationBean configuration;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        binder.registerCustomEditor(byte[].class, (PropertyEditor)new ByteArrayMultipartFileEditor());
    }

    public EditDataTypeAction() {
        this.setFormObjectClass(DataTypeWrapper.class);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public Object createFormObject(RequestContext context) {
        DataTypeWrapper wrapper;
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        String isEdit = (String)context.getFlowScope().get(IS_EDIT);
        if (isEdit == null) {
            isEdit = context.getRequestParameters().get(IS_EDIT);
            context.getFlowScope().put(IS_EDIT, (Object)isEdit);
        }
        if (isEdit != null) {
            DataType dataType;
            String currentDataType = (String)context.getFlowScope().get(CURRENT_DATATYPE_ATTR);
            if (currentDataType == null) {
                currentDataType = context.getRequestParameters().get("resource");
                context.getFlowScope().put(CURRENT_DATATYPE_ATTR, (Object)currentDataType);
            }
            if ((dataType = (DataType)this.repository.getResource((ExecutionContext)executionContext, currentDataType)) == null) {
                context.getFlowScope().remove("prevForm");
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{currentDataType});
            }
            wrapper = new DataTypeWrapper(dataType);
            wrapper.setMode((byte)2);
            byte type = dataType.getType();
            if (type == 3 || type == 4) {
                DateFormat df = this.getFormat(type);
                if (dataType.getMinValue() != null) {
                    wrapper.setMinValueText(df.format((Date)dataType.getMinValue()));
                }
                if (dataType.getMaxValue() != null) {
                    wrapper.setMaxValueText(df.format((Date)dataType.getMaxValue()));
                }
            }
        } else {
            DataType dataType = (DataType)this.repository.newResource((ExecutionContext)executionContext, DataType.class);
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (parentFolder == null) {
                parentFolder = context.getRequestParameters().get("ParentFolderUri");
                context.getFlowScope().put(PARENT_FOLDER_ATTR, (Object)parentFolder);
            }
            if (parentFolder == null || parentFolder.trim().length() == 0) {
                parentFolder = "/";
            }
            dataType.setParentFolder(parentFolder);
            wrapper = new DataTypeWrapper(dataType);
            wrapper.setMode((byte)1);
            FilterCriteria criteria = FilterCriteria.createFilter();
            criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)parentFolder));
            ResourceLookup[] allDataTypes = this.repository.findResource((ExecutionContext)executionContext, criteria);
            wrapper.setAllDataTypes(allDataTypes);
        }
        return wrapper;
    }

    public Event saveDataType(RequestContext context) throws Exception {
        DataTypeWrapper wrapper = (DataTypeWrapper)this.getFormObject(context);
        DataType dataType = wrapper.getDataType();
        switch (dataType.getType()) {
            case 3: {
                String minValue = wrapper.getMinValueText();
                String maxValue = wrapper.getMaxValueText();
                DateFormat dateFormat = this.getCalendarFormatProvider().getDateFormat();
                if (minValue != null && minValue.length() > 0) {
                    dataType.setMinValue((Comparable)dateFormat.parse(minValue));
                }
                if (maxValue == null || maxValue.length() <= 0) break;
                dataType.setMaxValue((Comparable)dateFormat.parse(maxValue));
                break;
            }
            case 4: {
                String minValue = wrapper.getMinValueText();
                String maxValue = wrapper.getMaxValueText();
                DateFormat dateFormat = this.getCalendarFormatProvider().getDatetimeFormat();
                if (minValue != null && minValue.length() > 0) {
                    dataType.setMinValue((Comparable)dateFormat.parse(minValue));
                }
                if (maxValue == null || maxValue.length() <= 0) break;
                dataType.setMaxValue((Comparable)dateFormat.parse(maxValue));
            }
        }
        if (wrapper.isStandAloneMode()) {
            try {
                this.repository.saveResource(null, (Resource)wrapper.getDataType());
                if (!wrapper.isEditMode()) {
                    context.getExternalContext().getSessionMap().put("repositorySystemConfirm", (Object)this.messages.getMessage("resource.dataType.dataTypeAdded", (Object[])new String[]{wrapper.getDataType().getName(), wrapper.getDataType().getParentFolder()}, LocaleContextHolder.getLocale()));
                }
                return this.yes();
            }
            catch (JSDuplicateResourceException e) {
                this.getFormErrors(context).rejectValue("dataType.name", "DataTypeValidator.error.duplicate");
                return this.error();
            }
        }
        return this.success();
    }

    public Event setupEditForm(RequestContext context) throws Exception {
        MutableAttributeMap rs = context.getRequestScope();
        rs.put(FORM_OBJECT_KEY, this.getFormObject(context));
        context.getFlowScope().put(ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS, (Object)this.configuration.getResourceIdNotSupportedSymbols());
        return this.success();
    }

    public CalendarFormatProvider getCalendarFormatProvider() {
        return this.calendarFormatProvider;
    }

    public void setCalendarFormatProvider(CalendarFormatProvider calendarFormatProvider) {
        this.calendarFormatProvider = calendarFormatProvider;
    }

    private DateFormat getFormat(byte type) {
        if (type == 3) {
            return this.getCalendarFormatProvider().getDateFormat();
        }
        return this.getCalendarFormatProvider().getDatetimeFormat();
    }
}

