/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security;

import com.jaspersoft.jasperserver.api.security.validators.Validator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.servlet.LocaleResolver;

public class WebAppSecurityFilter
implements Filter {
    private static final Logger LOG = Logger.getLogger(WebAppSecurityFilter.class);
    private static final String AJAX_REQUEST = "AJAXRequest";
    private static final String AJAX_REQUEST_HEADER_FLAG = "x-requested-with";
    private static final String ERR_MSG_INPUT_VALIDATION = "message.validation.input";
    private static final String AJAX_RESPONSE_HEADER = "JasperServerError";
    private static final String AJAX_RESPONSE_HEADER_STATUS = "true";
    private static final String ERR_PAGE_MSG_KEY = "stacktrace";
    private FilterConfig filterConfig = null;
    private MessageSource messages;
    private String redirectUrl;
    private LocaleResolver localeResolver;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        LocaleContextHolder.setLocale((Locale)this.localeResolver.resolveLocale(httpRequest));
        if (!Validator.validateRequestParams(httpRequest)) {
            this.processInvalidRequest(httpRequest, httpResponse);
        } else {
            filterChain.doFilter((ServletRequest)httpRequest, response);
        }
    }

    private void processInvalidRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOG.warn((Object)("Request " + request.getRequestURL() + " was deemed invalid."));
        if (this.isAJAXRequest(request)) {
            this.sendTextOnly(response);
        } else {
            this.sendErrorRedirect(request, response);
        }
    }

    private boolean isAJAXRequest(HttpServletRequest request) {
        return request.getHeader(AJAX_REQUEST_HEADER_FLAG) != null;
    }

    private void sendErrorRedirect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(true);
        session.setAttribute(ERR_PAGE_MSG_KEY, (Object)this.messages.getMessage(ERR_MSG_INPUT_VALIDATION, new Object[0], LocaleContextHolder.getLocale()));
        response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + this.redirectUrl));
    }

    private void sendTextOnly(HttpServletResponse response) {
        response.setHeader(AJAX_RESPONSE_HEADER, AJAX_RESPONSE_HEADER_STATUS);
        PrintWriter out = null;
        try {
            out = response.getWriter();
            out.write(this.messages.getMessage(ERR_MSG_INPUT_VALIDATION, new Object[0], LocaleContextHolder.getLocale()));
            out.close();
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe);
        }
    }

    public MessageSource getMessages() {
        return this.messages;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public LocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    public void setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }
}

