/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.service.PaginatedOperationResult;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.PaginationHelper;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.RoleManagerService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class RoleManagerServiceImpl
extends HibernateDaoImpl
implements RoleManagerService {
    protected static final Log log = LogFactory.getLog(RoleManagerServiceImpl.class);
    private AbstractPlatformTransactionManager transactionManager;
    private UserAuthorityService userService;

    public void setTransactionManager(AbstractPlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaginatedOperationResult getUsersWithoutRole(final ExecutionContext context, final String roleName, final String userName, Set assignedUserNameSet, Set unassignedUserNameSet, int firstResult, int maxResults) {
        PaginatedOperationResult result;
        TransactionStatus transaction = null;
        try {
            transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition(3));
            this.userService.assignUsers(context, roleName, assignedUserNameSet);
            this.userService.unassignUsers(context, roleName, unassignedUserNameSet);
            this.getHibernateTemplate().flush();
            result = PaginationHelper.paginatedGetOperationResult(firstResult, maxResults, new PaginationHelper.JasperService(){

                @Override
                public List getResultList(int firstResult, int maxResults) {
                    return RoleManagerServiceImpl.this.userService.getUsersWithoutRole(context, roleName, userName, firstResult, maxResults);
                }

                @Override
                public int getResultCount() {
                    return RoleManagerServiceImpl.this.userService.getUsersCountWithoutRole(context, roleName, userName);
                }
            });
        }
        finally {
            if (transaction != null && !transaction.isCompleted()) {
                try {
                    this.transactionManager.rollback(transaction);
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaginatedOperationResult getUsersWithRole(final ExecutionContext context, final String roleName, final String userName, Set assignedUserNameSet, Set unassignedUserNameSet, int firstResult, int maxResults) {
        PaginatedOperationResult result;
        TransactionStatus transaction = null;
        try {
            transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition(3));
            this.userService.assignUsers(context, roleName, assignedUserNameSet);
            this.userService.unassignUsers(context, roleName, unassignedUserNameSet);
            this.getHibernateTemplate().flush();
            result = PaginationHelper.paginatedGetOperationResult(firstResult, maxResults, new PaginationHelper.JasperService(){

                @Override
                public List getResultList(int firstResult, int maxResults) {
                    return RoleManagerServiceImpl.this.userService.getUsersWithRole(context, roleName, userName, firstResult, maxResults);
                }

                @Override
                public int getResultCount() {
                    return RoleManagerServiceImpl.this.userService.getUsersCountWithRole(context, roleName, userName);
                }
            });
        }
        finally {
            if (transaction != null && !transaction.isCompleted()) {
                try {
                    this.transactionManager.rollback(transaction);
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void updateRole(ExecutionContext context, String roleName, Role roleDetails, Set<User> assignedUserSet, Set<User> unassignedUserSet) {
        this.userService.assignUsers(context, roleName, this.toNameSet(assignedUserSet));
        this.userService.unassignUsers(context, roleName, this.toNameSet(unassignedUserSet));
        this.userService.updateRole(null, roleName, roleDetails);
    }

    protected Set<String> toNameSet(Set<User> users) {
        HashSet<String> names = new HashSet<String>();
        for (User user : users) {
            names.add(user.getUsername());
        }
        return names;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void deleteAll(ExecutionContext context, List<String> roles) {
        if (roles != null) {
            for (String roleName : roles) {
                if (roleName == null || roleName.length() <= 0) continue;
                this.userService.deleteRole(context, roleName);
            }
        }
    }
}

