/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.security;

import java.util.LinkedHashMap;
import java.util.Set;
import org.springframework.security.acl.basic.AclObjectIdentity;
import org.springframework.security.acl.basic.SimpleAclEntry;

public class JasperServerAclEntry
extends SimpleAclEntry {
    public static final int EXECUTE = (int)Math.pow(2.0, 5.0);
    private static final int[] VALID_PERMISSIONS = new int[]{0, ADMINISTRATION, READ, WRITE, CREATE, DELETE, READ_WRITE_CREATE_DELETE, READ_WRITE_CREATE, READ_WRITE, READ_WRITE_DELETE, EXECUTE};
    private static final String[] VALID_PERMISSIONS_AS_STRING = new String[]{"NOTHING", "ADMINISTRATION", "READ", "WRITE", "CREATE", "DELETE", "READ_WRITE_CREATE_DELETE", "READ_WRITE_CREATE", "READ_WRITE", "READ_WRITE_DELETE", "EXECUTE"};

    public JasperServerAclEntry() {
    }

    public JasperServerAclEntry(Object recipient, AclObjectIdentity aclObjectIdentity, AclObjectIdentity aclObjectParentIdentity, int mask) {
        super(recipient, aclObjectIdentity, aclObjectParentIdentity, mask);
    }

    public int[] getValidPermissions() {
        return (int[])VALID_PERMISSIONS.clone();
    }

    public String printPermissionsBlock(int i) {
        StringBuffer sb = new StringBuffer();
        if (this.isPermitted(i, ADMINISTRATION)) {
            sb.append('A');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, READ)) {
            sb.append('R');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, WRITE)) {
            sb.append('W');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, CREATE)) {
            sb.append('C');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, DELETE)) {
            sb.append('D');
        } else {
            sb.append('-');
        }
        if (this.isPermitted(i, EXECUTE)) {
            sb.append('X');
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public int printPermissionsOverlappingBlock(Set<Integer> permissionMasks) {
        int overlapPermission = 0;
        LinkedHashMap<Integer, Character> mainPermissions = new LinkedHashMap<Integer, Character>();
        mainPermissions.put(ADMINISTRATION, Character.valueOf('A'));
        mainPermissions.put(READ, Character.valueOf('R'));
        mainPermissions.put(WRITE, Character.valueOf('W'));
        mainPermissions.put(CREATE, Character.valueOf('C'));
        mainPermissions.put(DELETE, Character.valueOf('D'));
        mainPermissions.put(EXECUTE, Character.valueOf('X'));
        block0: for (Integer mainPermissionKey : mainPermissions.keySet()) {
            for (Integer permissionMask : permissionMasks) {
                if (!this.isPermitted(permissionMask, mainPermissionKey)) continue;
                overlapPermission += mainPermissionKey.intValue();
                continue block0;
            }
        }
        return overlapPermission;
    }

    public static int parsePermission(String permission) {
        for (int i = 0; i < VALID_PERMISSIONS_AS_STRING.length; ++i) {
            if (!VALID_PERMISSIONS_AS_STRING[i].equalsIgnoreCase(permission)) continue;
            return VALID_PERMISSIONS[i];
        }
        throw new IllegalArgumentException("Permission provided does not exist: " + permission);
    }
}

