/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.util;

import com.jaspersoft.jasperserver.api.metadata.common.util.RepositoryFileName;
import com.jaspersoft.jasperserver.api.metadata.common.util.RepositoryFileNameParser;
import com.jaspersoft.jasperserver.api.metadata.common.util.RepositoryFileSystem;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileProvider;
import org.apache.commons.vfs.provider.FileNameParser;
import org.apache.commons.vfs.provider.res.ResourceFileSystemConfigBuilder;

public class RepositoryFileProvider
extends AbstractFileProvider {
    public static final String REPOSITORY_SCHEME = "repo";
    protected static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.READ_CONTENT, Capability.URI));

    public RepositoryFileProvider() {
        this.setFileNameParser((FileNameParser)new RepositoryFileNameParser(this.getScheme()));
    }

    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        RepositoryFileName rootName = new RepositoryFileName(this.getScheme(), null, FileType.FOLDER);
        FileSystem fs = this.findFileSystem((Comparable)rootName.getRoot(), fileSystemOptions);
        if (fs == null) {
            fs = new RepositoryFileSystem(this.getScheme(), (FileName)rootName, fileSystemOptions);
            this.addFileSystem((Comparable)rootName.getRoot(), fs);
        }
        FileObject result = fs.resolveFile(uri);
        return result;
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return ResourceFileSystemConfigBuilder.getInstance();
    }

    public Collection getCapabilities() {
        return capabilities;
    }

    public String getScheme() {
        return REPOSITORY_SCHEME;
    }
}

