/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util;

import com.jaspersoft.jasperserver.api.JSException;

public class RepositoryUtils {
    public static String getParentPath(String path) {
        if (path.equals("/")) {
            return null;
        }
        int lastSep = path.lastIndexOf("/");
        if (lastSep < 0) {
            throw new JSException("Path " + path + " is not an absolute repository path");
        }
        String parentPath = lastSep == 0 ? "/" : path.substring(0, lastSep);
        return parentPath;
    }

    public static String getName(String path) {
        if (path.equals("/")) {
            return "/";
        }
        int lastSep = path.lastIndexOf("/");
        if (lastSep < 0) {
            throw new JSException("Path " + path + " is not an absolute repository path");
        }
        return path.substring(lastSep + 1);
    }

    public static String concatenatePath(String parentPath, String name) {
        StringBuffer concantenated = new StringBuffer(parentPath);
        if (!parentPath.equals("/")) {
            concantenated.append("/");
        }
        concantenated.append(name);
        return concantenated.toString();
    }

    public static String concatenatePaths(String parentPath, String path) {
        StringBuffer concantenated = new StringBuffer();
        if (parentPath.equals("/")) {
            concantenated.append(path);
        } else {
            concantenated.append(parentPath);
            if (!path.equals("/")) {
                concantenated.append(path);
            }
        }
        return concantenated.toString();
    }

    public static boolean isAncestorOrEqual(String ancestorPath, String path) {
        if (ancestorPath.equals(path)) {
            return true;
        }
        if (!path.startsWith(ancestorPath)) {
            return false;
        }
        return "/".equals(ancestorPath) || path.substring(ancestorPath.length()).startsWith("/");
    }
}

