/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.RepoManager;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoFolder;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResourceBase;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.transform.impl.InterceptFieldCallback;
import net.sf.cglib.transform.impl.InterceptFieldEnabled;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RepoResource
extends RepoResourceBase
implements InterceptFieldEnabled {
    private transient InterceptFieldCallback $CGLIB_READ_WRITE_CALLBACK;
    private static final Log log;
    public static final String CLIENT_OPTION_FULL_DATA = "fullData";
    public static final String CLIENT_OPTION_AS_NEW = "asNew";
    private static final ThreadLocal clientOptions;
    private RepoFolder childrenFolder;
    private Set newChildren;

    public InterceptFieldCallback getInterceptFieldCallback() {
        return this.$CGLIB_READ_WRITE_CALLBACK;
    }

    public void setInterceptFieldCallback(InterceptFieldCallback interceptFieldCallback) {
        this.$CGLIB_READ_WRITE_CALLBACK = interceptFieldCallback;
    }

    public RepoFolder $cglib_read_childrenFolder() {
        RepoFolder repoFolder = this.childrenFolder;
        if (this.getInterceptFieldCallback() == null) {
            return repoFolder;
        }
        RepoFolder repoFolder2 = repoFolder;
        return (RepoFolder)this.getInterceptFieldCallback().readObject((Object)this, "childrenFolder", (Object)repoFolder2);
    }

    public void $cglib_write_childrenFolder(RepoFolder repoFolder) {
        this.childrenFolder = this.getInterceptFieldCallback() != null ? (RepoFolder)this.getInterceptFieldCallback().writeObject((Object)this, "childrenFolder", (Object)this.childrenFolder, (Object)repoFolder) : repoFolder;
    }

    public Set $cglib_read_newChildren() {
        Set set = this.newChildren;
        if (this.getInterceptFieldCallback() == null) {
            return set;
        }
        Set set2 = set;
        return (Set)this.getInterceptFieldCallback().readObject((Object)this, "newChildren", (Object)set2);
    }

    public void $cglib_write_newChildren(Set set) {
        this.newChildren = this.getInterceptFieldCallback() != null ? (Set)this.getInterceptFieldCallback().writeObject((Object)this, "newChildren", (Object)this.newChildren, (Object)set) : set;
    }

    protected RepoResource() {
    }

    protected final ResourceReference getClientReference(RepoResource repoResource, ResourceFactory resourceFactory) {
        ResourceReference resourceReference;
        if (repoResource == null) {
            resourceReference = null;
        } else if (this.getChildrenFolder() != null && this.getChildrenFolder().equals(repoResource.getParent())) {
            Resource resource = (Resource)repoResource.toClient(resourceFactory);
            resourceReference = new ResourceReference(resource);
        } else {
            ResourceLookup resourceLookup = repoResource.toClientLookup();
            resourceReference = new ResourceReference(resourceLookup);
        }
        return resourceReference;
    }

    @Override
    public Object toClient(ResourceFactory resourceFactory) {
        return this.toClient(resourceFactory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toClient(ResourceFactory resourceFactory, Map map) {
        if (map != null) {
            clientOptions.set(map);
        }
        try {
            Resource resource = (Resource)super.toClient(resourceFactory);
            this.copyTo(resource, resourceFactory);
            Resource resource2 = resource;
            return resource2;
        }
        finally {
            if (map != null) {
                clientOptions.remove();
            }
        }
    }

    protected Map getClientOptions() {
        return (Map)clientOptions.get();
    }

    protected boolean hasClientOption(String string) {
        Map map = this.getClientOptions();
        return map != null && map.containsKey(string);
    }

    protected void copyTo(Resource resource, ResourceFactory resourceFactory) {
        super.copyTo(resource);
        if (this.hasClientOption(CLIENT_OPTION_AS_NEW)) {
            resource.setVersion(-1);
        }
    }

    public void copyFromClient(Resource resource, ReferenceResolver referenceResolver) {
        this.initNewChildren();
        this.copyFrom(resource, referenceResolver);
        this.filterChildren();
    }

    protected void copyFrom(Resource resource, ReferenceResolver referenceResolver) {
        super.copyFrom(resource);
    }

    protected void initNewChildren() {
        this.$cglib_write_newChildren(null);
    }

    public void addNewChild(RepoResource repoResource) {
        RepoFolder repoFolder = this.getChildrenFolder();
        repoResource.setParent(repoFolder);
        repoFolder.addChild(repoResource);
        if (this.$cglib_read_newChildren() == null) {
            this.$cglib_write_newChildren(new HashSet());
        }
        this.$cglib_read_newChildren().add(repoResource);
    }

    protected void filterChildren() {
        RepoFolder repoFolder = this.getChildrenFolder();
        if (repoFolder != null) {
            repoFolder.filterChildren(this.$cglib_read_newChildren());
        }
    }

    public RepoFolder getChildrenFolder() {
        return this.$cglib_read_childrenFolder();
    }

    public void setChildrenFolder(RepoFolder repoFolder) {
        this.$cglib_write_childrenFolder(repoFolder);
    }

    protected RepoResource getReference(ResourceReference resourceReference, Class clazz, ReferenceResolver referenceResolver) {
        return referenceResolver.getReference(this, resourceReference, clazz);
    }

    protected RepoResource getReference(Resource resource, Class clazz, ReferenceResolver referenceResolver) {
        return referenceResolver.getReference(this, resource, clazz);
    }

    public boolean equals(Object object) {
        if (!(object instanceof RepoResource)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.isNew()) {
            return super.equals(object);
        }
        RepoResource repoResource = (RepoResource)object;
        return new EqualsBuilder().append(this.getId(), repoResource.getId()).isEquals();
    }

    public int hashCode() {
        if (this.isNew()) {
            return super.hashCode();
        }
        return new HashCodeBuilder().append(this.getId()).toHashCode();
    }

    public String toString() {
        return this.getResourceURI();
    }

    @Override
    public void moveTo(RepoFolder repoFolder, RepoManager repoManager) {
        String string = this.getParent().getResourceURI();
        this.setParent(repoFolder);
        repoManager.update(this);
        RepoFolder repoFolder2 = this.getChildrenFolder();
        if (repoFolder2 != null) {
            repoFolder2.moveTo(repoFolder, repoManager);
        }
        this.moved(string, repoFolder.getResourceURI(), repoManager);
    }

    @Override
    protected void moved(String string, String string2, RepoManager repoManager) {
        repoManager.resourceMoved(this, string, string2);
    }

    static {
        RepoResource.CGLIB$STATICHOOK2();
        log = LogFactory.getLog(RepoResource.class);
        clientOptions = new ThreadLocal();
    }

    static void CGLIB$STATICHOOK2() {
    }
}

