/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ValidationError;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.ValidationErrorImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.util.ValidationUtil;

public abstract class BaseResourceValidator {
    private RepositoryService repository;

    protected void validateName(Resource resource, ValidationErrorFilter filter, ValidationErrors errors) {
        String nameField = this.getFieldPrefix() + "name";
        if (filter == null || filter.matchErrorField(nameField)) {
            if (resource.getName() == null || resource.getName().trim().length() == 0) {
                errors.add((ValidationError)new ValidationErrorImpl(this.getErrorMessagePrefix() + "error.not.empty", null, null, nameField));
            } else if (resource.getName().length() > 100) {
                errors.add((ValidationError)new ValidationErrorImpl(this.getErrorMessagePrefix() + "error.too.long", new Object[]{new Integer(100)}, null, nameField));
            } else if (!ValidationUtil.regExValidateName(resource.getName())) {
                errors.add((ValidationError)new ValidationErrorImpl(this.getErrorMessagePrefix() + "error.invalid.chars", null, null, nameField));
            } else if (filter != null && filter.matchErrorCode(this.getErrorMessagePrefix() + "error.duplicate") && this.getRepositoryService().repositoryPathExists(null, resource.getURIString())) {
                errors.add((ValidationError)new ValidationErrorImpl(this.getErrorMessagePrefix() + "error.duplicate", null, null, nameField));
            }
        }
    }

    protected void validateLabel(Resource resource, ValidationErrorFilter filter, ValidationErrors errors) {
        String labelField = this.getFieldPrefix() + "label";
        if (filter == null || filter.matchErrorField(labelField)) {
            if (resource.getLabel() == null || resource.getLabel().trim().length() == 0) {
                errors.add((ValidationError)new ValidationErrorImpl(this.getErrorMessagePrefix() + "error.not.empty", null, null, labelField));
            } else if (resource.getLabel().length() > 100) {
                errors.add((ValidationError)new ValidationErrorImpl(this.getErrorMessagePrefix() + "error.too.long", new Object[]{new Integer(100)}, null, labelField));
            }
        }
    }

    protected void validateDescription(Resource resource, ValidationErrorFilter filter, ValidationErrors errors) {
        String descriptionField = this.getFieldPrefix() + "description";
        if ((filter == null || filter.matchErrorField(descriptionField)) && resource.getDescription() != null && resource.getDescription().length() > 250) {
            errors.add((ValidationError)new ValidationErrorImpl(this.getErrorMessagePrefix() + "error.too.long", new Object[]{new Integer(250)}, null, descriptionField));
        }
    }

    protected abstract String getErrorMessagePrefix();

    protected abstract String getFieldPrefix();

    public RepositoryService getRepositoryService() {
        return this.repository;
    }

    public void setRepositoryService(RepositoryService repository) {
        this.repository = repository;
    }
}

