/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.report.impl;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.unitils.core.util.ObjectFormatter;
import org.unitils.mock.proxy.ProxyInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProxyInvocationsReport {
    public static int OBJECT_FORMATTER_MAX_RECURSION_DEPT = 10;
    public static int MAX_INLINE_PARAMETER_LENGTH = 20;
    protected ObjectFormatter objectFormatter = new ObjectFormatter(OBJECT_FORMATTER_MAX_RECURSION_DEPT);

    protected String formatInvokedAt(ProxyInvocation proxyInvocation) {
        return "  .....  at " + proxyInvocation.getInvokedAt();
    }

    protected String formatValue(Object object, Class<?> type, List<FormattedObject> currentLargeObjects, Map<Object, FormattedObject> allLargeObjects, Map<Class<?>, Integer> largeObjectNameIndexes) {
        if (allLargeObjects.containsKey(object)) {
            FormattedObject formattedObject = allLargeObjects.get(object);
            currentLargeObjects.add(formattedObject);
            return formattedObject.getName();
        }
        String objectRepresentation = this.objectFormatter.format(object);
        if (objectRepresentation.length() <= MAX_INLINE_PARAMETER_LENGTH) {
            return objectRepresentation;
        }
        String largeObjectName = this.createLargeValueName(type, largeObjectNameIndexes);
        FormattedObject formattedObject = new FormattedObject(largeObjectName, objectRepresentation);
        allLargeObjects.put(object, formattedObject);
        currentLargeObjects.add(formattedObject);
        return largeObjectName;
    }

    protected String createLargeValueName(Class<?> type, Map<Class<?>, Integer> largeObjectNameIndexes) {
        Integer index = largeObjectNameIndexes.get(type);
        if (index == null) {
            index = 0;
        }
        index = index + 1;
        largeObjectNameIndexes.put(type, index);
        String result = StringUtils.uncapitalize((String)type.getSimpleName());
        return result + index;
    }

    protected String formatInvocationIndex(int invocationIndex, int totalInvocationNumber) {
        int padSize = String.valueOf(totalInvocationNumber).length() + 2;
        return StringUtils.rightPad((String)(invocationIndex + "."), (int)padSize);
    }

    protected static class FormattedObject {
        private String name;
        private String representation;

        public FormattedObject(String name, String representation) {
            this.name = name;
            this.representation = representation;
        }

        public String getName() {
            return this.name;
        }

        public String getRepresentation() {
            return this.representation;
        }
    }
}

