/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.dbsupport;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.UnitilsException;
import org.unitils.core.dbsupport.SQLHandler;
import org.unitils.thirdparty.org.apache.commons.dbutils.DbUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSQLHandler
implements SQLHandler {
    private static Log logger = LogFactory.getLog(DefaultSQLHandler.class);
    private DataSource dataSource;
    private boolean doExecuteUpdates;

    public DefaultSQLHandler(DataSource dataSource) {
        this(dataSource, true);
    }

    public DefaultSQLHandler(DataSource dataSource, boolean doExecuteUpdates) {
        this.dataSource = dataSource;
        this.doExecuteUpdates = doExecuteUpdates;
    }

    @Override
    public int executeUpdate(String sql) {
        int n;
        logger.debug((Object)sql);
        if (!this.doExecuteUpdates) {
            return 0;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            n = statement.executeUpdate(sql);
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Error while performing database update: " + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, null);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, null);
        return n;
    }

    @Override
    public void executeQuery(String sql) {
        logger.debug((Object)sql);
        if (!this.doExecuteUpdates) {
            return;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Error while performing database update: " + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
    }

    @Override
    public int executeUpdateAndCommit(String sql) {
        int n;
        logger.debug((Object)sql);
        if (!this.doExecuteUpdates) {
            return 0;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            int nbChanges = statement.executeUpdate(sql);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            n = nbChanges;
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Error while performing database update: " + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, null);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, null);
        return n;
    }

    @Override
    public long getItemAsLong(String sql) {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block4: {
            long l;
            logger.debug((Object)sql);
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = this.dataSource.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(sql);
                if (!resultSet.next()) break block4;
                l = resultSet.getLong(1);
            }
            catch (Exception e) {
                try {
                    throw new UnitilsException("Error while executing statement: " + sql, e);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(connection, statement, resultSet);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly(connection, statement, resultSet);
            return l;
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
        throw new UnitilsException("No item value found: " + sql);
    }

    @Override
    public String getItemAsString(String sql) {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block4: {
            String string;
            logger.debug((Object)sql);
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = this.dataSource.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(sql);
                if (!resultSet.next()) break block4;
                string = resultSet.getString(1);
            }
            catch (Exception e) {
                try {
                    throw new UnitilsException("Error while executing statement: " + sql, e);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(connection, statement, resultSet);
                    throw throwable;
                }
            }
            DbUtils.closeQuietly(connection, statement, resultSet);
            return string;
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
        throw new UnitilsException("No item value found: " + sql);
    }

    @Override
    public Set<String> getItemsAsStringSet(String sql) {
        HashSet<String> hashSet;
        logger.debug((Object)sql);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            HashSet<String> result = new HashSet<String>();
            while (resultSet.next()) {
                result.add(resultSet.getString(1));
            }
            hashSet = result;
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Error while executing statement: " + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
        return hashSet;
    }

    @Override
    public boolean exists(String sql) {
        boolean bl;
        logger.debug((Object)sql);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sql);
            bl = resultSet.next();
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Error while executing statement: " + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
        return bl;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public boolean isDoExecuteUpdates() {
        return this.doExecuteUpdates;
    }
}

