/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.saxon8;

import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BarcodeException;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.BarcodeUtil;
import org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.krysalis.barcode4j.tools.ConfigurationUtil;
import org.w3c.dom.Node;

public class BarcodeStyleElement
extends StyleElement {
    private Expression message;
    private Expression orientation;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        String msgAtt = this.attributeList.getValue("", "message");
        if (msgAtt == null) {
            this.reportAbsence("message");
        }
        this.message = this.makeAttributeValueTemplate(msgAtt);
        String orientationAtt = this.attributeList.getValue("", "orientation");
        this.orientation = orientationAtt != null ? this.makeAttributeValueTemplate(orientationAtt) : null;
    }

    public void validate() throws XPathException {
        super.validate();
        this.checkWithinTemplate();
        this.message = this.typeCheck("message", this.message);
        if (this.orientation != null) {
            this.orientation = this.typeCheck("orientation", this.orientation);
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        NodeOverNodeInfo node = NodeOverNodeInfo.wrap((NodeInfo)this);
        Configuration cfg = ConfigurationUtil.buildConfiguration((Node)node);
        BarcodeExpression inst = new BarcodeExpression(this.message, this.orientation, cfg);
        return inst;
    }

    protected boolean isPermittedChild(StyleElement styleElement) {
        return true;
    }

    private static class BarcodeExpression
    extends SimpleExpression {
        private Expression message;
        private Expression orientation;
        private Configuration cfg;

        public BarcodeExpression(Expression message, Expression orientation, Configuration cfg) {
            this.message = message;
            this.orientation = orientation;
            this.cfg = cfg;
        }

        public int getImplementationMethod() {
            return 4;
        }

        public void process(XPathContext context) throws XPathException {
            String effMessage = this.message.evaluateAsString(context);
            int effOrientation = 0;
            if (this.orientation != null) {
                String s = this.orientation.evaluateAsString(context);
                try {
                    effOrientation = Integer.parseInt(s);
                    effOrientation = BarcodeDimension.normalizeOrientation(effOrientation);
                }
                catch (NumberFormatException nfe) {
                    throw new ValidationException((Exception)nfe);
                }
                catch (IllegalArgumentException iae) {
                    throw new ValidationException((Exception)iae);
                }
            }
            try {
                SequenceReceiver out = context.getReceiver();
                BarcodeGenerator gen = BarcodeUtil.getInstance().createBarcodeGenerator(this.cfg);
                SVGCanvasProvider svg = this.cfg.getAttributeAsBoolean("useNamespace", true) ? new SVGCanvasProvider(this.cfg.getAttribute("prefix", "svg"), effOrientation) : new SVGCanvasProvider(false, effOrientation);
                gen.generateBarcode(svg, effMessage);
                DocumentWrapper wrapper = new DocumentWrapper((Node)svg.getDOM(), "http://www.w3.org/2000/svg", context.getConfiguration());
                out.append((Item)wrapper, this.getLocationId(), 1);
            }
            catch (ConfigurationException ce) {
                throw new DynamicError("(Barcode4J) " + ce.getMessage());
            }
            catch (BarcodeException be) {
                throw new DynamicError("(Barcode4J) " + be.getMessage());
            }
        }
    }
}

