/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.rememberme;

import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.ui.rememberme.TokenBasedRememberMeServices;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.util.StringUtils;

public class TokenBasedRememberMeServicesTests
extends TestCase {
    public TokenBasedRememberMeServicesTests() {
    }

    public TokenBasedRememberMeServicesTests(String arg0) {
        super(arg0);
    }

    private long determineExpiryTimeFromBased64EncodedToken(String validToken) {
        String cookieAsPlainText = new String(Base64.decodeBase64((byte[])validToken.getBytes()));
        String[] cookieTokens = StringUtils.delimitedListToStringArray((String)cookieAsPlainText, (String)":");
        if (cookieTokens.length == 3) {
            try {
                return new Long(cookieTokens[1]);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return -1L;
    }

    private String generateCorrectCookieContentForToken(long expiryTime, String username, String password, String key) {
        String signatureValue = new String(DigestUtils.md5Hex((String)(username + ":" + expiryTime + ":" + password + ":" + key)));
        String tokenValue = username + ":" + expiryTime + ":" + signatureValue;
        String tokenValueBase64 = new String(Base64.encodeBase64((byte[])tokenValue.getBytes()));
        return tokenValueBase64;
    }

    public void testAutoLoginIfDoesNotPresentAnyCookies() throws Exception {
        TokenBasedRememberMeServices services = new TokenBasedRememberMeServices();
        services.setKey("key");
        services.setUserDetailsService((UserDetailsService)new MockAuthenticationDao(null, true));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("dc");
        MockHttpServletResponse response = new MockHttpServletResponse();
        Authentication result = services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        TokenBasedRememberMeServicesTests.assertNull((Object)result);
        Cookie returnedCookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        TokenBasedRememberMeServicesTests.assertNull((Object)returnedCookie);
    }

    public void testAutoLoginIfDoesNotPresentRequiredCookie() throws Exception {
        TokenBasedRememberMeServices services = new TokenBasedRememberMeServices();
        services.setKey("key");
        services.setUserDetailsService((UserDetailsService)new MockAuthenticationDao(null, true));
        Cookie cookie = new Cookie("unrelated_cookie", "foobar");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        Authentication result = services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        TokenBasedRememberMeServicesTests.assertNull((Object)result);
        Cookie returnedCookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        TokenBasedRememberMeServicesTests.assertNull((Object)returnedCookie);
    }

    public void testAutoLoginIfExpired() throws Exception {
        User user = new User("someone", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ABC")});
        TokenBasedRememberMeServices services = new TokenBasedRememberMeServices();
        services.setKey("key");
        services.setUserDetailsService((UserDetailsService)new MockAuthenticationDao((UserDetails)user, false));
        Cookie cookie = new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", this.generateCorrectCookieContentForToken(System.currentTimeMillis() - 1000000L, "someone", "password", "key"));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        Authentication result = services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        TokenBasedRememberMeServicesTests.assertNull((Object)result);
        Cookie returnedCookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        TokenBasedRememberMeServicesTests.assertNotNull((Object)returnedCookie);
        TokenBasedRememberMeServicesTests.assertEquals((int)0, (int)returnedCookie.getMaxAge());
    }

    public void testAutoLoginIfMissingThreeTokensInCookieValue() throws Exception {
        User user = new User("someone", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ABC")});
        TokenBasedRememberMeServices services = new TokenBasedRememberMeServices();
        services.setKey("key");
        services.setUserDetailsService((UserDetailsService)new MockAuthenticationDao((UserDetails)user, false));
        Cookie cookie = new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", new String(Base64.encodeBase64((byte[])"x".getBytes())));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        Authentication result = services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        TokenBasedRememberMeServicesTests.assertNull((Object)result);
        Cookie returnedCookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        TokenBasedRememberMeServicesTests.assertNotNull((Object)returnedCookie);
        TokenBasedRememberMeServicesTests.assertEquals((int)0, (int)returnedCookie.getMaxAge());
    }

    public void testAutoLoginIfNotBase64Encoded() throws Exception {
        User user = new User("someone", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ABC")});
        TokenBasedRememberMeServices services = new TokenBasedRememberMeServices();
        services.setKey("key");
        services.setUserDetailsService((UserDetailsService)new MockAuthenticationDao((UserDetails)user, false));
        Cookie cookie = new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", "NOT_BASE_64_ENCODED");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        Authentication result = services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        TokenBasedRememberMeServicesTests.assertNull((Object)result);
        Cookie returnedCookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        TokenBasedRememberMeServicesTests.assertNotNull((Object)returnedCookie);
        TokenBasedRememberMeServicesTests.assertEquals((int)0, (int)returnedCookie.getMaxAge());
    }

    public void testAutoLoginIfSignatureBlocksDoesNotMatchExpectedValue() throws Exception {
        User user = new User("someone", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ABC")});
        TokenBasedRememberMeServices services = new TokenBasedRememberMeServices();
        services.setKey("key");
        services.setUserDetailsService((UserDetailsService)new MockAuthenticationDao((UserDetails)user, false));
        Cookie cookie = new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", this.generateCorrectCookieContentForToken(System.currentTimeMillis() + 1000000L, "someone", "password", "WRONG_KEY"));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        Authentication result = services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        TokenBasedRememberMeServicesTests.assertNull((Object)result);
        Cookie returnedCookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        TokenBasedRememberMeServicesTests.assertNotNull((Object)returnedCookie);
        TokenBasedRememberMeServicesTests.assertEquals((int)0, (int)returnedCookie.getMaxAge());
    }

    public void testAutoLoginIfTokenDoesNotContainANumberInCookieValue() throws Exception {
        User user = new User("someone", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ABC")});
        TokenBasedRememberMeServices services = new TokenBasedRememberMeServices();
        services.setKey("key");
        services.setUserDetailsService((UserDetailsService)new MockAuthenticationDao((UserDetails)user, false));
        Cookie cookie = new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", new String(Base64.encodeBase64((byte[])"username:NOT_A_NUMBER:signature".getBytes())));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        Authentication result = services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        TokenBasedRememberMeServicesTests.assertNull((Object)result);
        Cookie returnedCookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        TokenBasedRememberMeServicesTests.assertNotNull((Object)returnedCookie);
        TokenBasedRememberMeServicesTests.assertEquals((int)0, (int)returnedCookie.getMaxAge());
    }

    public void testAutoLoginIfUserNotFound() throws Exception {
        TokenBasedRememberMeServices services = new TokenBasedRememberMeServices();
        services.setKey("key");
        services.setUserDetailsService((UserDetailsService)new MockAuthenticationDao(null, true));
        Cookie cookie = new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", this.generateCorrectCookieContentForToken(System.currentTimeMillis() + 1000000L, "someone", "password", "key"));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        Authentication result = services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        TokenBasedRememberMeServicesTests.assertNull((Object)result);
        Cookie returnedCookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        TokenBasedRememberMeServicesTests.assertNotNull((Object)returnedCookie);
        TokenBasedRememberMeServicesTests.assertEquals((int)0, (int)returnedCookie.getMaxAge());
    }

    public void testAutoLoginWithValidToken() throws Exception {
        User user = new User("someone", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ABC")});
        TokenBasedRememberMeServices services = new TokenBasedRememberMeServices();
        services.setKey("key");
        services.setUserDetailsService((UserDetailsService)new MockAuthenticationDao((UserDetails)user, false));
        Cookie cookie = new Cookie("SPRING_SECURITY_REMEMBER_ME_COOKIE", this.generateCorrectCookieContentForToken(System.currentTimeMillis() + 1000000L, "someone", "password", "key"));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setCookies(new Cookie[]{cookie});
        MockHttpServletResponse response = new MockHttpServletResponse();
        Authentication result = services.autoLogin((HttpServletRequest)request, (HttpServletResponse)response);
        TokenBasedRememberMeServicesTests.assertNotNull((Object)result);
        UserDetails resultingUserDetails = (UserDetails)result.getPrincipal();
        TokenBasedRememberMeServicesTests.assertEquals((Object)user, (Object)resultingUserDetails);
    }

    public void testGettersSetters() {
        TokenBasedRememberMeServices services = new TokenBasedRememberMeServices();
        services.setUserDetailsService((UserDetailsService)new MockAuthenticationDao(null, false));
        TokenBasedRememberMeServicesTests.assertTrue((services.getUserDetailsService() != null ? 1 : 0) != 0);
        services.setKey("d");
        TokenBasedRememberMeServicesTests.assertEquals((String)"d", (String)services.getKey());
        TokenBasedRememberMeServicesTests.assertEquals((String)"_spring_security_remember_me", (String)services.getParameter());
        services.setParameter("some_param");
        TokenBasedRememberMeServicesTests.assertEquals((String)"some_param", (String)services.getParameter());
        services.setTokenValiditySeconds(12);
        TokenBasedRememberMeServicesTests.assertEquals((int)12, (int)services.getTokenValiditySeconds());
    }

    public void testLoginFail() {
        TokenBasedRememberMeServices services = new TokenBasedRememberMeServices();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("fv");
        MockHttpServletResponse response = new MockHttpServletResponse();
        services.loginFail((HttpServletRequest)request, (HttpServletResponse)response);
        Cookie cookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        TokenBasedRememberMeServicesTests.assertNotNull((Object)cookie);
        TokenBasedRememberMeServicesTests.assertEquals((int)0, (int)cookie.getMaxAge());
    }

    public void testLoginSuccessIgnoredIfParameterNotSetOrFalse() {
        TokenBasedRememberMeServices services = new TokenBasedRememberMeServices();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("d");
        request.addParameter("_spring_security_remember_me", "false");
        MockHttpServletResponse response = new MockHttpServletResponse();
        services.loginSuccess((HttpServletRequest)request, (HttpServletResponse)response, (Authentication)new TestingAuthenticationToken((Object)"someone", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ABC")}));
        Cookie cookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        TokenBasedRememberMeServicesTests.assertNull((Object)cookie);
    }

    public void testLoginSuccessNormalWithNonUserDetailsBasedPrincipal() {
        TokenBasedRememberMeServices services = new TokenBasedRememberMeServices();
        services.setTokenValiditySeconds(500000000);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("d");
        request.addParameter("_spring_security_remember_me", "true");
        MockHttpServletResponse response = new MockHttpServletResponse();
        services.loginSuccess((HttpServletRequest)request, (HttpServletResponse)response, (Authentication)new TestingAuthenticationToken((Object)"someone", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ABC")}));
        Cookie cookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        String expiryTime = services.decodeCookie(cookie.getValue())[1];
        long expectedExpiryTime = 500000000000L;
        TokenBasedRememberMeServicesTests.assertTrue((Long.parseLong(expiryTime) > (expectedExpiryTime += System.currentTimeMillis()) - 10000L ? 1 : 0) != 0);
        TokenBasedRememberMeServicesTests.assertNotNull((Object)cookie);
        TokenBasedRememberMeServicesTests.assertEquals((int)services.getTokenValiditySeconds(), (int)cookie.getMaxAge());
        TokenBasedRememberMeServicesTests.assertTrue((boolean)Base64.isArrayByteBase64((byte[])cookie.getValue().getBytes()));
        TokenBasedRememberMeServicesTests.assertTrue((boolean)new Date().before(new Date(this.determineExpiryTimeFromBased64EncodedToken(cookie.getValue()))));
    }

    public void testLoginSuccessNormalWithUserDetailsBasedPrincipal() {
        TokenBasedRememberMeServices services = new TokenBasedRememberMeServices();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("d");
        request.addParameter("_spring_security_remember_me", "true");
        MockHttpServletResponse response = new MockHttpServletResponse();
        User user = new User("someone", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ABC")});
        services.loginSuccess((HttpServletRequest)request, (HttpServletResponse)response, (Authentication)new TestingAuthenticationToken((Object)user, (Object)"ignored", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ABC")}));
        Cookie cookie = response.getCookie("SPRING_SECURITY_REMEMBER_ME_COOKIE");
        TokenBasedRememberMeServicesTests.assertNotNull((Object)cookie);
        TokenBasedRememberMeServicesTests.assertEquals((int)services.getTokenValiditySeconds(), (int)cookie.getMaxAge());
        TokenBasedRememberMeServicesTests.assertTrue((boolean)Base64.isArrayByteBase64((byte[])cookie.getValue().getBytes()));
        TokenBasedRememberMeServicesTests.assertTrue((boolean)new Date().before(new Date(this.determineExpiryTimeFromBased64EncodedToken(cookie.getValue()))));
    }

    private class MockAuthenticationDao
    implements UserDetailsService {
        private UserDetails toReturn;
        private boolean throwException;

        public MockAuthenticationDao(UserDetails toReturn, boolean throwException) {
            this.toReturn = toReturn;
            this.throwException = throwException;
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if (this.throwException) {
                throw new UsernameNotFoundException("as requested by mock");
            }
            return this.toReturn;
        }
    }
}

