/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.securechannel;

import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.MockPortResolver;
import org.springframework.security.securechannel.RetryWithHttpEntryPoint;
import org.springframework.security.util.PortMapper;
import org.springframework.security.util.PortMapperImpl;
import org.springframework.security.util.PortResolver;

public class RetryWithHttpEntryPointTests
extends TestCase {
    public void testDetectsMissingPortMapper() throws Exception {
        RetryWithHttpEntryPoint ep = new RetryWithHttpEntryPoint();
        try {
            ep.setPortMapper(null);
            RetryWithHttpEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDetectsMissingPortResolver() throws Exception {
        RetryWithHttpEntryPoint ep = new RetryWithHttpEntryPoint();
        try {
            ep.setPortResolver(null);
            RetryWithHttpEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGettersSetters() {
        RetryWithHttpEntryPoint ep = new RetryWithHttpEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(8080, 8443));
        RetryWithHttpEntryPointTests.assertTrue((ep.getPortMapper() != null ? 1 : 0) != 0);
        RetryWithHttpEntryPointTests.assertTrue((ep.getPortResolver() != null ? 1 : 0) != 0);
    }

    public void testNormalOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("open=true");
        request.setScheme("https");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServletPath("/hello");
        request.setPathInfo("/pathInfo.html");
        request.setServerPort(443);
        MockHttpServletResponse response = new MockHttpServletResponse();
        RetryWithHttpEntryPoint ep = new RetryWithHttpEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.commence((ServletRequest)request, (ServletResponse)response);
        RetryWithHttpEntryPointTests.assertEquals((String)"http://www.example.com/bigWebApp/hello/pathInfo.html?open=true", (String)response.getRedirectedUrl());
    }

    public void testNormalOperationWithNullPathInfoAndNullQueryString() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("https");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServletPath("/hello");
        request.setPathInfo(null);
        request.setServerPort(443);
        MockHttpServletResponse response = new MockHttpServletResponse();
        RetryWithHttpEntryPoint ep = new RetryWithHttpEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.commence((ServletRequest)request, (ServletResponse)response);
        RetryWithHttpEntryPointTests.assertEquals((String)"http://www.example.com/bigWebApp/hello", (String)response.getRedirectedUrl());
    }

    public void testOperationWhenTargetPortIsUnknown() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("open=true");
        request.setScheme("https");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServletPath("/hello");
        request.setPathInfo("/pathInfo.html");
        request.setServerPort(8768);
        MockHttpServletResponse response = new MockHttpServletResponse();
        RetryWithHttpEntryPoint ep = new RetryWithHttpEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(8768, 1234));
        ep.commence((ServletRequest)request, (ServletResponse)response);
        RetryWithHttpEntryPointTests.assertEquals((String)"/bigWebApp", (String)response.getRedirectedUrl());
    }

    public void testOperationWithNonStandardPort() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("open=true");
        request.setScheme("https");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServletPath("/hello");
        request.setPathInfo("/pathInfo.html");
        request.setServerPort(9999);
        MockHttpServletResponse response = new MockHttpServletResponse();
        PortMapperImpl portMapper = new PortMapperImpl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("8888", "9999");
        portMapper.setPortMappings(map);
        RetryWithHttpEntryPoint ep = new RetryWithHttpEntryPoint();
        ep.setPortResolver((PortResolver)new MockPortResolver(8888, 9999));
        ep.setPortMapper((PortMapper)portMapper);
        ep.commence((ServletRequest)request, (ServletResponse)response);
        RetryWithHttpEntryPointTests.assertEquals((String)"http://www.example.com:8888/bigWebApp/hello/pathInfo.html?open=true", (String)response.getRedirectedUrl());
    }
}

