/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.rcp;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.rcp.RemoteAuthenticationException;
import org.springframework.security.providers.rcp.RemoteAuthenticationManager;
import org.springframework.security.providers.rcp.RemoteAuthenticationProvider;

public class RemoteAuthenticationProviderTests
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(RemoteAuthenticationProviderTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testExceptionsGetPassedBackToCaller() {
        RemoteAuthenticationProvider provider = new RemoteAuthenticationProvider();
        provider.setRemoteAuthenticationManager((RemoteAuthenticationManager)new MockRemoteAuthenticationManager(false));
        try {
            provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"password"));
            RemoteAuthenticationProviderTests.fail((String)"Should have thrown RemoteAuthenticationException");
        }
        catch (RemoteAuthenticationException expected) {
            RemoteAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() {
        RemoteAuthenticationProvider provider = new RemoteAuthenticationProvider();
        provider.setRemoteAuthenticationManager((RemoteAuthenticationManager)new MockRemoteAuthenticationManager(true));
        RemoteAuthenticationProviderTests.assertNotNull((Object)provider.getRemoteAuthenticationManager());
    }

    public void testStartupChecksAuthenticationManagerSet() throws Exception {
        RemoteAuthenticationProvider provider = new RemoteAuthenticationProvider();
        try {
            provider.afterPropertiesSet();
            RemoteAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RemoteAuthenticationProviderTests.assertTrue((boolean)true);
        }
        provider.setRemoteAuthenticationManager((RemoteAuthenticationManager)new MockRemoteAuthenticationManager(true));
        provider.afterPropertiesSet();
        RemoteAuthenticationProviderTests.assertTrue((boolean)true);
    }

    public void testSuccessfulAuthenticationCreatesObject() {
        RemoteAuthenticationProvider provider = new RemoteAuthenticationProvider();
        provider.setRemoteAuthenticationManager((RemoteAuthenticationManager)new MockRemoteAuthenticationManager(true));
        Authentication result = provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"password"));
        RemoteAuthenticationProviderTests.assertEquals((Object)"rod", (Object)result.getPrincipal());
        RemoteAuthenticationProviderTests.assertEquals((Object)"password", (Object)result.getCredentials());
        RemoteAuthenticationProviderTests.assertEquals((String)"foo", (String)result.getAuthorities()[0].getAuthority());
    }

    public void testSupports() {
        RemoteAuthenticationProvider provider = new RemoteAuthenticationProvider();
        RemoteAuthenticationProviderTests.assertTrue((boolean)provider.supports(UsernamePasswordAuthenticationToken.class));
    }

    private class MockRemoteAuthenticationManager
    implements RemoteAuthenticationManager {
        private boolean grantAccess;

        public MockRemoteAuthenticationManager(boolean grantAccess) {
            this.grantAccess = grantAccess;
        }

        public GrantedAuthority[] attemptAuthentication(String username, String password) throws RemoteAuthenticationException {
            if (this.grantAccess) {
                return new GrantedAuthority[]{new GrantedAuthorityImpl("foo")};
            }
            throw new RemoteAuthenticationException("as requested");
        }
    }
}

